/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mod.reborn.server.api.SubBlocksBlock;
import mod.reborn.server.block.AmberBlock;
import mod.reborn.server.block.BasicBlock;
import mod.reborn.server.block.BugCrateBlock;
import mod.reborn.server.block.ClearGlassBlock;
import mod.reborn.server.block.DisplayBlock;
import mod.reborn.server.block.EncasedFossilBlock;
import mod.reborn.server.block.FossilBlock;
import mod.reborn.server.block.FossilizedTrackwayBlock;
import mod.reborn.server.block.GypsumStoneBlock;
import mod.reborn.server.block.IceAgeShardBlock;
import mod.reborn.server.block.IceShardBlock;
import mod.reborn.server.block.NestFossilBlock;
import mod.reborn.server.block.PaleoBaleBlock;
import mod.reborn.server.block.PeatBlock;
import mod.reborn.server.block.PeatMossBlock;
import mod.reborn.server.block.PlantFossilBlock;
import mod.reborn.server.block.ReinforcedDoorBlock;
import mod.reborn.server.block.SecurityDoorBlock;
import mod.reborn.server.block.SkullDisplay;
import mod.reborn.server.block.SwarmBlock;
import mod.reborn.server.block.TourRailBlock;
import mod.reborn.server.block.entity.BugCrateBlockEntity;
import mod.reborn.server.block.entity.CleaningStationBlockEntity;
import mod.reborn.server.block.entity.CultivatorBlockEntity;
import mod.reborn.server.block.entity.DNACombinatorHybridizerBlockEntity;
import mod.reborn.server.block.entity.DNAExtractorBlockEntity;
import mod.reborn.server.block.entity.DNASequencerBlockEntity;
import mod.reborn.server.block.entity.DNASynthesizerBlockEntity;
import mod.reborn.server.block.entity.DisplayBlockEntity;
import mod.reborn.server.block.entity.ElectricFenceBaseBlockEntity;
import mod.reborn.server.block.entity.ElectricFencePoleBlockEntity;
import mod.reborn.server.block.entity.ElectricFenceWireBlockEntity;
import mod.reborn.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import mod.reborn.server.block.entity.EmbryonicMachineBlockEntity;
import mod.reborn.server.block.entity.FeederBlockEntity;
import mod.reborn.server.block.entity.FossilGrinderBlockEntity;
import mod.reborn.server.block.entity.IncubatorBlockEntity;
import mod.reborn.server.block.entity.SkullDisplayEntity;
import mod.reborn.server.block.entity.TourRailBlockEntity;
import mod.reborn.server.block.fence.ElectricFenceBaseBlock;
import mod.reborn.server.block.fence.ElectricFencePoleBlock;
import mod.reborn.server.block.fence.ElectricFenceWireBlock;
import mod.reborn.server.block.fence.FenceType;
import mod.reborn.server.block.machine.CleaningStationBlock;
import mod.reborn.server.block.machine.CultivatorBottomBlock;
import mod.reborn.server.block.machine.CultivatorTopBlock;
import mod.reborn.server.block.machine.DNACombinatorHybridizerBlock;
import mod.reborn.server.block.machine.DNAExtractorBlock;
import mod.reborn.server.block.machine.DNASequencerBlock;
import mod.reborn.server.block.machine.DNASynthesizerBlock;
import mod.reborn.server.block.machine.EmbryoCalcificationMachineBlock;
import mod.reborn.server.block.machine.EmbryonicMachineBlock;
import mod.reborn.server.block.machine.FeederBlock;
import mod.reborn.server.block.machine.FossilGrinderBlock;
import mod.reborn.server.block.machine.IncubatorBlock;
import mod.reborn.server.block.machine.SkeletonAssemblyBlock;
import mod.reborn.server.block.plant.AjuginuculaSmithiiBlock;
import mod.reborn.server.block.plant.AncientCoralBlock;
import mod.reborn.server.block.plant.AncientPlantBlock;
import mod.reborn.server.block.plant.BennettitaleanCycadeoideaBlock;
import mod.reborn.server.block.plant.CycadZamitesBlock;
import mod.reborn.server.block.plant.DicksoniaBlock;
import mod.reborn.server.block.plant.DicroidiumZuberiBlock;
import mod.reborn.server.block.plant.DictyophyllumBlock;
import mod.reborn.server.block.plant.DoublePlantBlock;
import mod.reborn.server.block.plant.EncephalartosBlock;
import mod.reborn.server.block.plant.GracilariaBlock;
import mod.reborn.server.block.plant.LiriodendritesBlock;
import mod.reborn.server.block.plant.MossBlock;
import mod.reborn.server.block.plant.OrontiumMackiiBlock;
import mod.reborn.server.block.plant.RaphaeliaBlock;
import mod.reborn.server.block.plant.RhamnusSalifocifusBlock;
import mod.reborn.server.block.plant.ScalyTreeFernBlock;
import mod.reborn.server.block.plant.SerennaVeriformansBlock;
import mod.reborn.server.block.plant.SmallChainFernBlock;
import mod.reborn.server.block.plant.SmallCycadBlock;
import mod.reborn.server.block.plant.SmallPlantBlock;
import mod.reborn.server.block.plant.SmallRoyalFernBlock;
import mod.reborn.server.block.plant.UmaltolepisBlock;
import mod.reborn.server.block.plant.WestIndianLilacBlock;
import mod.reborn.server.block.plant.WildOnionBlock;
import mod.reborn.server.block.plant.WildPotatoBlock;
import mod.reborn.server.block.tree.AncientDoorBlock;
import mod.reborn.server.block.tree.AncientDoubleSlabBlock;
import mod.reborn.server.block.tree.AncientFenceBlock;
import mod.reborn.server.block.tree.AncientFenceGateBlock;
import mod.reborn.server.block.tree.AncientLeavesBlock;
import mod.reborn.server.block.tree.AncientLogBlock;
import mod.reborn.server.block.tree.AncientPlanksBlock;
import mod.reborn.server.block.tree.AncientSaplingBlock;
import mod.reborn.server.block.tree.AncientSlabHalfBlock;
import mod.reborn.server.block.tree.AncientStairsBlock;
import mod.reborn.server.block.tree.TreeType;
import mod.reborn.server.conf.RebornConfig;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.util.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class BlockHandler {
    public static final Map<TreeType, AncientPlanksBlock> ANCIENT_PLANKS = new HashMap<TreeType, AncientPlanksBlock>();
    public static final Map<TreeType, AncientLogBlock> ANCIENT_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final Map<TreeType, AncientLeavesBlock> ANCIENT_LEAVES = new HashMap<TreeType, AncientLeavesBlock>();
    public static final Map<TreeType, AncientSaplingBlock> ANCIENT_SAPLINGS = new HashMap<TreeType, AncientSaplingBlock>();
    public static final Map<TreeType, AncientSlabHalfBlock> ANCIENT_SLABS = new HashMap<TreeType, AncientSlabHalfBlock>();
    public static final Map<TreeType, AncientDoubleSlabBlock> ANCIENT_DOUBLE_SLABS = new HashMap<TreeType, AncientDoubleSlabBlock>();
    public static final Map<TreeType, AncientStairsBlock> ANCIENT_STAIRS = new HashMap<TreeType, AncientStairsBlock>();
    public static final Map<TreeType, AncientFenceBlock> ANCIENT_FENCES = new HashMap<TreeType, AncientFenceBlock>();
    public static final Map<TreeType, AncientFenceGateBlock> ANCIENT_FENCE_GATES = new HashMap<TreeType, AncientFenceGateBlock>();
    public static final Map<TreeType, AncientDoorBlock> ANCIENT_DOORS = new HashMap<TreeType, AncientDoorBlock>();
    public static final Map<TreeType, AncientLogBlock> PETRIFIED_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final List<FossilBlock> FOSSILS = new ArrayList<FossilBlock>();
    public static final List<EncasedFossilBlock> ENCASED_FOSSILS = new ArrayList<EncasedFossilBlock>();
    public static final PlantFossilBlock PLANT_FOSSIL = new PlantFossilBlock();
    public static final CleaningStationBlock CLEANING_STATION = new CleaningStationBlock();
    public static final FossilGrinderBlock FOSSIL_GRINDER = new FossilGrinderBlock();
    public static final DNASequencerBlock DNA_SEQUENCER = new DNASequencerBlock();
    public static final DNASynthesizerBlock DNA_SYNTHESIZER = new DNASynthesizerBlock();
    public static final EmbryonicMachineBlock EMBRYONIC_MACHINE = new EmbryonicMachineBlock();
    public static final EmbryoCalcificationMachineBlock EMBRYO_CALCIFICATION_MACHINE = new EmbryoCalcificationMachineBlock();
    public static final IncubatorBlock INCUBATOR = new IncubatorBlock();
    public static final DNAExtractorBlock DNA_EXTRACTOR = new DNAExtractorBlock();
    public static final DNACombinatorHybridizerBlock DNA_COMBINATOR_HYBRIDIZER = new DNACombinatorHybridizerBlock();
    public static final AmberBlock AMBER_ORE = new AmberBlock();
    public static final IceShardBlock ICE_SHARD = new IceShardBlock();
    public static final IceAgeShardBlock ICE_AGE_SHARD = new IceAgeShardBlock();
    public static final GypsumStoneBlock GYPSUM_STONE = new GypsumStoneBlock();
    public static final Block GYPSUM_COBBLESTONE = new BasicBlock(Material.field_151576_e).func_149711_c(1.5f);
    public static final Block GYPSUM_COBBLESTONE_PATHWAY = new BasicBlock(Material.field_151576_e).func_149711_c(1.5f);
    public static final Block GYPSUM_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block GYPSUM_PATHWAY = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block GYPSUM_MIXED_PATH = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block GYPSUM_TILES = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REFINED_GYPSUM_PANEL = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block GYPSUM_STONE_PANEL = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_STONE = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_STONE_TILES = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_STONE_PATHWAY = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(3.0f);
    public static final Block REINFORCED_STONE_PANEL = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_DOOR = new ReinforcedDoorBlock();
    public static final Block SECURITY_DOOR = new SecurityDoorBlock();
    public static final CultivatorTopBlock CULTIVATOR_TOP = new CultivatorTopBlock();
    public static final CultivatorBottomBlock CULTIVATOR_BOTTOM = new CultivatorBottomBlock();
    public static final DisplayBlock DISPLAY_BLOCK = new DisplayBlock();
    public static final ClearGlassBlock CLEAR_GLASS = new ClearGlassBlock();
    public static final FossilizedTrackwayBlock FOSSILIZED_TRACKWAY = new FossilizedTrackwayBlock();
    public static final NestFossilBlock NEST_FOSSIL = new NestFossilBlock(false);
    public static final NestFossilBlock ENCASED_NEST_FOSSIL = new NestFossilBlock(true);
    public static final SmallRoyalFernBlock SMALL_ROYAL_FERN = new SmallRoyalFernBlock();
    public static final SmallChainFernBlock SMALL_CHAIN_FERN = new SmallChainFernBlock();
    public static final SmallCycadBlock SMALL_CYCAD = new SmallCycadBlock();
    public static final BennettitaleanCycadeoideaBlock CYCADEOIDEA = new BennettitaleanCycadeoideaBlock();
    public static final AncientPlantBlock CRY_PANSY = new AncientPlantBlock();
    public static final ScalyTreeFernBlock SCALY_TREE_FERN = new ScalyTreeFernBlock();
    public static final CycadZamitesBlock ZAMITES = new CycadZamitesBlock();
    public static final DicksoniaBlock DICKSONIA = new DicksoniaBlock();
    public static final DicroidiumZuberiBlock DICROIDIUM_ZUBERI = new DicroidiumZuberiBlock();
    public static final AjuginuculaSmithiiBlock AJUGINUCULA_SMITHII = new AjuginuculaSmithiiBlock();
    public static final WildOnionBlock WILD_ONION = new WildOnionBlock();
    public static final GracilariaBlock GRACILARIA = new GracilariaBlock();
    public static final DictyophyllumBlock DICTYOPHYLLUM = new DictyophyllumBlock();
    public static final WestIndianLilacBlock WEST_INDIAN_LILAC = new WestIndianLilacBlock();
    public static final SerennaVeriformansBlock SERENNA_VERIFORMANS = new SerennaVeriformansBlock();
    public static final SmallPlantBlock LADINIA_SIMPLEX = new SmallPlantBlock();
    public static final OrontiumMackiiBlock ORONTIUM_MACKII = new OrontiumMackiiBlock();
    public static final UmaltolepisBlock UMALTOLEPIS = new UmaltolepisBlock();
    public static final LiriodendritesBlock LIRIODENDRITES = new LiriodendritesBlock();
    public static final RaphaeliaBlock RAPHAELIA = new RaphaeliaBlock();
    public static final EncephalartosBlock ENCEPHALARTOS = new EncephalartosBlock();
    public static final WildPotatoBlock WILD_POTATO_PLANT = new WildPotatoBlock();
    public static final RhamnusSalifocifusBlock RHAMNUS_SALICIFOLIUS_PLANT = new RhamnusSalifocifusBlock();
    public static final SmallPlantBlock CINNAMON_FERN = new SmallPlantBlock();
    public static final SmallPlantBlock BRISTLE_FERN = new SmallPlantBlock();
    public static final DoublePlantBlock TEMPSKYA = new DoublePlantBlock();
    public static final SmallPlantBlock WOOLLY_STALKED_BEGONIA = new SmallPlantBlock();
    public static final SmallPlantBlock LARGESTIPULE_LEATHER_ROOT = new SmallPlantBlock();
    public static final DoublePlantBlock RHACOPHYTON = new DoublePlantBlock();
    public static final DoublePlantBlock GRAMINIDITES_BAMBUSOIDES = new DoublePlantBlock();
    public static final DoublePlantBlock HELICONIA = new DoublePlantBlock();
    public static final AncientCoralBlock ENALLHELIA = new AncientCoralBlock();
    public static final AncientCoralBlock AULOPORA = new AncientCoralBlock();
    public static final AncientCoralBlock CLADOCHONUS = new AncientCoralBlock();
    public static final AncientCoralBlock LITHOSTROTION = new AncientCoralBlock();
    public static final AncientCoralBlock STYLOPHYLLOPSIS = new AncientCoralBlock();
    public static final AncientCoralBlock HIPPURITES_RADIOSUS = new AncientCoralBlock();
    public static final PeatBlock PEAT = new PeatBlock();
    public static final Block PEAT_MOSS = new PeatMossBlock();
    public static final MossBlock MOSS = new MossBlock();
    public static final FeederBlock FEEDER = new FeederBlock();
    public static final BugCrateBlock BUG_CRATE = new BugCrateBlock();
    public static final SkullDisplay SKULL_DISPLAY = new SkullDisplay();
    public static final SwarmBlock PLANKTON_SWARM = new SwarmBlock(() -> ItemHandler.PLANKTON);
    public static final SwarmBlock KRILL_SWARM = new SwarmBlock(() -> ItemHandler.KRILL);
    public static final TourRailBlock TOUR_RAIL = new TourRailBlock(TourRailBlock.SpeedType.NONE);
    public static final TourRailBlock TOUR_RAIL_SLOW = new TourRailBlock(TourRailBlock.SpeedType.SLOW);
    public static final TourRailBlock TOUR_RAIL_MEDIUM = new TourRailBlock(TourRailBlock.SpeedType.MEDIUM);
    public static final TourRailBlock TOUR_RAIL_FAST = new TourRailBlock(TourRailBlock.SpeedType.FAST);
    public static final SkeletonAssemblyBlock SKELETON_ASSEMBLY = new SkeletonAssemblyBlock();
    public static ElectricFencePoleBlock LOW_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.LOW);
    public static ElectricFencePoleBlock MED_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.MED);
    public static ElectricFencePoleBlock HIGH_SECURITY_FENCE_POLE = new ElectricFencePoleBlock(FenceType.HIGH);
    public static ElectricFenceBaseBlock LOW_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.LOW);
    public static ElectricFenceBaseBlock MED_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.MED);
    public static ElectricFenceBaseBlock HIGH_SECURITY_FENCE_BASE = new ElectricFenceBaseBlock(FenceType.HIGH);
    public static ElectricFenceWireBlock LOW_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.LOW);
    public static ElectricFenceWireBlock MED_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.MED);
    public static ElectricFenceWireBlock HIGH_SECURITY_FENCE_WIRE = new ElectricFenceWireBlock(FenceType.HIGH);
    public static PaleoBaleBlock PALEO_BALE_CYCADEOIDEA = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCADEOIDEA);
    public static PaleoBaleBlock PALEO_BALE_CYCAD = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCAD);
    public static PaleoBaleBlock PALEO_BALE_FERN = new PaleoBaleBlock(PaleoBaleBlock.Variant.FERN);
    public static PaleoBaleBlock PALEO_BALE_LEAVES = new PaleoBaleBlock(PaleoBaleBlock.Variant.LEAVES);
    public static PaleoBaleBlock PALEO_BALE_OTHER = new PaleoBaleBlock(PaleoBaleBlock.Variant.OTHER);

    public static void init() {
        BlockHandler.registerBlock(PLANT_FOSSIL, "Plant Fossil Block");
        BlockHandler.registerBlock(FOSSILIZED_TRACKWAY, "Fossilized Trackway");
        BlockHandler.registerBlock(NEST_FOSSIL, "Nest Fossil");
        BlockHandler.registerBlock(ENCASED_NEST_FOSSIL, "Encased Nest Fossil");
        for (int i = 0; i < (int)Math.ceil((float)(EntityHandler.getHighestID() + 1) / 16.0f); ++i) {
            FossilBlock fossil = new FossilBlock(i * 16);
            EncasedFossilBlock encasedFossil = new EncasedFossilBlock(i * 16);
            FOSSILS.add(fossil);
            ENCASED_FOSSILS.add(encasedFossil);
            BlockHandler.registerBlock(fossil, "Fossil Block " + i);
            BlockHandler.registerBlock(encasedFossil, "Encased Fossil " + i);
        }
        for (TreeType type : TreeType.values()) {
            BlockHandler.registerTreeType(type);
        }
        BlockHandler.registerBlock(AMBER_ORE, "Amber Ore");
        BlockHandler.registerBlock(ICE_SHARD, "Ice Shard");
        BlockHandler.registerBlock(ICE_AGE_SHARD, "Ice Age Shard");
        BlockHandler.registerBlock(GYPSUM_STONE, "Gypsum Stone");
        BlockHandler.registerBlock(GYPSUM_COBBLESTONE, "Gypsum Cobblestone");
        BlockHandler.registerBlock(GYPSUM_BRICKS, "Gypsum Bricks");
        BlockHandler.registerBlock(GYPSUM_PATHWAY, "Gypsum Pathway");
        BlockHandler.registerBlock(GYPSUM_MIXED_PATH, "Gypsum Mixed Path");
        BlockHandler.registerBlock(GYPSUM_TILES, "Gypsum Tiles");
        BlockHandler.registerBlock(GYPSUM_COBBLESTONE_PATHWAY, "Gypsum Cobblestone Pathway");
        BlockHandler.registerBlock(REFINED_GYPSUM_PANEL, "Refined Gypsum Panel");
        BlockHandler.registerBlock(GYPSUM_STONE_PANEL, "Gypsum Stone Panel");
        BlockHandler.registerBlock(REINFORCED_STONE, "Reinforced Stone");
        BlockHandler.registerBlock(REINFORCED_BRICKS, "Reinforced Bricks");
        BlockHandler.registerBlock(REINFORCED_STONE_TILES, "Reinforced Stone Tiles");
        BlockHandler.registerBlock(REINFORCED_STONE_PATHWAY, "Reinforced Stone Pathway");
        BlockHandler.registerBlock(REINFORCED_STONE_PANEL, "Reinforced Stone Panel");
        BlockHandler.registerBlock((Block)AJUGINUCULA_SMITHII, "Ajuginucula Smithii");
        BlockHandler.registerBlock((Block)SMALL_ROYAL_FERN, "Small Royal Fern");
        BlockHandler.registerBlock((Block)SMALL_CHAIN_FERN, "Small Chain Fern");
        BlockHandler.registerBlock((Block)SMALL_CYCAD, "Small Cycad");
        BlockHandler.registerBlock((Block)CYCADEOIDEA, "Bennettitalean Cycadeoidea");
        BlockHandler.registerBlock((Block)CRY_PANSY, "Cry Pansy");
        BlockHandler.registerBlock((Block)SCALY_TREE_FERN, "Scaly Tree Fern");
        BlockHandler.registerBlock((Block)ZAMITES, "Cycad Zamites");
        BlockHandler.registerBlock((Block)DICKSONIA, "Dicksonia");
        BlockHandler.registerBlock((Block)WILD_ONION, "Wild Onion Plant");
        BlockHandler.registerBlock((Block)GRACILARIA, "Gracilaria Seaweed");
        BlockHandler.registerBlock((Block)DICROIDIUM_ZUBERI, "Dicroidium Zuberi");
        BlockHandler.registerBlock((Block)DICTYOPHYLLUM, "Dictyophyllum");
        BlockHandler.registerBlock((Block)WEST_INDIAN_LILAC, "West Indian Lilac");
        BlockHandler.registerBlock((Block)SERENNA_VERIFORMANS, "Serenna Veriformans");
        BlockHandler.registerBlock((Block)LADINIA_SIMPLEX, "Ladinia Simplex");
        BlockHandler.registerBlock((Block)ORONTIUM_MACKII, "Orontium Mackii");
        BlockHandler.registerBlock((Block)UMALTOLEPIS, "Umaltolepis");
        BlockHandler.registerBlock((Block)LIRIODENDRITES, "Liriodendrites");
        BlockHandler.registerBlock((Block)RAPHAELIA, "Raphaelia");
        BlockHandler.registerBlock((Block)ENCEPHALARTOS, "Encephalartos");
        BlockHandler.registerBlock((Block)WILD_POTATO_PLANT, "Wild Potato Plant");
        BlockHandler.registerBlock((Block)RHAMNUS_SALICIFOLIUS_PLANT, "Rhamnus Salicifolius");
        BlockHandler.registerBlock((Block)BRISTLE_FERN, "Bristle Fern");
        BlockHandler.registerBlock((Block)CINNAMON_FERN, "Cinnamon Fern");
        BlockHandler.registerBlock((Block)TEMPSKYA, "Tempskya");
        BlockHandler.registerBlock((Block)WOOLLY_STALKED_BEGONIA, "Woolly Stalked Begonia");
        BlockHandler.registerBlock((Block)LARGESTIPULE_LEATHER_ROOT, "Largestipule Leather Root");
        BlockHandler.registerBlock((Block)RHACOPHYTON, "Rhacophyton");
        BlockHandler.registerBlock((Block)GRAMINIDITES_BAMBUSOIDES, "Graminidites Bambusoides");
        BlockHandler.registerBlock((Block)ENALLHELIA, "Enallhelia");
        BlockHandler.registerBlock((Block)AULOPORA, "Aulopora");
        BlockHandler.registerBlock((Block)CLADOCHONUS, "Cladochonus");
        BlockHandler.registerBlock((Block)LITHOSTROTION, "Lithostrotion");
        BlockHandler.registerBlock((Block)STYLOPHYLLOPSIS, "Stylophyllopsis");
        BlockHandler.registerBlock((Block)HIPPURITES_RADIOSUS, "Hippurites Radiosus");
        BlockHandler.registerBlock((Block)HELICONIA, "Heliconia");
        BlockHandler.registerBlock(MOSS, "Moss");
        BlockHandler.registerBlock(PEAT, "Peat");
        BlockHandler.registerBlock(PEAT_MOSS, "Peat Moss");
        BlockHandler.registerBlock((Block)CLEAR_GLASS, "Clear Glass");
        BlockHandler.registerBlock(PLANKTON_SWARM, "Plankton Swarm");
        BlockHandler.registerBlock(KRILL_SWARM, "Krill Swarm");
        if (RebornConfig.VEHICLES.tourRailBlockEnabled) {
            BlockHandler.registerBlock(TourRailBlockEntity.class, TOUR_RAIL, "Tour Rail");
            BlockHandler.registerBlock(TOUR_RAIL_SLOW, "Tour Rail Slow");
            BlockHandler.registerBlock(TOUR_RAIL_MEDIUM, "Tour Rail Medium");
            BlockHandler.registerBlock(TOUR_RAIL_FAST, "Tour Rail Fast");
        }
        BlockHandler.registerBlock(SKELETON_ASSEMBLY, "Skeleton Assembly");
        BlockHandler.registerBlock(CultivatorBlockEntity.class, (Block)CULTIVATOR_BOTTOM, "Cultivate Bottom");
        BlockHandler.registerBlock((Block)CULTIVATOR_TOP, "Cultivate Top");
        BlockHandler.registerBlock(CleaningStationBlockEntity.class, (Block)CLEANING_STATION, "Cleaning Station");
        BlockHandler.registerBlock(FossilGrinderBlockEntity.class, (Block)FOSSIL_GRINDER, "Fossil Grinder");
        BlockHandler.registerBlock(DNASequencerBlockEntity.class, (Block)DNA_SEQUENCER, "DNA Sequencer");
        BlockHandler.registerBlock(DNASynthesizerBlockEntity.class, (Block)DNA_SYNTHESIZER, "DNA Synthesizer");
        BlockHandler.registerBlock(EmbryonicMachineBlockEntity.class, (Block)EMBRYONIC_MACHINE, "Embryonic Machine");
        BlockHandler.registerBlock(EmbryoCalcificationMachineBlockEntity.class, (Block)EMBRYO_CALCIFICATION_MACHINE, "Embryo Calcification Machine");
        BlockHandler.registerBlock(DNAExtractorBlockEntity.class, (Block)DNA_EXTRACTOR, "DNA Extractor");
        BlockHandler.registerBlock(DNACombinatorHybridizerBlockEntity.class, (Block)DNA_COMBINATOR_HYBRIDIZER, "DNA Combinator Hybridizer");
        BlockHandler.registerBlock(IncubatorBlockEntity.class, (Block)INCUBATOR, "Incubator");
        BlockHandler.registerBlock(SkullDisplayEntity.class, (Block)SKULL_DISPLAY, "Skull Display Block");
        BlockHandler.registerBlock(DisplayBlockEntity.class, (Block)DISPLAY_BLOCK, "Display Block");
        BlockHandler.registerBlock(FeederBlockEntity.class, (Block)FEEDER, "Feeder");
        BlockHandler.registerBlock(BugCrateBlockEntity.class, (Block)BUG_CRATE, "Bug Crate");
        BlockHandler.registerBlock(ElectricFenceWireBlockEntity.class, "tileEntityElectricFence", (Block)LOW_SECURITY_FENCE_WIRE, "Low Security Fence Wire");
        BlockHandler.registerBlock(ElectricFenceWireBlockEntity.class, "tileEntityElectricFence", (Block)MED_SECURITY_FENCE_WIRE, "Med Security Fence Wire");
        BlockHandler.registerBlock(ElectricFenceWireBlockEntity.class, "tileEntityElectricFence", (Block)HIGH_SECURITY_FENCE_WIRE, "High Security Fence Wire");
        BlockHandler.registerBlock(ElectricFencePoleBlockEntity.class, "tileEntityElectricPole", (Block)LOW_SECURITY_FENCE_POLE, "Low Security Fence Pole");
        BlockHandler.registerBlock(ElectricFencePoleBlockEntity.class, "tileEntityElectricPole", (Block)MED_SECURITY_FENCE_POLE, "Med Security Fence Pole");
        BlockHandler.registerBlock(ElectricFencePoleBlockEntity.class, "tileEntityElectricPole", (Block)HIGH_SECURITY_FENCE_POLE, "High Security Fence Pole");
        BlockHandler.registerBlock(ElectricFenceBaseBlockEntity.class, "tileEntityElectricBase", (Block)LOW_SECURITY_FENCE_BASE, "Low Security Fence Base");
        BlockHandler.registerBlock(ElectricFenceBaseBlockEntity.class, "tileEntityElectricBase", (Block)MED_SECURITY_FENCE_BASE, "Med Security Fence Base");
        BlockHandler.registerBlock(ElectricFenceBaseBlockEntity.class, "tileEntityElectricBase", (Block)HIGH_SECURITY_FENCE_BASE, "High Security Fence Base");
        BlockHandler.registerBlock((Block)PALEO_BALE_OTHER, "Paleo Bale Other");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCADEOIDEA, "Paleo Bale Cycadeoidea");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCAD, "Paleo Bale Cycad");
        BlockHandler.registerBlock((Block)PALEO_BALE_FERN, "Paleo Bale Fern");
        BlockHandler.registerBlock((Block)PALEO_BALE_LEAVES, "Paleo Bale Leaves");
        BlockHandler.registerBlock(REINFORCED_DOOR, "Reinforced Door");
        BlockHandler.registerBlock(SECURITY_DOOR, "Security Door");
    }

    public static void registerTreeType(TreeType type) {
        AncientPlanksBlock planks = new AncientPlanksBlock(type);
        AncientLogBlock log = new AncientLogBlock(type, false);
        AncientLogBlock petrifiedLog = new AncientLogBlock(type, true);
        AncientLeavesBlock leaves = new AncientLeavesBlock(type);
        AncientSaplingBlock sapling = new AncientSaplingBlock(type);
        AncientStairsBlock stair = new AncientStairsBlock(type, planks.func_176223_P());
        AncientSlabHalfBlock slab = new AncientSlabHalfBlock(type, planks.func_176223_P());
        AncientDoubleSlabBlock doubleSlab = new AncientDoubleSlabBlock(type, (Block)slab, planks.func_176223_P());
        AncientFenceBlock fence = new AncientFenceBlock(type);
        AncientFenceGateBlock fenceGate = new AncientFenceGateBlock(type);
        AncientDoorBlock door = new AncientDoorBlock(type);
        ANCIENT_PLANKS.put(type, planks);
        ANCIENT_LOGS.put(type, log);
        ANCIENT_LEAVES.put(type, leaves);
        ANCIENT_SAPLINGS.put(type, sapling);
        ANCIENT_STAIRS.put(type, stair);
        ANCIENT_SLABS.put(type, slab);
        ANCIENT_DOUBLE_SLABS.put(type, doubleSlab);
        ANCIENT_FENCES.put(type, fence);
        ANCIENT_FENCE_GATES.put(type, fenceGate);
        ANCIENT_DOORS.put(type, door);
        PETRIFIED_LOGS.put(type, petrifiedLog);
        String typeName = type.name();
        BlockHandler.registerBlock(planks, typeName + " Planks");
        BlockHandler.registerBlock((Block)log, typeName + " Log");
        BlockHandler.registerBlock((Block)petrifiedLog, typeName + " Log Petrified");
        BlockHandler.registerBlock((Block)leaves, typeName + " Leaves");
        BlockHandler.registerBlock((Block)sapling, typeName + " Sapling");
        BlockHandler.registerBlock((Block)stair, typeName + " Stairs");
        BlockHandler.registerBlock((Block)slab, typeName + " Slab");
        BlockHandler.registerBlock((Block)doubleSlab, typeName + " Double Slab");
        BlockHandler.registerBlock((Block)fence, typeName + " Fence");
        BlockHandler.registerBlock((Block)fenceGate, typeName + " Fence Gate");
        BlockHandler.registerBlock((Block)door, typeName + " Door");
        Blocks.field_150480_ab.func_180686_a((Block)leaves, 30, 60);
        Blocks.field_150480_ab.func_180686_a((Block)planks, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)log, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)petrifiedLog, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)doubleSlab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)slab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)stair, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)fence, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)fenceGate, 5, 20);
    }

    public static void registerOres() {
        for (int i = 0; i < TreeType.values().length; ++i) {
            OreDictionary.registerOre((String)"logWood", (Block)((Block)ANCIENT_LOGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"logWood", (Block)((Block)PETRIFIED_LOGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"plankWood", (Block)ANCIENT_PLANKS.get((Object)TreeType.values()[i]));
            OreDictionary.registerOre((String)"treeLeaves", (Block)((Block)ANCIENT_LEAVES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"treeSapling", (Block)((Block)ANCIENT_SAPLINGS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"slabWood", (Block)((Block)ANCIENT_SLABS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"stairWood", (Block)((Block)ANCIENT_STAIRS.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"fenceWood", (Block)((Block)ANCIENT_FENCES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"gateWood", (Block)((Block)ANCIENT_FENCE_GATES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"fenceGateWood", (Block)((Block)ANCIENT_FENCE_GATES.get((Object)TreeType.values()[i])));
            OreDictionary.registerOre((String)"doorWood", (Block)((Block)ANCIENT_DOORS.get((Object)TreeType.values()[i])));
        }
        for (FossilBlock fossil : FOSSILS) {
            OreDictionary.registerOre((String)"fossil", (Block)fossil);
        }
    }

    public static FossilBlock getFossilBlock(Dinosaur dinosaur) {
        return BlockHandler.getFossilBlock(EntityHandler.getDinosaurId(dinosaur));
    }

    private static int getBlockId(int id) {
        return (int)Math.floor(((float)id + 1.0f) / 16.0f - 0.0625f);
    }

    public static EncasedFossilBlock getEncasedFossil(Dinosaur dinosaur) {
        return BlockHandler.getEncasedFossil(EntityHandler.getDinosaurId(dinosaur));
    }

    public static EncasedFossilBlock getEncasedFossil(int id) {
        return ENCASED_FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static FossilBlock getFossilBlock(int id) {
        return FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static int getDinosaurId(FossilBlock fossil, int metadata) {
        return FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getDinosaurId(EncasedFossilBlock fossil, int metadata) {
        return ENCASED_FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getMetadata(int id) {
        return id % 16;
    }

    public static int getMetadata(Dinosaur dinosaur) {
        return BlockHandler.getMetadata(EntityHandler.getDinosaurId(dinosaur));
    }

    public static void registerBlock(Class<? extends TileEntity> tileEntity, Block block, String name) {
        BlockHandler.registerBlock(tileEntity, name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"), block, name);
    }

    public static void registerBlock(Class<? extends TileEntity> tileEntity, String tileEntityName, Block block, String name) {
        BlockHandler.registerBlock(block, name);
        GameRegistry.registerTileEntity(tileEntity, (ResourceLocation)new ResourceLocation("rebornmod", tileEntityName));
    }

    public static void registerBlock(Block block, String name) {
        if (block instanceof SubBlocksBlock) {
            RegistryHandler.registerBlockWithCustomItem(block, ((SubBlocksBlock)block).getItemBlock(), name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"));
        } else {
            RegistryHandler.registerBlockWithItem(block, name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"));
        }
    }
}

