/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import mod.reborn.server.api.CleanableItem;
import mod.reborn.server.api.SubBlocksBlock;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.item.block.NestFossilItemBlock;
import mod.reborn.server.tab.TabHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class NestFossilBlock
extends Block
implements SubBlocksBlock,
CleanableItem {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public boolean encased;

    public NestFossilBlock(boolean encased) {
        super(Material.field_151576_e);
        this.encased = encased;
        this.func_149711_c(1.5f);
        this.func_149647_a(TabHandler.FOSSILS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.VARIANT_1)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.values()[meta & 3]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal() & 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal() & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Variant type : Variant.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        return new NestFossilItemBlock(this, this.encased);
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    public boolean func_149659_a(Explosion explosion) {
        return this.encased;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (this.encased) {
            super.func_180653_a(world, pos, state, chance, fortune);
        }
    }

    @Override
    public boolean isCleanable(ItemStack stack) {
        return this.encased;
    }

    @Override
    public ItemStack getCleanedItem(ItemStack stack, Random random) {
        if (random.nextBoolean()) {
            return new ItemStack((Item)ItemHandler.FOSSILIZED_EGG, random.nextInt(7) + 1, stack.func_77952_i());
        }
        if (random.nextBoolean()) {
            return new ItemStack(Items.field_151145_ak);
        }
        return new ItemStack(Items.field_151100_aR, 1, 15);
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        return this.getItemSubtypes(this);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        float single = 25.0f;
        for (int i = 0; i < 7; ++i) {
            list.add(Pair.of((Object)Float.valueOf(7.142857f), (Object)new ItemStack((Item)ItemHandler.FOSSILIZED_EGG, i + 1, inputItem.func_77952_i())));
        }
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151145_ak)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151100_aR, 1, 15)));
        return list;
    }

    public static enum Variant implements IStringSerializable
    {
        VARIANT_1,
        VARIANT_2,
        VARIANT_3;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

