/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block.entity;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nullable;
import mod.reborn.RebornMod;
import mod.reborn.server.block.entity.CleaningStationBlockEntity;
import mod.reborn.server.block.entity.CultivatorCapability;
import mod.reborn.server.block.entity.ISyncable;
import mod.reborn.server.block.entity.MachineBaseBlockEntity;
import mod.reborn.server.block.entity.TemperatureControl;
import mod.reborn.server.container.CultivateContainer;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.food.FoodNutrients;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.item.SyringeItem;
import mod.reborn.server.message.TileEntityFieldsMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CultivatorBlockEntity
extends MachineBaseBlockEntity
implements TemperatureControl,
ISyncable {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUTS = new int[]{0, 3};
    public static final int MAX_NUTRIENTS = 3000;
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int waterLevel;
    private int lipids;
    private int proximates;
    private int minerals;
    private int vitamins;
    private int temperature;
    private boolean prevActiveState = false;
    private DinosaurEntity dinosaurEntity;
    private CultivatorCapability handler = new CultivatorCapability(this);

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        ItemStack itemstack = (ItemStack)this.slots.get(0);
        if (itemstack.func_77973_b() == ItemHandler.SYRINGE && this.waterLevel == 2) {
            Dinosaur dino = EntityHandler.getDinosaurById(itemstack.func_77952_i());
            if (dino == null) {
                return false;
            }
            Dinosaur meta = dino;
            if (meta.getBirthType() == Dinosaur.BirthType.LIVE_BIRTH) {
                return this.lipids >= meta.getLipids() && this.minerals >= meta.getMinerals() && this.proximates >= meta.getProximates() && this.vitamins >= meta.getVitamins();
            }
        }
        return false;
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
        super.packetDataHandler(fields);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.func_174885_b(0, fields.readInt());
            for (int i = 2; i < this.func_174890_g(); ++i) {
                this.func_174885_b(i, fields.readInt());
            }
        }
    }

    @Override
    protected void processItem(int process) {
        ItemStack syringe = (ItemStack)this.slots.get(0);
        Dinosaur dinosaur = EntityHandler.getDinosaurById(syringe.func_77952_i());
        if (dinosaur != null) {
            Dinosaur metadata = dinosaur;
            this.lipids -= metadata.getLipids();
            this.minerals -= metadata.getMinerals();
            this.vitamins -= metadata.getVitamins();
            this.proximates -= metadata.getProximates();
            --this.waterLevel;
            ItemStack hatchedEgg = new ItemStack((Item)ItemHandler.HATCHED_EGG, 1, syringe.func_77952_i());
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("Gender", this.temperature > 50);
            NBTTagCompound syringeTag = syringe.func_77978_p();
            if (syringeTag != null) {
                compound.func_74778_a("Genetics", syringeTag.func_74779_i("Genetics"));
                compound.func_74768_a("DNAQuality", syringeTag.func_74762_e("DNAQuality"));
            }
            hatchedEgg.func_77982_d(compound);
            this.slots.set(0, (Object)hatchedEgg);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            boolean sync = false;
            if (this.waterLevel < 2 && ((ItemStack)this.slots.get(2)).func_77973_b() == Items.field_151131_as && ((ItemStack)this.slots.get(3)).func_190916_E() < 16) {
                ((ItemStack)this.slots.get(2)).func_190918_g(1);
                ++this.waterLevel;
                stack = (ItemStack)this.slots.get(3);
                if (stack.func_77973_b() == Items.field_151133_ar) {
                    stack.func_190917_f(1);
                } else {
                    this.slots.set(3, (Object)new ItemStack(Items.field_151133_ar));
                }
                sync = true;
            }
            if (!((stack = (ItemStack)this.slots.get(1)).func_190926_b() || this.proximates >= 3000 && this.minerals >= 3000 && this.vitamins >= 3000 && this.lipids >= 3000)) {
                this.consumeNutrients();
                sync = true;
            }
            boolean active = this.isProcessing(0);
            boolean syncActive = false;
            if (active != this.prevActiveState) {
                this.prevActiveState = active;
                syncActive = true;
            }
            if (sync) {
                this.func_70296_d();
            }
            if (syncActive || sync) {
                RebornMod.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0));
            }
            if (syncActive) {
                for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - 5.0f), (double)((float)this.field_174879_c.func_177956_o() - 5.0f), (double)((float)this.field_174879_c.func_177952_p() - 5.0f), (double)((float)(this.field_174879_c.func_177958_n() + 1) + 5.0f), (double)((float)(this.field_174879_c.func_177956_o() + 1) + 5.0f), (double)((float)(this.field_174879_c.func_177952_p() + 1) + 5.0f)))) {
                    if (!(entityplayer.field_71070_bA instanceof CultivateContainer) || !this.isProcessing(0)) continue;
                    entityplayer.openGui((Object)RebornMod.INSTANCE, 9, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                }
            }
        }
    }

    private void consumeNutrients() {
        ItemStack foodStack = (ItemStack)this.slots.get(1);
        FoodNutrients nutrients = FoodNutrients.get(foodStack.func_77973_b());
        if (nutrients != null) {
            if (foodStack.func_77973_b() instanceof ItemBucketMilk) {
                this.slots.set(1, (Object)new ItemStack(Items.field_151133_ar));
            } else {
                foodStack.func_190918_g(1);
                if (foodStack.func_190916_E() <= 0) {
                    foodStack.func_190926_b();
                }
            }
            Random random = this.field_145850_b.field_73012_v;
            if (this.proximates < 3000) {
                this.proximates = (short)((double)this.proximates + (double)(800 + random.nextInt(201)) * nutrients.getProximate());
                if (this.proximates > 3000) {
                    this.proximates = 3000;
                }
            }
            if (this.minerals < 3000) {
                this.minerals = (short)((double)this.minerals + (double)(900 + random.nextInt(101)) * nutrients.getMinerals());
                if (this.minerals > 3000) {
                    this.minerals = 3000;
                }
            }
            if (this.vitamins < 3000) {
                this.vitamins = (short)((double)this.vitamins + (double)(900 + random.nextInt(101)) * nutrients.getVitamins());
                if (this.vitamins > 3000) {
                    this.vitamins = 3000;
                }
            }
            if (this.lipids < 3000) {
                this.lipids = (short)((double)this.lipids + (double)(980 + random.nextInt(101)) * nutrients.getLipids());
                if (this.lipids > 3000) {
                    this.lipids = 3000;
                }
            }
        }
    }

    @Override
    protected void onSlotUpdate() {
        super.onSlotUpdate();
        if (this.func_70301_a(0).func_190926_b()) {
            this.dinosaurEntity = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.waterLevel = compound.func_74765_d("WaterLevel");
        this.lipids = compound.func_74762_e("Lipids");
        this.minerals = compound.func_74762_e("Minerals");
        this.vitamins = compound.func_74762_e("Vitamins");
        this.proximates = compound.func_74762_e("Proximates");
        this.temperature = compound.func_74762_e("Temperature");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("WaterLevel", (short)this.waterLevel);
        compound.func_74768_a("Lipids", this.lipids);
        compound.func_74768_a("Minerals", this.minerals);
        compound.func_74768_a("Vitamins", this.vitamins);
        compound.func_74768_a("Proximates", this.proximates);
        compound.func_74768_a("Temperature", this.temperature);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.slots);
        return compound;
    }

    @Override
    protected int getMainOutput(int process) {
        return 4;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return INPUTS;
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    public DinosaurEntity getDinosaurEntity() {
        if (this.func_70301_a(0).func_190926_b()) {
            return null;
        }
        return this.dinosaurEntity == null ? this.createEntity() : this.dinosaurEntity;
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        super.getSyncFields(fields);
        fields.add((Object)this.func_174887_a_(0));
        for (int i = 2; i < this.func_174890_g(); ++i) {
            fields.add((Object)this.func_174887_a_(i));
        }
        return fields;
    }

    private DinosaurEntity createEntity() {
        try {
            this.dinosaurEntity = EntityHandler.getDinosaurById(this.func_70301_a(0).func_77960_j()).getDinosaurClass().getDeclaredConstructor(World.class).newInstance(this.field_145850_b);
            this.dinosaurEntity.setMale(this.temperature > 50);
            this.dinosaurEntity.setFullyGrown();
            this.dinosaurEntity.getAttributes().setScaleModifier(1.0f);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to create dinosaur entity", e);
        }
        return this.dinosaurEntity;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new CultivateContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "rebornmod:cultivator";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.cultivator";
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getMaxNutrients() {
        return 3000;
    }

    public int getProximates() {
        return this.proximates;
    }

    public int getMinerals() {
        return this.minerals;
    }

    public int getVitamins() {
        return this.vitamins;
    }

    public int getLipids() {
        return this.lipids;
    }

    @Override
    public int func_174887_a_(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        int type = id - processCount * 2;
        switch (type) {
            case 0: {
                return this.waterLevel;
            }
            case 1: {
                return this.proximates;
            }
            case 2: {
                return this.minerals;
            }
            case 3: {
                return this.vitamins;
            }
            case 4: {
                return this.lipids;
            }
            case 5: {
                return this.temperature;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        } else {
            int type = id - processCount * 2;
            switch (type) {
                case 0: {
                    this.waterLevel = value;
                    break;
                }
                case 1: {
                    this.proximates = value;
                    break;
                }
                case 2: {
                    this.minerals = value;
                    break;
                }
                case 3: {
                    this.vitamins = value;
                    break;
                }
                case 4: {
                    this.lipids = value;
                    break;
                }
                case 5: {
                    this.temperature = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return this.getProcessCount() * 2 + 6;
    }

    public Dinosaur getDinosaur() {
        ItemStack stack = (ItemStack)this.slots.get(0);
        if (!stack.func_190926_b()) {
            return EntityHandler.getDinosaurById(stack.func_77952_i());
        }
        return null;
    }

    @Override
    public void setTemperature(int index, int value) {
        this.temperature = value;
    }

    @Override
    public int getTemperature(int index) {
        return this.temperature;
    }

    @Override
    public int getTemperatureCount() {
        return 1;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (!this.isProcessing(0)) {
            if (slotID == 0) {
                ItemStack stackInSlot = this.func_70301_a(slotID);
                return stackInSlot != null && stackInSlot.func_77973_b() == ItemHandler.HATCHED_EGG;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return !this.handler.isUp && !this.isProcessing(0) && Ints.asList((int[])INPUTS).contains(slotID) && (slotID == 0 && itemstack != null && this.func_70301_a(slotID).func_190916_E() == 0 && itemstack.func_77973_b() instanceof SyringeItem && SyringeItem.getDinosaur(itemstack).getBirthType() == Dinosaur.BirthType.LIVE_BIRTH || slotID == 1 && itemstack != null && FoodNutrients.NUTRIENTS.containsKey(itemstack.func_77973_b()) || slotID == 2 && itemstack != null && CleaningStationBlockEntity.isItemFuel(itemstack));
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slot) {
        this.slots = slot;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return (T)this.handler;
        }
        return super.getCapability(capability, facing);
    }

    public IItemHandler getCapabilityHandler() {
        return (IItemHandler)super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }
}

