/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block.entity;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import mod.reborn.RebornMod;
import mod.reborn.server.block.entity.MachineBaseBlockEntity;
import mod.reborn.server.container.DNAExtractorContainer;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.genetics.DinoDNA;
import mod.reborn.server.genetics.GeneticsHelper;
import mod.reborn.server.genetics.PlantDNA;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.message.TileEntityFieldsMessage;
import mod.reborn.server.plant.Plant;
import mod.reborn.server.plant.PlantHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DNAExtractorBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1};
    private static final int[] OUTPUTS = new int[]{2, 3, 4, 5};
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        ItemStack extraction = (ItemStack)this.slots.get(0);
        ItemStack storage = (ItemStack)this.slots.get(1);
        if (!(storage.func_77973_b() != ItemHandler.STORAGE_DISC || extraction.func_77973_b() != ItemHandler.AMBER && extraction.func_77973_b() != ItemHandler.SEA_LAMPREY && extraction.func_77973_b() != ItemHandler.FROZEN_LEECH && extraction.func_77973_b() != ItemHandler.DINOSAUR_MEAT || storage.func_77978_p() != null && storage.func_77978_p().func_74764_b("Genetics"))) {
            for (int i = 2; i < 6; ++i) {
                if (!((ItemStack)this.slots.get(i)).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return Ints.asList((int[])OUTPUTS).contains(slotID);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && itemstack != null && itemstack.func_77973_b() == ItemHandler.AMBER || itemstack.func_77973_b() == ItemHandler.SEA_LAMPREY || itemstack.func_77973_b() == ItemHandler.FROZEN_LEECH || itemstack.func_77973_b() == ItemHandler.DINOSAUR_MEAT || slotID == 1 && itemstack != null && itemstack.func_77973_b() == ItemHandler.STORAGE_DISC && (itemstack.func_77978_p() == null || !itemstack.func_77978_p().func_74764_b("DNAQuality"));
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            NBTTagCompound nbt;
            DinoDNA dna;
            int quality;
            Dinosaur dino;
            List<Dinosaur> possibleDinos;
            Random rand = this.field_145850_b.field_73012_v;
            ItemStack input = (ItemStack)this.slots.get(0);
            ItemStack disc = ItemStack.field_190927_a;
            Item item = input.func_77973_b();
            if (item == ItemHandler.AMBER || item == ItemHandler.SEA_LAMPREY) {
                if (input.func_77952_i() == 0) {
                    possibleDinos = item == ItemHandler.AMBER ? EntityHandler.getDinosaursFromAmber() : EntityHandler.getMarineCreatures();
                    dino = possibleDinos.get(rand.nextInt(possibleDinos.size()));
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                    quality = 50 + rand.nextInt(50);
                    dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                } else if (input.func_77952_i() == 1) {
                    List<Plant> possiblePlants = PlantHandler.getPrehistoricPlantsAndTrees();
                    Plant plant = possiblePlants.get(rand.nextInt(possiblePlants.size()));
                    int plantId = PlantHandler.getPlantId(plant);
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                    int quality2 = 50 + rand.nextInt(50);
                    PlantDNA dna2 = new PlantDNA(plantId, quality2);
                    NBTTagCompound nbt2 = new NBTTagCompound();
                    dna2.writeToNBT(nbt2);
                    disc.func_77982_d(nbt2);
                }
            }
            if (item == ItemHandler.AMBER || item == ItemHandler.FROZEN_LEECH) {
                if (input.func_77952_i() == 0) {
                    possibleDinos = item == ItemHandler.AMBER ? EntityHandler.getDinosaursFromAmber() : EntityHandler.getMammalCreatures();
                    dino = possibleDinos.get(rand.nextInt(possibleDinos.size()));
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                    quality = 50 + rand.nextInt(50);
                    dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                }
            } else if (item == ItemHandler.DINOSAUR_MEAT) {
                Dinosaur dino2 = EntityHandler.getDinosaurById(input.func_77960_j());
                disc = new ItemStack((Item)ItemHandler.STORAGE_DISC);
                DinoDNA dna3 = new DinoDNA(dino2, 100, GeneticsHelper.randomGenetics(rand));
                NBTTagCompound nbt3 = new NBTTagCompound();
                dna3.writeToNBT(nbt3);
                disc.func_77982_d(nbt3);
            }
            int empty = this.getOutputSlot(disc);
            this.mergeStack(empty, disc);
            this.decreaseStackSize(0);
            this.decreaseStackSize(1);
            BlockPos pos = this.field_174879_c;
            RebornMod.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0));
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 2;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(NonNullList<ItemStack> slots) {
        this.slots = slots;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNAExtractorContainer(playerInventory, (TileEntity)this);
    }

    @Override
    public String func_174875_k() {
        return "rebornmod:dna_extractor";
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_extractor";
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.func_70299_a(0, ByteBufUtils.readItemStack((ByteBuf)fields));
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean send = false;
        if (!this.field_145850_b.field_72995_K && index == 0 && ((ItemStack)this.slots.get(0)).func_77973_b() != stack.func_77973_b()) {
            send = true;
        }
        super.func_70299_a(index, stack);
        if (send) {
            RebornMod.NETWORK_WRAPPER.sendToAllTracking((IMessage)new TileEntityFieldsMessage(this.getSyncFields(NonNullList.func_191196_a()), (TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0));
        }
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        fields.add(this.slots.get(0));
        return fields;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }
}

