/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block.entity;

import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.EntityHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisplayBlockEntity
extends TileEntity {
    private DinosaurEntity entity;
    private int rotation;
    private boolean isFossile;
    private boolean isMale;
    private byte variant;
    private boolean isSkeleton;
    private SerializedData serializedData = new InvalidData();

    public void setDinosaur(int dinosaurId, boolean isMale, boolean isSkeleton) {
        this.isMale = isMale;
        this.isSkeleton = isSkeleton;
        this.variant = this.variant;
        this.isFossile = this.isFossile;
        try {
            Dinosaur dinosaur = EntityHandler.getDinosaurById(dinosaurId);
            this.entity = dinosaur.getDinosaurClass().getDeclaredConstructor(World.class).newInstance(this.field_145850_b);
            this.initializeEntity(this.entity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("DinosaurId")) {
            this.serializedData = new LegacyId();
        } else if (nbt.func_74764_b("DinosaurTag")) {
            this.serializedData = new TagData();
        }
        this.entity = null;
        this.serializedData.deserialize(nbt);
        this.rotation = nbt.func_74762_e("Rotation");
        this.isMale = !nbt.func_74764_b("IsMale") || nbt.func_74767_n("IsMale");
        this.isSkeleton = nbt.func_74767_n("IsSkeleton");
        this.variant = nbt.func_74771_c("Variant");
        this.isFossile = nbt.func_74767_n("IsFossile");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.entity != null) {
            NBTTagCompound tag = this.entity.serializeNBT();
            nbt.func_74782_a("DinosaurTag", (NBTBase)tag);
        } else if (this.serializedData != null) {
            this.serializedData.serialize(nbt);
        }
        nbt.func_74768_a("Rotation", this.rotation);
        nbt.func_74757_a("IsMale", this.isMale);
        nbt.func_74757_a("IsSkeleton", this.isSkeleton);
        nbt.func_74774_a("Variant", this.variant);
        nbt.func_74757_a("IsFossile", this.isFossile);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isSkeleton && this.entity != null) {
            return this.entity.func_184177_bl().func_72321_a(3.0, 3.0, 3.0).func_186670_a(this.field_174879_c);
        }
        return super.getRenderBoundingBox();
    }

    public boolean isMale() {
        return this.isMale;
    }

    public boolean isSkeleton() {
        return this.isSkeleton;
    }

    public boolean isFossile() {
        return this.isFossile;
    }

    public byte getVariant() {
        return this.variant;
    }

    public int getRot() {
        return this.rotation;
    }

    public void setRot(int rotation) {
        this.func_70296_d();
        this.rotation = rotation;
    }

    public DinosaurEntity getEntity() {
        if (this.entity == null && this.serializedData != null) {
            return this.createEntity();
        }
        return this.entity;
    }

    private DinosaurEntity createEntity() {
        DinosaurEntity entity = this.serializedData.create(this.field_145850_b);
        if (entity != null) {
            this.serializedData = null;
            this.initializeEntity(entity);
            this.entity = entity;
            return entity;
        }
        return new InvalidData().create(this.field_145850_b);
    }

    private void initializeEntity(DinosaurEntity entity) {
        entity.setupDisplay(this.isMale);
        entity.setSkeleton(this.isSkeleton);
        entity.setSkeletonVariant(this.variant);
        entity.setIsFossile(this.isFossile);
        entity.setAnimation(EntityAnimation.IDLE.get());
    }

    private class InvalidData
    extends LegacyId {
        private InvalidData() {
        }

        @Override
        public void deserialize(NBTTagCompound compound) {
            this.dinosaurId = EntityHandler.getDinosaurId(EntityHandler.VELOCIRAPTOR);
        }
    }

    private class TagData
    implements SerializedData {
        protected NBTTagCompound data;

        private TagData() {
        }

        @Override
        public void serialize(NBTTagCompound compound) {
            compound.func_74782_a("DinosaurTag", (NBTBase)this.data);
        }

        @Override
        public void deserialize(NBTTagCompound compound) {
            this.data = compound.func_74775_l("DinosaurTag");
        }

        @Override
        public DinosaurEntity create(World world) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)this.data, (World)world);
            if (entity instanceof DinosaurEntity) {
                return (DinosaurEntity)entity;
            }
            return null;
        }
    }

    private class LegacyId
    implements SerializedData {
        protected int dinosaurId;

        private LegacyId() {
        }

        @Override
        public void serialize(NBTTagCompound compound) {
            compound.func_74768_a("DinosaurId", this.dinosaurId);
        }

        @Override
        public void deserialize(NBTTagCompound compound) {
            this.dinosaurId = compound.func_74762_e("DinosaurId");
        }

        @Override
        public DinosaurEntity create(World world) {
            try {
                Dinosaur dinosaur = EntityHandler.getDinosaurById(this.dinosaurId);
                return dinosaur.getDinosaurClass().getDeclaredConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static interface SerializedData {
        public void serialize(NBTTagCompound var1);

        public void deserialize(NBTTagCompound var1);

        public DinosaurEntity create(World var1);
    }
}

