/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block.fence;

import java.util.List;
import mod.reborn.server.block.entity.ElectricFenceBaseBlockEntity;
import mod.reborn.server.block.entity.ElectricFenceWireBlockEntity;
import mod.reborn.server.block.fence.ElectricFencePoleBlock;
import mod.reborn.server.block.fence.FenceType;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.tab.TabHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ElectricFenceBaseBlock
extends BlockContainer {
    public static final PropertyDirection FACING_BIAS = BlockHorizontal.field_185512_D;
    public static final PropertyBool POLE = PropertyBool.func_177716_a((String)"pole");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyInteger CONNECTIONS = PropertyInteger.func_177719_a((String)"connections", (int)0, (int)4);
    private static final AxisAlignedBB EXTENDED_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0);
    private FenceType type;

    public ElectricFenceBaseBlock(FenceType type) {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149647_a(TabHandler.BLOCKS);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING_BIAS, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (entityIn instanceof DinosaurEntity && !world.func_175623_d(pos.func_177984_a())) {
            ElectricFenceBaseBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EXTENDED_BOUNDS);
        } else {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        DinosaurEntity dinosaur;
        TileEntity wireEntity = world.func_175625_s(pos.func_177984_a());
        return wireEntity instanceof ElectricFenceWireBlockEntity && ((ElectricFenceWireBlockEntity)wireEntity).isPowered() && entity instanceof DinosaurEntity && (dinosaur = (DinosaurEntity)entity).getDinosaur().canClimb();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ElectricFenceBaseBlockEntity();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_BIAS, (Comparable)placer.func_174811_aO().func_176746_e());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean pole;
        boolean north = this.canConnect(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)));
        boolean south = this.canConnect(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)));
        boolean west = this.canConnect(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)));
        boolean east = this.canConnect(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)));
        int connections = 0;
        if (north) {
            ++connections;
        }
        if (south) {
            ++connections;
        }
        if (west) {
            ++connections;
        }
        if (east) {
            ++connections;
        }
        if (!(pole = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof ElectricFencePoleBlock) && connections == 0) {
            connections = 1;
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING_BIAS)) {
                case NORTH: {
                    north = true;
                    break;
                }
                case SOUTH: {
                    south = true;
                    break;
                }
                case EAST: {
                    east = true;
                    break;
                }
                case WEST: {
                    west = true;
                    break;
                }
            }
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)POLE, (Comparable)Boolean.valueOf(pole)).func_177226_a((IProperty)CONNECTIONS, (Comparable)Integer.valueOf(connections));
    }

    protected boolean canConnect(IBlockState state) {
        return state.func_177230_c() instanceof ElectricFenceBaseBlock && ((ElectricFenceBaseBlock)state.func_177230_c()).getType().equals((Object)this.type);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING_BIAS, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING_BIAS)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_BIAS, NORTH, SOUTH, EAST, WEST, POLE, CONNECTIONS});
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)POLE) != false ? 3 : super.getLightOpacity(state, world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState poleState;
        if (!world.field_72995_K && (poleState = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof ElectricFencePoleBlock) {
            ((ElectricFencePoleBlock)poleState.func_177230_c()).updateConnectedWires(world, pos.func_177984_a());
        }
    }

    public FenceType getType() {
        return this.type;
    }
}

