/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.block.plant;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public abstract class RBBlockCropsBase
extends BlockBush
implements IGrowable {
    protected int seedDropMin = 0;
    protected int seedDropMax = 3;
    protected int cropDropMin = 1;
    protected int cropDropMax = 1;

    protected RBBlockCropsBase() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    protected static float getGrowthChance(Block block, World world, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState state = world.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)block)) {
                    f1 = 1.0f;
                    if (state.func_177230_c().isFertile(world, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = block == world.func_180495_p(blockpos3).func_177230_c() || block == world.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = block == world.func_180495_p(blockpos1).func_177230_c() || block == world.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = block == world.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || block == world.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)((float)((Integer)state.func_177229_b((IProperty)this.getAgeProperty()) + 1) * 0.125f), (double)0.9f);
    }

    protected abstract PropertyInteger getAgeProperty();

    protected abstract int getMaxAge();

    protected abstract BlockStateContainer func_180661_e();

    protected abstract Item getSeed();

    protected abstract Item getCrop();

    protected boolean func_185514_i(IBlockState ground) {
        return ground == Blocks.field_150458_ak;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175671_l(pos.func_177984_a()) >= 9 && (i = ((Integer)state.func_177229_b((IProperty)this.getAgeProperty())).intValue()) < this.getMaxAge() && rand.nextInt((int)(25.0f / (f = RBBlockCropsBase.getGrowthChance((Block)this, world, pos))) + 1) == 0) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    public void grow(World world, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        if (i > this.getMaxAge()) {
            i = this.getMaxAge();
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(i)), 2);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return (world.func_175699_k(pos) >= 8 || world.func_175678_i(pos)) && world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) < this.getMaxAge();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, 0);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ((Integer)state.func_177229_b((IProperty)this.getAgeProperty())).intValue() == this.getMaxAge() ? this.getCrop() : this.getSeed();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int age = (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age < this.getMaxAge()) {
            drops.add(new ItemStack(this.getSeed()));
        } else {
            if (this.seedDropMin > 0 && this.seedDropMax > 0) {
                drops.add(new ItemStack(this.getSeed(), MathHelper.func_76136_a((Random)rand, (int)this.seedDropMin, (int)this.seedDropMax)));
            }
            if (this.cropDropMin > 0 && this.cropDropMax > 0) {
                drops.add(new ItemStack(this.getCrop(), MathHelper.func_76136_a((Random)rand, (int)this.cropDropMin, (int)this.cropDropMax)));
            }
        }
        return drops;
    }
}

