/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.command;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mod.reborn.server.world.structure.AbandonedPaddockGenerator;
import mod.reborn.server.world.structure.AmberMineGenerator;
import mod.reborn.server.world.structure.DesertDigsiteGenerator;
import mod.reborn.server.world.structure.IceFossilDigsiteGenerator;
import mod.reborn.server.world.structure.IslaSornaLabGenerator;
import mod.reborn.server.world.structure.JPSanDiegoGenerator;
import mod.reborn.server.world.structure.RaptorPaddockGenerator;
import mod.reborn.server.world.structure.StructureGenerator;
import mod.reborn.server.world.structure.VisitorCentreGenerator;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class SpawnStructureCommand
extends CommandBase {
    public String func_71517_b() {
        return "spawnrb";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.spawnrb.usuage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        StructureGenerator generator;
        if (args.length < 1) {
            throw new WrongUsageException("commands.spawnrb.usuage", new Object[0]);
        }
        String name = args[0];
        Random random = new Random();
        if (name.equalsIgnoreCase("visitor_center")) {
            generator = new VisitorCentreGenerator(random);
        } else if (name.equalsIgnoreCase("raptor_paddock")) {
            generator = new RaptorPaddockGenerator(random);
        } else if (name.equalsIgnoreCase("abandoned_paddock")) {
            generator = new AbandonedPaddockGenerator(random);
        } else if (name.equalsIgnoreCase("ice_fossil_digsite")) {
            generator = new IceFossilDigsiteGenerator(random);
        } else if (name.equalsIgnoreCase("desert_digsite")) {
            generator = new DesertDigsiteGenerator(random);
        } else if (name.equalsIgnoreCase("amber_mine")) {
            generator = new AmberMineGenerator(random);
        } else if (name.equalsIgnoreCase("isla_sorna_lab")) {
            generator = new IslaSornaLabGenerator(random);
        } else if (name.equalsIgnoreCase("jp_san_diego")) {
            generator = new JPSanDiegoGenerator(random);
        } else {
            throw new CommandException("commands.spawnrb.notfound", new Object[]{name});
        }
        if (args.length > 1) {
            try {
                generator.setRotation(Rotation.valueOf((String)args[1].toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException e) {
                throw new CommandException("commands.spawnrb.notrot", new Object[]{args[1]});
            }
        }
        if (args.length > 2) {
            try {
                generator.setMirror(Mirror.valueOf((String)args[2].toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException e) {
                throw new CommandException("commands.spawnrb.notmirror", new Object[]{args[2]});
            }
        }
        if (args.length > 3) {
            random = new Random(SpawnStructureCommand.func_175766_b((String)args[3]));
        }
        generator.func_180709_b(sender.func_130014_f_(), random, sender.func_180425_c());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return SpawnStructureCommand.func_175762_a((String[])args, (Collection)Lists.newArrayList((Object[])new String[]{"visitor_center", "abandoned_paddock", "ice_fossil_digsite", "desert_digsite", "amber_mine", "raptor_paddock", "isla_sorna_lab", "jp_san_diego"}));
        }
        if (args.length == 2) {
            return SpawnStructureCommand.func_175762_a((String[])args, (Collection)Stream.of(Rotation.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()));
        }
        if (args.length == 3) {
            return SpawnStructureCommand.func_175762_a((String[])args, (Collection)Stream.of(Mirror.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()));
        }
        return Lists.newArrayList();
    }
}

