/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.container;

import javax.annotation.Nullable;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.container.slot.FossilSlotCrafting;
import mod.reborn.server.container.slot.SkeletonCraftingSlot;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.DisplayBlockItem;
import mod.reborn.server.item.FossilItem;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SkeletonAssemblyContainer
extends Container {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 5;
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 5, 5);
    public IInventory craftResult = new InventoryCraftResult();
    private final World worldObj;
    private final BlockPos pos;

    public SkeletonAssemblyContainer(InventoryPlayer inventory, World world, BlockPos pos) {
        int x;
        int y;
        this.worldObj = world;
        this.pos = pos;
        this.func_75146_a((Slot)new SkeletonCraftingSlot(inventory.field_70458_d, this.craftMatrix, this.craftResult, 0, 140, 52));
        for (y = 0; y < 5; ++y) {
            for (x = 0; x < 5; ++x) {
                this.func_75146_a(new FossilSlotCrafting((IInventory)this.craftMatrix, x + y * 5, 16 + x * 18, 16 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, x + y * 9 + 9, 8 + x * 18, 119 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot((IInventory)inventory, x2, 8 + x2 * 18, 177));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void func_75130_a(IInventory inventory) {
        this.craftResult.func_70299_a(0, this.getResult());
    }

    private ItemStack getResult() {
        AssemblyData data = this.getAssemblyData();
        if (data != null && data.dinosaur.getRecipe() != null) {
            String[][] recipe = data.dinosaur.getRecipe();
            int targetWidth = recipe[0].length;
            int targetHeight = recipe.length;
            Bounds bounds = this.calculateAssemblyBounds();
            if (bounds.getWidth() + 1 == targetWidth && bounds.getHeight() + 1 == targetHeight) {
                for (int y = 0; y < targetHeight; ++y) {
                    for (int x = 0; x < targetWidth; ++x) {
                        String targetBone = recipe[y][x];
                        ItemStack stack = this.craftMatrix.func_70301_a(x + bounds.minX + (y + bounds.minY) * 5);
                        if (targetBone.equals(this.identify(stack))) continue;
                        this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
                        return ItemStack.field_190927_a;
                    }
                }
                return data.getResult();
            }
        }
        return ItemStack.field_190927_a;
    }

    private String identify(ItemStack stack) {
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof FossilItem) {
            return ((FossilItem)stack.func_77973_b()).getBoneType();
        }
        return "";
    }

    private AssemblyData getAssemblyData() {
        AssemblyData data = null;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int id = x + y * 5;
                ItemStack stack = this.craftMatrix.func_70301_a(id);
                AssemblyData stackData = this.getAssemblyData(stack);
                if (stackData == null) continue;
                if (data != null && !data.equals(stackData)) {
                    return null;
                }
                data = stackData;
            }
        }
        return data;
    }

    private AssemblyData getAssemblyData(ItemStack stack) {
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof FossilItem) {
            FossilItem item = (FossilItem)stack.func_77973_b();
            return new AssemblyData(item.getDinosaur(stack), item.isFresh());
        }
        return null;
    }

    private Bounds calculateAssemblyBounds() {
        int minX = 5;
        int minY = 5;
        int maxX = 0;
        int maxY = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int id = x + y * 5;
                if (this.getAssemblyData(this.craftMatrix.func_70301_a(id)) == null) continue;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return new Bounds(minX, minY, maxX, maxY);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.worldObj.field_72995_K) {
            for (int i = 0; i < 25; ++i) {
                ItemStack stack = this.craftMatrix.func_70304_b(i);
                if (stack == ItemStack.field_190927_a) continue;
                player.func_71019_a(stack, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.worldObj.func_180495_p(this.pos).func_177230_c() == BlockHandler.SKELETON_ASSEMBLY && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            stack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 26, 62, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, stack);
            } else if (index >= 26 && index < 53 ? !this.func_75135_a(itemstack1, 53, 62, false) : (index >= 53 && index < 62 ? !this.func_75135_a(itemstack1, 26, 53, false) : !this.func_75135_a(itemstack1, 26, 53, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return stack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    private class AssemblyData {
        private final Dinosaur dinosaur;
        private final boolean fresh;

        private AssemblyData(Dinosaur dinosaur, boolean fresh) {
            this.dinosaur = dinosaur;
            this.fresh = fresh;
        }

        public ItemStack getResult() {
            int metadata = DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(this.dinosaur), this.fresh ? 2 : 1, true);
            return new ItemStack((Item)ItemHandler.DISPLAY_BLOCK, 1, metadata);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AssemblyData) {
                AssemblyData data = (AssemblyData)obj;
                return data.dinosaur == this.dinosaur && data.fresh == this.fresh;
            }
            return false;
        }
    }

    private class Bounds {
        private final int minX;
        private final int minY;
        private final int maxX;
        private final int maxY;

        private Bounds(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        public int getWidth() {
            return this.maxX - this.minX;
        }

        public int getHeight() {
            return this.maxY - this.minY;
        }
    }
}

