/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.datafixers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.reborn.server.paleopad.App;
import net.ilexiconn.llibrary.server.capability.EntityDataHandler;
import net.ilexiconn.llibrary.server.capability.IEntityData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PlayerData
implements IEntityData<EntityPlayer> {
    public static final String IDENTIFIER = "rebornmod:playerdata";
    private Map<String, NBTTagCompound> appdata = new HashMap<String, NBTTagCompound>();
    private List<App> openApps = new ArrayList<App>();

    public void init(EntityPlayer player, World world) {
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagList appDataList = new NBTTagList();
        for (Map.Entry<String, NBTTagCompound> data : this.appdata.entrySet()) {
            NBTTagCompound appData = new NBTTagCompound();
            appData.func_74778_a("Name", data.getKey());
            appData.func_74782_a("Data", (NBTBase)data.getValue());
            appDataList.func_74742_a((NBTBase)appData);
        }
        nbt.func_74782_a("RBAppData", (NBTBase)appDataList);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.appdata.clear();
        NBTTagList appDataList = nbt.func_150295_c("RBAppData", 10);
        for (int i = 0; i < appDataList.func_74745_c(); ++i) {
            NBTTagCompound appData = (NBTTagCompound)appDataList.func_179238_g(i);
            this.appdata.put(appData.func_74779_i("Name"), appData.func_74775_l("Data"));
        }
    }

    public String getID() {
        return IDENTIFIER;
    }

    public List<App> getOpenApps() {
        return this.openApps;
    }

    public Map<String, NBTTagCompound> getAppdata() {
        return this.appdata;
    }

    public void openApp(App app) {
        if (this.appdata.containsKey(app.getName())) {
            app.readAppFromNBT(this.appdata.get(app.getName()));
        }
        app.init();
        app.open();
        this.openApps.add(app);
    }

    public void closeApp(App app) {
        NBTTagCompound data = new NBTTagCompound();
        app.writeAppToNBT(data);
        this.appdata.put(app.getName(), data);
        this.openApps.remove(app);
    }

    public static PlayerData get(EntityPlayer player) {
        return (PlayerData)EntityDataHandler.INSTANCE.getEntityData((Entity)player, IDENTIFIER);
    }
}

