/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.SleepTime;
import mod.reborn.server.entity.ai.util.MovementType;
import mod.reborn.server.entity.dinosaur.AlligatorGarEntity;
import mod.reborn.server.food.FoodType;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class AlligatorGarDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public AlligatorGarDinosaur() {
        this.setName("Alligator Gar");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(AlligatorGarEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(7371668, 3885411);
        this.setEggColorFemale(8157022, 5065275);
        this.setHealth(2.0, 10.0);
        this.setFlee(true);
        this.setSpeed(0.25000000596046446, 0.4f);
        this.setAttackSpeed(1.5);
        this.setStrength(0.5, 3.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.18f, 0.9f);
        this.setSizeX(0.2f, 1.0f);
        this.setSizeY(0.2f, 1.0f);
        this.setDiet(Diet.PISCIVORE.get().withModule(new Diet.DietModule(FoodType.FILTER)));
        this.setSleepTime(SleepTime.NO_SLEEP);
        this.setBones("anal_fin", "dorsal_fin", "pectoral_fin_bones", "pelvic_fin_bones", "scales", "skull", "spine", "tail_fin", "teeth");
        this.setHeadCubeName("Head");
        this.setScale(0.95f, 0.15f);
        this.setMaxHerdSize(30);
        this.setOffset(0.0f, 0.7f, 0.0f);
        this.setAttackBias(100.0);
        this.setBreeding(true, 2, 12, 40, false, true);
        this.setMarineAnimal(true);
        this.setMovementType(MovementType.NEAR_SURFACE);
        this.setRandomFlock(false);
        this.setImprintable(false);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        String[][] recipe = new String[][]{{"", "dorsal_fin", "scales", ""}, {"tail_fin", "spine", "pectoral_fin_bones", "skull"}, {"anal_fin", "", "pelvic_fin_bones", "teeth"}};
        this.setRecipe(recipe);
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
        this.enableSkeleton();
    }

    @Override
    public void applyMeatEffect(EntityPlayer player, boolean cooked) {
        if (!cooked) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400, 1));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1));
    }
}

