/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.SleepTime;
import mod.reborn.server.entity.ai.util.MovementType;
import mod.reborn.server.entity.dinosaur.CoelacanthEntity;
import mod.reborn.server.food.FoodType;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CoelacanthDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public CoelacanthDinosaur() {
        this.setName("Coelacanth");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(CoelacanthEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setTimePeriod(TimePeriod.DEVONIAN);
        this.setEggColorMale(7371668, 3885411);
        this.setEggColorFemale(8157022, 5065275);
        this.setHealth(4.0, 10.0);
        this.setFlee(true);
        this.setSpeed(0.0500000059604645, 0.4f);
        this.setAttackSpeed(1.5);
        this.setStrength(0.5, 3.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.05f, 0.9f);
        this.setSizeX(0.1f, 1.0f);
        this.setSizeY(0.1f, 1.0f);
        this.setDiet(Diet.PISCIVORE.get().withModule(new Diet.DietModule(FoodType.FILTER)));
        this.setSleepTime(SleepTime.NO_SLEEP);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setBones("anal_fin", "caudal_fin", "first_dorsal_fin", "pectoral_fin_bones", "pelvic_fin_bones", "second_dorsal_fin", "skull", "spine", "teeth");
        this.setHeadCubeName("Head");
        this.setScale(1.8f, 0.22f);
        this.setMaxHerdSize(1);
        this.setOffset(0.0f, 1.1f, -0.2f);
        this.setAttackBias(100.0);
        this.setMarineAnimal(true);
        this.setMovementType(MovementType.DEEP_WATER);
        this.setBreeding(true, 1, 3, 20, true, false);
        this.setRandomFlock(false);
        String[][] recipe = new String[][]{{"", "second_dorsal_fin", "first_dorsal_fin", ""}, {"caudal_fin", "spine", "pectoral_fin_bones", "skull"}, {"anal_fin", "", "pelvic_fin_bones", "teeth"}};
        this.setRecipe(recipe);
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
        this.enableSkeleton();
    }

    @Override
    public void applyMeatEffect(EntityPlayer player, boolean cooked) {
        if (!cooked) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400, 1));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1));
    }
}

