/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.dinosaur.GallimimusEntity;
import mod.reborn.server.food.FoodType;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class GallimimusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.41f;

    public GallimimusDinosaur() {
        this.setName("Gallimimus");
        this.setDinosaurClass(GallimimusEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(14006918, 13723928);
        this.setEggColorFemale(13417108, 11236157);
        this.setHealth(6.0, 30.0);
        this.setSpeed(0.3599999964237213, 0.41f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(35));
        this.setEyeHeight(0.45f, 2.15f);
        this.setSizeX(0.3f, 1.2f);
        this.setSizeY(0.55f, 2.25f);
        this.setStorage(27);
        this.setDiet(Diet.HERBIVORE.get().withModule(new Diet.DietModule(FoodType.INSECT).withCondition(entity -> entity.getAgePercentage() < 25)));
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae");
        this.setHeadCubeName("Head Base");
        this.setScale(1.05f, 0.1f);
        this.setImprintable(true);
        this.setFlee(true);
        this.setFlockSpeed(1.35f);
        this.shouldDefendOffspring();
        this.setBreeding(false, 2, 6, 20, false, true);
        this.setJumpHeight(3);
        this.setCanClimb(true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "leg_bones", "leg_bones", "arm_bones", ""}, {"", "foot_bones", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DRY));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
        this.enableSkeleton();
    }
}

