/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.dinosaur.GuanlongEntity;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class GuanlongDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public GuanlongDinosaur() {
        this.setName("Guanlong");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(GuanlongEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(15721401, 15721401);
        this.setEggColorFemale(15721140, 5131595);
        this.setHealth(4.0, 16.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStorage(27);
        this.setStrength(2.0, 15.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.35f, 1.3f);
        this.setSizeX(0.2f, 1.2f);
        this.setSizeY(0.4f, 1.4f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("arm_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae", "tooth", "claw", "foot_bones", "skull");
        this.setHeadCubeName("Head");
        this.setScale(0.7f, 0.1f);
        this.shouldDefendOffspring();
        this.setAttackBias(1200.0);
        this.setAttackSpeed(1.2f);
        this.setDefendOwner(true);
        this.setImprintable(true);
        this.setBreeding(false, 2, 4, 24, false, true);
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder"}, {"leg_bones", "arm_bones", "claw", "tooth"}, {"foot_bones", "", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
    }
}

