/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.dinosaur.HyaenodonEntity;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class HyaenodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public HyaenodonDinosaur() {
        this.setName("Hyaenodon");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(HyaenodonEntity.class);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(0xA3A3A3, 0x191919);
        this.setEggColorFemale(7300690, 1052171);
        this.setHealth(10.0, 40.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStorage(27);
        this.setStrength(1.0, 15.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.35f, 1.7f);
        this.setSizeX(0.2f, 1.4f);
        this.setSizeY(0.4f, 1.8f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("skull", "tail_vertebrae", "front_leg_bones", "ribcage", "hind_leg_bones", "neck_vertebrae", "pelvis", "shoulder", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.3f, 0.15f);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setBreeding(true, 2, 4, 40, false, true);
        this.setAttackBias(600.0);
        this.setAttackSpeed(1.9);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setMammal(true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "", "front_leg_bones", "shoulder", "tooth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
    }
}

