/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.SleepTime;
import mod.reborn.server.entity.ai.util.MovementType;
import mod.reborn.server.entity.dinosaur.MawsoniaEntity;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MawsoniaDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public MawsoniaDinosaur() {
        this.setName("Mawsonia");
        this.setDinosaurClass(MawsoniaEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(7371668, 3885411);
        this.setEggColorFemale(8157022, 5065275);
        this.setHealth(6.0, 40.0);
        this.setFlee(true);
        this.setSpeed(0.0500000059604645, 0.4f);
        this.setAttackSpeed(1.5);
        this.setStrength(0.5, 3.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.15f, 1.8f);
        this.setSizeX(0.3f, 2.5f);
        this.setSizeY(0.2f, 1.8f);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setSleepTime(SleepTime.NO_SLEEP);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setBones("anal_fin", "caudal_fin", "first_dorsal_fin", "pectoral_fin_bones", "pelvic_fin_bones", "second_dorsal_fin", "skull", "spine", "teeth");
        this.setHeadCubeName("Main head");
        this.setScale(1.8f, 0.1f);
        this.setMaxHerdSize(4);
        this.setOffset(0.0f, 1.0f, -0.2f);
        this.setAttackBias(100.0);
        this.setMarineAnimal(true);
        this.setMovementType(MovementType.DEEP_WATER);
        this.setBreeding(true, 2, 4, 15, true, false);
        this.setRandomFlock(true);
        String[][] recipe = new String[][]{{"", "second_dorsal_fin", "first_dorsal_fin", ""}, {"caudal_fin", "spine", "pectoral_fin_bones", "skull"}, {"anal_fin", "", "pelvic_fin_bones", "teeth"}};
        this.setRecipe(recipe);
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
        this.enableSkeleton();
    }

    @Override
    public void applyMeatEffect(EntityPlayer player, boolean cooked) {
        if (!cooked) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400, 1));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1));
    }
}

