/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.dinosaur;

import java.util.ArrayList;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.dinosaur.MicroraptorEntity;
import mod.reborn.server.food.FoodType;
import mod.reborn.server.period.TimePeriod;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MicroraptorDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public MicroraptorDinosaur() {
        this.setName("Microraptor");
        this.setDinosaurClass(MicroraptorEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(1319238, 1054245);
        this.setEggColorFemale(922659, 1185831);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setHealth(4.0, 10.0);
        this.setStrength(0.5, 2.0);
        this.setMaximumAge(this.fromDays(30));
        this.setFlee(true);
        this.setEyeHeight(0.2f, 0.55f);
        this.setSizeX(0.2f, 0.7f);
        this.setSizeY(0.25f, 0.6f);
        this.setStorage(9);
        this.setDiet(new Diet().withModule(new Diet.DietModule(FoodType.INSECT)).withModule(new Diet.DietModule(FoodType.MEAT)));
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(0.4f, 0.15f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setMaxHerdSize(16);
        this.setAttackBias(400.0);
        this.setCanClimb(true);
        this.setBreeding(false, 1, 5, 15, false, true);
        this.setJumpHeight(2);
        this.setRandomFlock(false);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "tooth"}, {"", "leg_bones", "leg_bones", "arm_bones", ""}, {"", "foot_bones", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        ArrayList biomeList = new ArrayList();
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        biomeList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DENSE));
        this.setSpawn(1, new Biome[][]{biomeList.toArray(new Biome[biomeList.size()])});
        this.enableSkeleton();
    }
}

