/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity;

import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.DinosaurWanderEntityAI;
import mod.reborn.server.entity.ai.navigation.DinosaurMoveHelper;
import mod.reborn.server.entity.animal.ai.EntityAIFindWater;
import mod.reborn.server.entity.animal.ai.EntityAIWanderNearWater;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AmfibianDinosaurEntity
extends DinosaurEntity {
    private boolean getOut = false;
    private boolean getInWater = false;
    private boolean blocked;
    private PathNavigate navigateSwimmer = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
    private PathNavigate navigateLand = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
    private int waterTicks;
    private int landTicks;

    public AmfibianDinosaurEntity(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.blocked = false;
        this.field_70714_bg.func_85156_a((EntityAIBase)new DinosaurWanderEntityAI(this, 0.8, 2, 10));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFindWater(this, 1.0, 2, 30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new Wander(this, 2.0, 10, 2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MoveUnderwaterEntityAI(this));
        this.field_70765_h = new SwimmingMoveHelper();
    }

    @Override
    public boolean func_70610_aX() {
        return this.isCarcass() || this.isSleeping() || this.blocked;
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        if (this.func_70089_S()) {
            if (this.func_70090_H()) {
                ++this.waterTicks;
                this.field_70699_by = this.navigateSwimmer;
                if (this.waterTicks >= 120) {
                    this.getOut = true;
                }
                this.getInWater = false;
                this.func_70050_g(300);
            } else {
                this.func_70050_g(--air);
                if (this.func_70086_ai() <= 40) {
                    this.getInWater = true;
                }
                if (this.func_70086_ai() <= -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
                this.waterTicks = 0;
                this.getOut = false;
            }
            if (this.getOut) {
                this.field_70699_by = this.navigateLand;
            }
            if (!this.func_70090_H()) {
                ++this.landTicks;
                if (this.landTicks > 50) {
                    this.getInWater = true;
                }
            } else {
                this.landTicks = 0;
            }
        }
        super.func_70030_z();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H() && !this.isCarcass() && !this.getOut) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.7;
            this.field_70181_x *= 0.7;
            this.field_70179_y *= 0.7;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    class Wander
    extends EntityAIWanderNearWater {
        public final AmfibianDinosaurEntity creature;

        public Wander(AmfibianDinosaurEntity creatureIn, double speedIn, int chance, int walkradius) {
            super(creatureIn, speedIn, chance, walkradius);
            this.creature = creatureIn;
        }

        @Override
        public boolean func_75250_a() {
            if (this.creature.getInWater) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    class MoveUnderwaterEntityAI
    extends EntityAIBase {
        private AmfibianDinosaurEntity swimmingEntity;
        private double xPosition;
        private double yPosition;
        private double zPosition;

        public MoveUnderwaterEntityAI(AmfibianDinosaurEntity entity) {
            this.swimmingEntity = entity;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            if ((double)this.swimmingEntity.func_70681_au().nextFloat() < 0.5 && this.swimmingEntity.isBusy()) {
                return false;
            }
            Vec3d target = this.swimmingEntity.getOut ? RandomPositionGenerator.func_191377_b((EntityCreature)this.swimmingEntity, (int)6, (int)6) : RandomPositionGenerator.func_75463_a((EntityCreature)this.swimmingEntity, (int)6, (int)6);
            if (target == null) {
                return false;
            }
            this.xPosition = target.field_72450_a;
            this.yPosition = target.field_72448_b;
            this.zPosition = target.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !this.swimmingEntity.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            this.swimmingEntity.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, 1.0);
        }

        public boolean func_75252_g() {
            return false;
        }
    }

    class SwimmingMoveHelper
    extends DinosaurMoveHelper {
        private final AmfibianDinosaurEntity swimmingEntity;

        public SwimmingMoveHelper() {
            super(AmfibianDinosaurEntity.this);
            this.swimmingEntity = AmfibianDinosaurEntity.this;
        }

        @Override
        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.swimmingEntity.func_70661_as().func_75500_f() && this.swimmingEntity.func_70090_H() && this.swimmingEntity.getOut) {
                double distanceX = this.field_75646_b - this.swimmingEntity.field_70165_t;
                double distanceY = this.field_75647_c - this.swimmingEntity.field_70163_u;
                double distanceZ = this.field_75644_d - this.swimmingEntity.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distance = MathHelper.func_76133_a((double)distance);
                float f = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.swimmingEntity.field_70177_z = this.func_75639_a(this.swimmingEntity.field_70177_z, f, 30.0f);
                this.swimmingEntity.func_70659_e((float)(this.swimmingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * this.field_75645_e));
                this.swimmingEntity.field_70181_x += (double)this.swimmingEntity.func_70689_ay() * (distanceY /= distance) * 0.05;
            } else {
                super.func_75641_c();
            }
        }
    }
}

