/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity;

import java.util.Random;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.server.block.entity.FeederBlockEntity;
import mod.reborn.server.conf.RebornConfig;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.AdvancedSwimEntityAI;
import mod.reborn.server.entity.ai.DinosaurAttackMeleeEntityAI;
import mod.reborn.server.entity.ai.DinosaurWanderEntityAI;
import mod.reborn.server.entity.ai.navigation.DinosaurMoveHelper;
import mod.reborn.server.entity.ai.util.MathUtils;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.HypsilophodonEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.MicroraptorEntity;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class FlyingDinosaurEntity
extends DinosaurEntity
implements EntityFlying,
IAnimals {
    private int ticksOnFloor;
    private int ticksInAir;
    private boolean blocked;
    private boolean takingOff;
    private int feederSearchTick;
    private BlockPos closestFeeder;
    public boolean shouldLand;

    public FlyingDinosaurEntity(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.blocked = false;
        this.field_70765_h = new FlyingMoveHelper();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinosaurAttackMeleeEntityAI(this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFlyLand());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIStartFlying());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIWander());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILookAround());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AdvancedSwimEntityAI(this));
        this.doesEatEggs(true);
        this.doTarget();
    }

    protected void doTarget() {
        this.target(LeptictidiumEntity.class, HypsilophodonEntity.class, MicroraptorEntity.class, MicroceratusEntity.class, CompsognathusEntity.class);
    }

    public void func_70030_z() {
        if (!this.field_70122_E && this.getAnimation() == EntityAnimation.SLEEPING.get()) {
            this.func_70657_f(-5.0f);
        }
        if (this.getMetabolism().isStarving() || this.getMetabolism().isThirsty()) {
            this.shouldLand = true;
        }
        if (this.isOnGround()) {
            this.ticksInAir = 0;
            ++this.ticksOnFloor;
        } else {
            ++this.ticksInAir;
            this.ticksOnFloor = 0;
        }
        if (this.ticksInAir > 150) {
            this.takingOff = false;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C);
        super.func_70030_z();
    }

    @Override
    public boolean func_70610_aX() {
        return this.isCarcass() || this.isSleeping() || this.blocked;
    }

    public boolean isOnGround() {
        return !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_186662_g(0.24)).isEmpty() && !this.takingOff || this.field_70128_L || this.isCarcass() || this.func_70090_H();
    }

    public void startTakeOff() {
        this.takingOff = true;
    }

    public int func_184649_cE() {
        return this.func_70646_bf();
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.isOnGround()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.tranqed && !this.isOnGround()) {
            if (this.inWater()) {
                this.func_191958_b(strafe, forward, 0.02f, 0.0f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
                return;
            }
            if (this.inLava()) {
                this.func_191958_b(strafe, forward, 0.02f, 0.0f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
                return;
            }
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (friction * friction * friction);
            this.func_191958_b(strafe, forward, this.field_70122_E ? f3 * 0.1f : 0.02f, 0.0f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
            this.field_184618_aE = this.field_70721_aZ;
            double moveX = this.field_70165_t - this.field_70169_q;
            double moveZ = this.field_70161_v - this.field_70166_s;
            float dist = MathHelper.func_76133_a((double)(moveX * moveX + moveZ * moveZ)) * 4.0f;
            if (dist > 1.0f) {
                dist = 1.0f;
            }
            this.field_70721_aZ += (dist - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            return;
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    public boolean func_70617_f_() {
        return false;
    }

    private boolean isCourseTraversable(Vec3d loc) {
        double distance = this.func_174791_d().func_72438_d(loc);
        double d4 = (loc.field_72450_a - this.field_70165_t) / (distance += 1.0);
        double d5 = (loc.field_72448_b - this.field_70163_u) / distance;
        double d6 = (loc.field_72449_c - this.field_70161_v) / distance;
        AxisAlignedBB axisalignedbb = this.func_70046_E();
        if (axisalignedbb == null) {
            axisalignedbb = this.func_174813_aQ();
        }
        int i = 1;
        while ((double)i < distance) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.field_70170_p.func_184144_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public BlockPos getClosestFeeder() {
        int posX = (int)this.field_70165_t;
        int posY = (int)this.field_70163_u;
        int posZ = (int)this.field_70161_v;
        int closestDist = Integer.MAX_VALUE;
        BlockPos closestPos = null;
        int range = 16;
        for (int x = posX - range; x < posX + range; ++x) {
            for (int y = posY - 8; y < posY + 8; ++y) {
                for (int z = posZ - range; z < posZ + range; ++z) {
                    int deltaZ;
                    int deltaY;
                    int deltaX;
                    int distance;
                    FeederBlockEntity feeder;
                    BlockPos pos;
                    TileEntity tile;
                    if (y <= 0 || y >= this.field_70170_p.func_72800_K() || !((tile = this.field_70170_p.func_175625_s(pos = new BlockPos(x, y, z))) instanceof FeederBlockEntity) || !(feeder = (FeederBlockEntity)tile).canFeedDinosaur(this) || feeder.getFeeding() != null || feeder.openAnimation != 0 || (distance = (deltaX = Math.abs(posX - x)) * deltaX + (deltaY = Math.abs(posY - y)) * deltaY + (deltaZ = Math.abs(posZ - z)) * deltaZ) >= closestDist) continue;
                    closestDist = distance;
                    closestPos = pos;
                }
            }
        }
        return closestPos;
    }

    class AIWander
    extends DinosaurWanderEntityAI {
        private final FlyingDinosaurEntity dino;

        public AIWander() {
            super(FlyingDinosaurEntity.this, 0.8, 10, RebornConfig.ENTITIES.dinosaurWalkingRadius);
            this.dino = FlyingDinosaurEntity.this;
        }

        @Override
        public boolean func_75250_a() {
            if (!this.dino.isOnGround()) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    class AILookAround
    extends EntityAIBase {
        private final FlyingDinosaurEntity dino;

        public AILookAround() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.dino.func_70638_az() == null) {
                this.dino.field_70761_aq = this.dino.field_70177_z = -((float)Math.atan2(this.dino.field_70159_w, this.dino.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase attackTarget = this.dino.func_70638_az();
                double maxDistance = 64.0;
                if ((double)attackTarget.func_70032_d((Entity)this.dino) < maxDistance * maxDistance) {
                    double diffX = attackTarget.field_70165_t - this.dino.field_70165_t;
                    double diffZ = attackTarget.field_70161_v - this.dino.field_70161_v;
                    this.dino.field_70761_aq = this.dino.field_70177_z = -((float)Math.atan2(diffX, diffZ)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }

    class FlyingMoveHelper
    extends DinosaurMoveHelper {
        private final FlyingDinosaurEntity parentEntity;
        private int timer;

        public FlyingMoveHelper() {
            super(FlyingDinosaurEntity.this);
            this.parentEntity = FlyingDinosaurEntity.this;
        }

        @Override
        public void func_75641_c() {
            if (this.parentEntity.isOnGround()) {
                super.func_75641_c();
                return;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double distanceX = this.field_75646_b - this.parentEntity.field_70165_t;
                double distanceY = this.field_75647_c - this.parentEntity.field_70163_u;
                double distanceZ = this.field_75644_d - this.parentEntity.field_70161_v;
                double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
                if (this.timer-- <= 0) {
                    this.timer += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, distance = (double)MathHelper.func_76133_a((double)distance))) {
                        this.parentEntity.field_70159_w += distanceX / distance * this.field_75645_e * 0.1;
                        this.parentEntity.field_70181_x += distanceY / distance * this.field_75645_e * 0.1;
                        this.parentEntity.field_70179_y += distanceZ / distance * this.field_75645_e * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
                if (distance < 2.5E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.parentEntity.field_70165_t) / distance;
            double d1 = (y - this.parentEntity.field_70163_u) / distance;
            double d2 = (z - this.parentEntity.field_70161_v) / distance;
            AxisAlignedBB bounds = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, bounds = bounds.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class AIFlyLand
    extends EntityAIBase {
        private final FlyingDinosaurEntity dino;

        public AIFlyLand() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double moveZ;
            double moveY;
            if (this.dino.ticksInAir <= 150 && this.dino.isOnGround() && this.dino.func_70090_H() && this.dino.func_191953_am()) {
                return false;
            }
            EntityMoveHelper moveHelper = this.dino.func_70605_aq();
            if (!moveHelper.func_75640_a() && this.dino.field_70146_Z.nextFloat() < 0.1f || !moveHelper.func_75640_a() && this.dino.shouldLand) {
                return true;
            }
            double moveX = moveHelper.func_179917_d() - this.dino.field_70165_t;
            double distance = moveX * moveX + (moveY = moveHelper.func_179919_e() - this.dino.field_70163_u) * moveY + (moveZ = moveHelper.func_179918_f() - this.dino.field_70161_v) * moveZ;
            if (distance < 1.0 || distance > 3600.0) {
                return this.dino.field_70170_p.func_180495_p(this.dino.func_180425_c().func_177977_b()).func_185904_a() == Material.field_151579_a && this.dino.func_70681_au().nextFloat() < 0.01f;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            double destinationZ;
            double destinationY;
            Random random = this.dino.func_70681_au();
            double destinationX = this.dino.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (FlyingDinosaurEntity.this.field_70170_p.func_180495_p(new BlockPos(destinationX, (destinationY = (double)this.dino.field_70170_p.func_175672_r(new BlockPos(destinationX, 100.0, destinationZ = this.dino.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f))).func_177956_o()) - 1.0, destinationZ)).func_185904_a() != Material.field_151579_a) {
                this.dino.func_70605_aq().func_75642_a(destinationX, destinationY - 1.8, destinationZ, 2.0);
                this.dino.setAnimation(EntityAnimation.ON_LAND.get());
            }
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private final FlyingDinosaurEntity dino;

        public AIRandomFly() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double moveZ;
            double moveY;
            if (this.dino.isOnGround()) {
                return false;
            }
            EntityMoveHelper moveHelper = this.dino.func_70605_aq();
            if (!moveHelper.func_75640_a()) {
                return true;
            }
            double moveX = moveHelper.func_179917_d() - this.dino.field_70165_t;
            double distance = moveX * moveX + (moveY = moveHelper.func_179919_e() - this.dino.field_70163_u) * moveY + (moveZ = moveHelper.func_179918_f() - this.dino.field_70161_v) * moveZ;
            return distance < 3.0 || distance > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Vec3d lookVec = new Vec3d(this.dino.func_70040_Z().field_72450_a * 10.0, this.dino.func_70040_Z().field_72448_b * 10.0, this.dino.func_70040_Z().field_72449_c * 10.0).func_178787_e(new Vec3d((Vec3i)FlyingDinosaurEntity.this.func_180425_c()));
            Random random = this.dino.func_70681_au();
            for (int i = 0; i < 100; ++i) {
                double destinationZ;
                double destinationY;
                double destinationX = this.dino.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                Vec3d vecPos = new Vec3d(destinationX, destinationY = this.dino.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f), destinationZ = this.dino.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f));
                if (!this.dino.isCourseTraversable(vecPos)) continue;
                Vec3d vec3d = new Vec3d((Vec3i)FlyingDinosaurEntity.this.func_180425_c());
                if (!(Math.abs(MathUtils.cosineFromPoints(vecPos, lookVec, vec3d)) < 45.0)) continue;
                this.dino.func_70671_ap().func_75650_a(destinationX, destinationY, destinationZ, (float)this.dino.func_184649_cE(), (float)this.dino.func_70646_bf());
                this.dino.setAnimation(EntityAnimation.FLYING.get());
                this.dino.func_70605_aq().func_75642_a(destinationX, destinationY, destinationZ, 2.0);
                return;
            }
        }
    }

    class AIStartFlying
    extends EntityAIBase {
        private final FlyingDinosaurEntity dino;

        public AIStartFlying() {
            this.dino = FlyingDinosaurEntity.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return this.dino.ticksOnFloor >= 220 && this.dino.isOnGround() && this.dino.field_70146_Z.nextFloat() < 0.03f;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.dino.startTakeOff();
            this.dino.setAnimation(EntityAnimation.FLYING.get());
            this.dino.func_70605_aq().func_75642_a(this.dino.field_70165_t + (double)FlyingDinosaurEntity.this.field_70146_Z.nextFloat(), this.dino.field_70163_u + (double)(FlyingDinosaurEntity.this.field_70146_Z.nextFloat() * 5.0f), this.dino.field_70161_v + (double)FlyingDinosaurEntity.this.field_70146_Z.nextFloat(), 2.0);
        }
    }
}

