/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai;

import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.server.entity.SwimmingDinosaurEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class WaterLeapAI
extends EntityAIBase {
    private static final int[] OFFSET_MULTIPLIERS = new int[]{0, 1, 4, 5, 6, 7};
    private final SwimmingDinosaurEntity entity;
    private final int chance;
    private final float yeetheight;
    private float jumpheight;
    private boolean launched = false;
    private int prevTick;
    private EntityAnimation animation;

    public WaterLeapAI(SwimmingDinosaurEntity entity, int chance, float yeetpower) {
        this.entity = entity;
        this.chance = chance;
        this.yeetheight = yeetpower;
        this.func_75248_a(10);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70681_au().nextInt(this.chance) != 0 && this.entity.isBusy() && this.entity.getAgePercentage() < 50) {
            return false;
        }
        EnumFacing direction = this.entity.func_174811_aO();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockPos = this.entity.func_180425_c();
        for (int k : OFFSET_MULTIPLIERS) {
            if (this.entity.func_70090_H() && this.isAirAbove(blockPos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70090_H() || this.launched;
    }

    public void func_75249_e() {
        this.animation = EntityAnimation.PREPARE_LEAP;
    }

    public void func_75246_d() {
        int tick = this.entity.getAnimationTick();
        if (this.animation == EntityAnimation.PREPARE_LEAP && tick < this.prevTick) {
            this.entity.setAnimation(EntityAnimation.LEAP.get());
            this.entity.func_184185_a(this.entity.getSoundForAnimation(EntityAnimation.LEAP.get()), this.entity.func_70599_aP(), this.entity.func_70647_i());
            this.entity.field_70181_x = this.jumpheight;
        } else if (this.animation == EntityAnimation.LEAP && this.entity.field_70181_x < 0.0) {
            this.animation = EntityAnimation.LEAP_LAND;
            this.launched = true;
        } else if (this.animation == EntityAnimation.LEAP_LAND && (this.entity.field_70122_E || this.entity.isSwimming())) {
            this.animation = EntityAnimation.IDLE;
        }
        if (this.entity.getAnimation() != this.animation.get()) {
            this.entity.setAnimation(this.animation.get());
            this.entity.setAnimationTick(this.prevTick + 1);
        }
        this.prevTick = tick;
    }

    private boolean isAirAbove(BlockPos pos, int xOffset, int zOffset, int multiplier) {
        for (int i = 1; i <= 4; ++i) {
            BlockPos checkPos = pos.func_177982_a(xOffset * multiplier, i, zOffset * multiplier);
            if (!this.entity.field_70170_p.func_175667_e(checkPos) || this.entity.field_70170_p.func_180495_p(checkPos).func_177230_c() != Blocks.field_150350_a) continue;
            this.jumpheight = this.yeetheight + ((float)i / 2.0f - 0.5f);
            return true;
        }
        return false;
    }
}

