/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.MetabolismContainer;
import mod.reborn.server.entity.ai.BlockRingBuffer;
import mod.reborn.server.entity.ai.util.AIUtils;
import mod.reborn.server.entity.ai.util.OnionTraverser;
import mod.reborn.server.util.GameRuleHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DrinkEntityAI
extends EntityAIBase {
    protected DinosaurEntity dinosaur;
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    protected volatile Path path;
    protected BlockPos pos;
    protected volatile boolean searched = false;
    protected int giveUpTime;
    protected volatile BlockPos water = null;
    protected final BlockRingBuffer unreachable = new BlockRingBuffer(10);
    protected volatile BlockPos waterPos = null;

    public DrinkEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.dinosaur.isAlive() && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p) && (this.dinosaur.func_70661_as().func_75500_f() || this.dinosaur.getMetabolism().isDehydrated()) && this.dinosaur.getMetabolism().isThirsty()) {
            final World world = this.dinosaur.field_70170_p;
            if (!this.searched && tpe.getActiveCount() < 2) {
                this.searched = true;
                try {
                    tpe.execute(new ThreadRunnable(this, this.dinosaur){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            World world2 = world;
                            synchronized (world2) {
                                block14: {
                                    BlockPos pos2;
                                    OnionTraverser traverser = new OnionTraverser(this.entity.func_180425_c(), 32);
                                    HashMap<Float, BlockPos> distanceMap = new HashMap<Float, BlockPos>();
                                    for (BlockPos pos2 : traverser) {
                                        if (world.func_180495_p(pos2).func_185904_a() != Material.field_151586_h || this.ai.unreachable.contains(pos2)) continue;
                                        float distance = (float)pos2.func_177951_i((Vec3i)this.entity.func_180425_c());
                                        distanceMap.put(Float.valueOf(distance), pos2);
                                    }
                                    ArrayList sortedList = new ArrayList(distanceMap.keySet());
                                    Collections.sort(sortedList);
                                    pos2 = null;
                                    if (sortedList.size() != 0) {
                                        pos2 = (BlockPos)distanceMap.get(sortedList.get(0));
                                    }
                                    this.ai.waterPos = pos2;
                                    try {
                                        IBlockState state;
                                        BlockPos shore = null;
                                        BlockRingBuffer blockRingBuffer = this.ai.unreachable;
                                        synchronized (blockRingBuffer) {
                                            shore = AIUtils.findShore(world, pos2);
                                        }
                                        if (shore == null || !(state = world.func_180495_p(shore)).func_185913_b()) break block14;
                                        DrinkEntityAI drinkEntityAI = this.ai;
                                        synchronized (drinkEntityAI) {
                                            Path path = this.entity.func_70661_as().func_179680_a(shore);
                                            if (path != null && path.func_75874_d() != 0) {
                                                this.ai.path = path;
                                                this.ai.water = shore;
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.ai.searched = false;
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            if (this.water != null && this.path != null) {
                this.pos = this.water;
                this.giveUpTime = this.path.func_75874_d() * 20;
                return this.dinosaur.func_70661_as().func_75484_a(this.path, 1.0);
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.giveUpTime > 0) {
            --this.giveUpTime;
            if (this.giveUpTime <= 5 && this.dinosaur.func_180425_c().func_177951_i((Vec3i)this.water) <= 6.0) {
                this.unreachable.add(this.waterPos);
            }
        }
        if (this.path != null) {
            try {
                this.dinosaur.func_70661_as().func_75484_a(this.path, 1.0);
                if (this.path.func_75879_b() && this.dinosaur.func_180425_c().func_177951_i((Vec3i)this.water) <= 6.0) {
                    this.dinosaur.func_70671_ap().func_75650_a((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, 10.0f, 10.0f);
                    this.dinosaur.setAnimation(EntityAnimation.DRINKING.get());
                    MetabolismContainer metabolism = this.dinosaur.getMetabolism();
                    metabolism.setWater(metabolism.getWater() + metabolism.getMaxWater() / 8);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.path = null;
        this.dinosaur.func_70661_as().func_75499_g();
    }

    public boolean func_75253_b() {
        return this.giveUpTime > 0 && this.dinosaur != null && this.dinosaur.isAlive() && this.path != null && (double)this.dinosaur.getMetabolism().getWater() < (double)this.dinosaur.getMetabolism().getMaxWater() * 0.9;
    }

    public boolean func_75252_g() {
        return false;
    }

    abstract class ThreadRunnable
    implements Runnable {
        final DinosaurEntity entity;
        final DrinkEntityAI ai;

        ThreadRunnable(DrinkEntityAI drinkEntityAI, DinosaurEntity entity) {
            this.ai = drinkEntityAI;
            this.entity = entity;
        }
    }
}

