/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai.metabolism;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.MetabolismContainer;
import mod.reborn.server.entity.ai.util.OnionTraverser;
import mod.reborn.server.food.FoodHelper;
import mod.reborn.server.util.GameRuleHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GrazeEntityAI
extends EntityAIBase {
    public static final int EAT_RADIUS = 6;
    public static final int LOOK_RADIUS = 16;
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final int GIVE_UP_TIME = 400;
    protected volatile boolean searched = false;
    protected DinosaurEntity dinosaur;
    protected volatile BlockPos target;
    protected volatile BlockPos moveTarget;
    protected volatile boolean feederExists = false;
    private int counter;
    private World world;
    private volatile BlockPos previousTarget;
    private volatile Vec3d targetVec;

    public GrazeEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p) && this.dinosaur.getMetabolism().isHungry()) {
            if (!this.dinosaur.getMetabolism().isStarving() && this.feederExists()) {
                return false;
            }
            Vec3d headPos = this.dinosaur.getHeadPos();
            final BlockPos head = new BlockPos(headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c);
            this.world = this.dinosaur.field_70170_p;
            MetabolismContainer metabolism = this.dinosaur.getMetabolism();
            if (!this.searched && tpe.getActiveCount() < 2) {
                this.searched = true;
                try {
                    tpe.execute(new ThreadRunnable(this, this.dinosaur){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            World world = GrazeEntityAI.this.world;
                            synchronized (world) {
                                OnionTraverser traverser = new OnionTraverser(head, 16);
                                this.ai.target = null;
                                for (BlockPos pos : traverser) {
                                    IBlockState state;
                                    if (!GrazeEntityAI.this.world.func_175667_e(pos)) continue;
                                    Block block = GrazeEntityAI.this.world.func_180495_p(pos).func_177230_c();
                                    if (!FoodHelper.isEdible(this.entity, this.entity.getDinosaur().getDiet(), block) || pos == this.ai.previousTarget) continue;
                                    this.ai.target = pos;
                                    for (int i = 0; i < 16 && ((state = GrazeEntityAI.this.world.func_180495_p(pos)).func_177230_c().isLeaves(state, (IBlockAccess)GrazeEntityAI.this.world, pos) || state.func_177230_c().isAir(state, (IBlockAccess)GrazeEntityAI.this.world, pos)); ++i) {
                                        pos = pos.func_177977_b();
                                    }
                                    this.ai.moveTarget = pos;
                                    this.ai.targetVec = new Vec3d((double)this.ai.target.func_177958_n(), (double)this.ai.target.func_177956_o(), (double)this.ai.target.func_177952_p());
                                    break;
                                }
                            }
                            this.ai.searched = false;
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            if (this.moveTarget != null) {
                try {
                    if (metabolism.isStarving()) {
                        this.dinosaur.func_70661_as().func_75492_a((double)this.moveTarget.func_177958_n(), (double)this.moveTarget.func_177956_o(), (double)this.moveTarget.func_177952_p(), 1.2);
                    } else {
                        this.dinosaur.func_70661_as().func_75492_a((double)this.moveTarget.func_177958_n(), (double)this.moveTarget.func_177956_o(), (double)this.moveTarget.func_177952_p(), 0.7);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean feederExists() {
        if (tpe.getActiveCount() < 2) {
            final World world = this.dinosaur.field_70170_p;
            try {
                tpe.execute(new ThreadRunnable(this, this.dinosaur){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        World world2 = world;
                        synchronized (world2) {
                            GrazeEntityAI grazeEntityAI = this.ai;
                            synchronized (grazeEntityAI) {
                                this.ai.feederExists = this.entity.getClosestFeeder() != null;
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return this.feederExists;
    }

    public boolean func_75253_b() {
        if (this.target != null && this.world.func_175623_d(this.target) && !this.dinosaur.func_70661_as().func_75500_f()) {
            this.terminateTask();
            return false;
        }
        return this.target != null;
    }

    public void func_75246_d() {
        if (this.target != null) {
            try {
                Vec3d headPos = this.dinosaur.getHeadPos();
                Vec3d headVec = new Vec3d(headPos.field_72450_a, (double)this.target.func_177956_o(), headPos.field_72449_c);
                if (headVec.func_72436_e(this.targetVec) < 6.0) {
                    this.dinosaur.func_70661_as().func_75499_g();
                    this.dinosaur.func_70671_ap().func_75650_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), 30.0f, (float)this.dinosaur.func_70646_bf());
                    this.dinosaur.setAnimation(EntityAnimation.EATING.get());
                    if (this.target.func_177956_o() > 254) {
                        return;
                    }
                    Item item = Item.func_150898_a((Block)this.world.func_180495_p(this.target).func_177230_c());
                    this.world.func_175655_b(this.target, false);
                    this.dinosaur.getMetabolism().eat(FoodHelper.getHealAmount(item));
                    FoodHelper.applyEatEffects(this.dinosaur, item);
                    this.dinosaur.func_70691_i(10.0f);
                    this.previousTarget = null;
                    this.terminateTask();
                } else {
                    ++this.counter;
                    if (this.counter >= 400) {
                        this.counter = 0;
                        this.previousTarget = this.target;
                        this.terminateTask();
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void terminateTask() {
        this.dinosaur.func_70661_as().func_75499_g();
        this.target = null;
        this.dinosaur.setAnimation(EntityAnimation.IDLE.get());
    }

    abstract class ThreadRunnable
    implements Runnable {
        final DinosaurEntity entity;
        final GrazeEntityAI ai;

        ThreadRunnable(GrazeEntityAI grazeEntityAI, DinosaurEntity entity) {
            this.ai = grazeEntityAI;
            this.entity = entity;
        }
    }
}

