/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai.util;

import mod.reborn.server.entity.ai.util.RingXZTraverser;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AIUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static BlockPos findIntersect(BlockPos center, int radius, BlockPos start) {
        int deltaZ;
        int deltaX = start.func_177958_n() - center.func_177958_n();
        double distance = Math.sqrt(deltaX * deltaX + (deltaZ = start.func_177952_p() - center.func_177952_p()) * deltaZ);
        if (distance < (double)radius) {
            return start;
        }
        double scale = (double)radius / distance;
        return new BlockPos((double)((long)center.func_177958_n() + Math.round((double)deltaX * scale)), (double)center.func_177956_o(), (double)((long)center.func_177952_p() + Math.round((double)deltaZ * scale)));
    }

    public static BlockPos computePosToward(BlockPos current, BlockPos target, int move) {
        int deltaZ;
        int deltaX = target.func_177958_n() - current.func_177958_n();
        double distance = Math.sqrt(deltaX * deltaX + (deltaZ = target.func_177952_p() - current.func_177952_p()) * deltaZ);
        if (distance < (double)move) {
            return target;
        }
        double scale = (double)move / distance;
        return new BlockPos((double)((long)current.func_177958_n() + Math.round((double)deltaX * scale)), (double)current.func_177956_o(), (double)((long)current.func_177952_p() + Math.round((double)deltaZ * scale)));
    }

    public static BlockPos findSurface(EntityLiving entity) {
        if (!entity.func_70090_H()) {
            return null;
        }
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        return AIUtils.findSurface(world, pos.func_177979_c(MathHelper.func_76141_d((float)(entity.field_70131_O / 2.0f))));
    }

    public static BlockPos findSurface(World world, BlockPos pos) {
        while (!world.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        return pos;
    }

    public static int getWaterDepth(EntityLiving entity) {
        if (!entity.func_70090_H()) {
            return 0;
        }
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        int depth = 0;
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177984_a();
            ++depth;
        }
        pos = entity.func_180425_c().func_177977_b();
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177977_b();
            ++depth;
        }
        return depth;
    }

    public static int getWaterDepth(EntityLiving entity, boolean fromEntity) {
        if (!entity.func_70090_H()) {
            return 0;
        }
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        int depth = 0;
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177984_a();
            ++depth;
        }
        pos = entity.func_180425_c().func_177977_b();
        if (fromEntity) {
            depth = 0;
        }
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = pos.func_177977_b();
            ++depth;
        }
        return depth + 1;
    }

    public static BlockPos getBottom(EntityLiving entity) {
        return new BlockPos(entity.field_70165_t, (double)AIUtils.getWaterDepth(entity, true), entity.field_70161_v);
    }

    public static BlockPos findShore(World world, BlockPos center) {
        for (int radius = 1; radius < 32; ++radius) {
            RingXZTraverser traverser = new RingXZTraverser(center, radius);
            for (BlockPos pos : traverser) {
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockLiquid) continue;
                return pos;
            }
        }
        return null;
    }

    static void plotCircle(int x0, int y0, int radius) {
        int x = radius;
        int decisionOver2 = 1 - x;
        for (int y = 0; y <= x; ++y) {
            AIUtils.drawPixel(x + x0, y + y0);
            AIUtils.drawPixel(y + x0, x + y0);
            AIUtils.drawPixel(-x + x0, y + y0);
            AIUtils.drawPixel(-y + x0, x + y0);
            AIUtils.drawPixel(-x + x0, -y + y0);
            AIUtils.drawPixel(-y + x0, -x + y0);
            AIUtils.drawPixel(x + x0, -y + y0);
            AIUtils.drawPixel(y + x0, -x + y0);
            if (decisionOver2 <= 0) {
                decisionOver2 += 2 * y + 1;
                continue;
            }
            decisionOver2 += 2 * (y - --x) + 1;
        }
    }

    private static void drawPixel(int x, int y) {
        LOGGER.info("x=" + x + ", y=" + y);
    }
}

