/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBreaker {
    public static final float BASE_BREAK_FACTOR = 2.5f;
    private final World world;
    private final BlockPos pos;
    private final int totalProgress;
    private final int entityID;
    private int progress;
    private int previousProgress;

    public BlockBreaker(Entity entity, double digSpeed, BlockPos pos, double minSeconds) {
        this.world = entity.func_130014_f_();
        this.entityID = entity.func_145782_y();
        this.pos = pos;
        this.totalProgress = (int)Math.max(BlockBreaker.breakSeconds(this.world, digSpeed, pos), minSeconds) * 20;
    }

    public static double breakSeconds(World world, double digSpeed, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        return (double)(2.5f * hardness) / digSpeed;
    }

    public int ticksLeft() {
        return this.totalProgress - this.progress;
    }

    public boolean tickUpdate() {
        ++this.progress;
        int i = (int)((float)this.progress / (float)this.totalProgress * 10.0f);
        if (i != this.previousProgress) {
            this.world.func_175715_c(this.entityID, this.pos, i);
            this.previousProgress = i;
        }
        return this.progress > this.totalProgress;
    }

    public void reset() {
        this.progress = 0;
        this.previousProgress = 0;
        this.world.func_175715_c(this.entityID, this.pos, 0);
    }

    public String toString() {
        return "BlockBreaker{_pos=" + this.pos + ", _ticksNeeded=" + this.totalProgress + ", _entityID=" + this.entityID + ", _ticksDone=" + this.progress + '}';
    }
}

