/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.ai.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mod.reborn.server.entity.DinosaurEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DinosaurPersistenceHandler {
    private static final Map<UUID, DinosaurEntity> globalEntityTracker = new HashMap<UUID, DinosaurEntity>();

    public static void trackEntity(DinosaurEntity entity) {
        globalEntityTracker.put(entity.func_110124_au(), entity);
    }

    public static void untrackEntity(DinosaurEntity entity) {
        globalEntityTracker.remove(entity.func_110124_au());
    }

    public static DinosaurEntity getTrackedEntity(UUID uuid) {
        return globalEntityTracker.get(uuid);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)event.getEntity();
            DinosaurPersistenceHandler.trackEntity(dinosaur);
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)event.getEntity();
            DinosaurPersistenceHandler.trackEntity(dinosaur);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        for (ClassInheritanceMultiMap entityList : event.getChunk().func_177429_s()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof DinosaurEntity)) continue;
                DinosaurEntity dinosaur = (DinosaurEntity)entity;
                DinosaurPersistenceHandler.trackEntity(dinosaur);
            }
        }
    }
}

