/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.animal;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.model.animation.PoseHandler;
import mod.reborn.server.api.Animatable;
import mod.reborn.server.entity.GrowthStage;
import mod.reborn.server.entity.ai.SmartBodyHelper;
import mod.reborn.server.entity.animal.EntityShark;
import mod.reborn.server.entity.animal.ai.EntityAIFindWater;
import mod.reborn.server.entity.animal.ai.EntityAIWanderNearWater;
import mod.reborn.server.item.ItemHandler;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityCrab
extends EntityAnimal
implements Animatable,
IEntityAdditionalSpawnData {
    public static final PoseHandler<EntityCrab> CRAB_POSE_HANDLER = new PoseHandler("crab", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    private static final DataParameter<Boolean> WATCHER_IS_RUNNING = EntityDataManager.func_187226_a(EntityCrab.class, (DataSerializer)DataSerializers.field_187198_h);
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private boolean inLava;
    private boolean alternative;

    public EntityCrab(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.3f);
        this.field_70138_W = 1.0f;
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityCrab(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ItemHandler.PLANKTON;
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0, 10, 10));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWanderNearWater((EntityCreature)this, 1.0, 5, 2));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityShark.class, 9.0f, 1.0, (double)1.45f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a((Item)(this.func_70027_ad() ? ItemHandler.CRAB_MEAT_COOKED : ItemHandler.CRAB_MEAT_RAW), this.field_70146_Z.nextInt(2) + 1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_IS_RUNNING, (Object)false);
    }

    protected EntityBodyHelper func_184650_s() {
        return new SmartBodyHelper((EntityLiving)this);
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public boolean isMoving() {
        float deltaX = (float)(this.field_70165_t - this.field_70169_q);
        float deltaZ = (float)(this.field_70161_v - this.field_70166_s);
        return deltaX * deltaX + deltaZ * deltaZ > 0.001f;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean isSwimming() {
        return this.func_180799_ab();
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_RUNNING);
    }

    @Override
    public boolean inWater() {
        return this.func_70090_H();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return growthStage == GrowthStage.ADULT;
    }

    @Override
    public boolean isMarineCreature() {
        return true;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    @Override
    public boolean isSleeping() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 10 == 0) {
            this.inLava = this.func_180799_ab();
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(EntityAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_RUNNING, (Object)((double)this.func_70689_ay() > this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() ? 1 : 0));
        }
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return GrowthStage.ADULT;
    }

    public PoseHandler getPoseHandler() {
        return CRAB_POSE_HANDLER;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void setAnimation(Animation newAnimation) {
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w += (double)((strafe *= f) * f2 - (forward *= f) * f1);
            this.field_70181_x += (double)(up *= f);
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    protected void func_70629_bd() {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public Type getType() {
        return this.alternative ? Type.ALTERNATIVE : Type.CRAB;
    }

    public static enum Type {
        CRAB,
        ALTERNATIVE;

    }
}

