/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.animal;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.model.animation.PoseHandler;
import mod.reborn.server.api.Animatable;
import mod.reborn.server.entity.GrowthStage;
import mod.reborn.server.entity.ai.SmartBodyHelper;
import mod.reborn.server.entity.animal.EntityCrab;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.entity.animal.ai.MoveUnderwaterEntityAI;
import mod.reborn.server.item.ItemHandler;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityShark
extends EntityAnimal
implements Animatable,
IEntityAdditionalSpawnData,
IMob {
    public static final PoseHandler<EntityShark> SHARK_POSE_HANDLER = new PoseHandler("shark", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    private static final DataParameter<Boolean> WATCHER_IS_RUNNING = EntityDataManager.func_187226_a(EntityShark.class, (DataSerializer)DataSerializers.field_187198_h);
    public ChainBuffer tailBuffer;
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private boolean inLava;
    public boolean isSpawnedByEgg;

    public EntityShark(World world) {
        super(world);
        this.func_70105_a(1.6f, 0.8f);
        this.field_70138_W = 1.0f;
        this.animationTick = 0;
        this.field_70156_m = false;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new SwimmingMoveHelper();
        this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, world);
        this.setAnimation(EntityAnimation.IDLE.get());
        this.isSpawnedByEgg = false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("egg_spawned", this.isSpawnedByEgg);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isSpawnedByEgg = compound.func_74767_n("egg_spawned");
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityShark(this.field_70170_p);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_70629_bd() {
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a((Item)(this.func_70027_ad() ? ItemHandler.SHARK_MEAT_COOKED : ItemHandler.SHARK_MEAT_RAW), this.field_70146_Z.nextInt(2) + 1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, GoatEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCrab.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySquid.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_IS_RUNNING, (Object)false);
    }

    protected EntityBodyHelper func_184650_s() {
        return new SmartBodyHelper((EntityLiving)this);
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public boolean isMoving() {
        float deltaX = (float)(this.field_70165_t - this.field_70169_q);
        float deltaZ = (float)(this.field_70161_v - this.field_70166_s);
        return deltaX * deltaX + deltaZ * deltaZ > 0.001f;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean isSwimming() {
        return this.func_180799_ab() || this.func_70090_H();
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(WATCHER_IS_RUNNING);
    }

    @Override
    public boolean inWater() {
        return this.func_70090_H();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return growthStage == GrowthStage.ADULT;
    }

    @Override
    public boolean isMarineCreature() {
        return true;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    @Override
    public boolean isSleeping() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175659_aa();
        }
        if (this.field_70173_aa % 10 == 0) {
            this.inLava = this.func_180799_ab();
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(EntityAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_IS_RUNNING, (Object)((double)this.func_70689_ay() > this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() ? 1 : 0));
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return GrowthStage.ADULT;
    }

    public PoseHandler getPoseHandler() {
        return SHARK_POSE_HANDLER;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void setAnimation(Animation newAnimation) {
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H() && !this.isCarcass()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.7;
            this.field_70181_x *= 0.7;
            this.field_70179_y *= 0.7;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151115_aP);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MoveUnderwaterEntityAI((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.6, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.func_175456_n();
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final EntityShark swimmingEntity;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntityShark.this);
            this.swimmingEntity = EntityShark.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.swimmingEntity.func_70661_as().func_75500_f() && this.swimmingEntity.func_70090_H()) {
                double distanceX = this.field_75646_b - this.swimmingEntity.field_70165_t;
                double distanceY = this.field_75647_c - this.swimmingEntity.field_70163_u;
                double distanceZ = this.field_75644_d - this.swimmingEntity.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distance = MathHelper.func_76133_a((double)distance);
                float f = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.swimmingEntity.field_70177_z = this.func_75639_a(this.swimmingEntity.field_70177_z, f, 30.0f);
                this.swimmingEntity.func_70659_e((float)(this.swimmingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * this.field_75645_e));
                this.swimmingEntity.field_70181_x += (double)this.swimmingEntity.func_70689_ay() * (distanceY /= distance) * 0.05;
            } else {
                this.swimmingEntity.func_70659_e(0.0f);
            }
        }
    }
}

