/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.LeapingMeleeEntityAI;
import mod.reborn.server.entity.ai.RaptorLeapEntityAI;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.entity.dinosaur.CrassigyrinusEntity;
import mod.reborn.server.entity.dinosaur.DimetrodonEntity;
import mod.reborn.server.entity.dinosaur.DodoEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.MicroraptorEntity;
import mod.reborn.server.entity.dinosaur.OthnieliaEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CompsognathusEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(CompsognathusEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public CompsognathusEntity(World world) {
        super(world);
        this.setVariant(this.func_70681_au().nextInt(6));
        this.doesEatEggs(true);
        this.target(DodoEntity.class, OthnieliaEntity.class, MicroceratusEntity.class, DimetrodonEntity.class, MicroraptorEntity.class, CrassigyrinusEntity.class, LeptictidiumEntity.class, EntityPlayer.class, EntityAnimal.class, EntityVillager.class, GoatEntity.class);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RaptorLeapEntityAI(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new CompyHurtByTarget());
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new RaptorLeapEntityAI(this);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.COMPSOGNATHUS_LIVING;
            }
            case DYING: {
                return SoundHandler.COMPSOGNATHUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.COMPSOGNATHUS_HURT;
            }
            case CALLING: {
                return SoundHandler.COMPSOGNATHUS_CALL;
            }
            case BEGGING: {
                return SoundHandler.COMPSOGNATHUS_THREAT;
            }
        }
        return null;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("nostripes");
            }
            case 1: {
                return this.texture("stripes");
            }
            case 2: {
                return this.texture("lightstripes");
            }
            case 3: {
                return this.texture("orange");
            }
            case 4: {
                return this.texture("blue");
            }
            case 5: 
        }
        return this.texture("purple");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }

    class CompyHurtByTarget
    extends EntityAIHurtByTarget {
        public CompyHurtByTarget() {
            super((EntityCreature)CompsognathusEntity.this, true, new Class[0]);
        }

        public void func_75249_e() {
            if (CompsognathusEntity.this.herd.size() >= 3) {
                super.func_75249_e();
                if (CompsognathusEntity.this.func_70631_g_()) {
                    this.func_190105_f();
                    this.func_75251_c();
                }
            }
        }

        protected void setEntityAttackTarget(DinosaurEntity creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof CompsognathusEntity && !creatureIn.func_70631_g_() && creatureIn != null) {
                super.func_179446_a((EntityCreature)creatureIn, entityLivingBaseIn);
            }
        }
    }
}

