/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.VenomEntity;
import mod.reborn.server.entity.ai.DilophosaurusMeleeEntityAI;
import mod.reborn.server.entity.ai.DilophosaurusSpitEntityAI;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.entity.dinosaur.AchillobatorEntity;
import mod.reborn.server.entity.dinosaur.AlligatorGarEntity;
import mod.reborn.server.entity.dinosaur.AlvarezsaurusEntity;
import mod.reborn.server.entity.dinosaur.ArsinoitheriumEntity;
import mod.reborn.server.entity.dinosaur.BeelzebufoEntity;
import mod.reborn.server.entity.dinosaur.ChasmosaurusEntity;
import mod.reborn.server.entity.dinosaur.ChilesaurusEntity;
import mod.reborn.server.entity.dinosaur.CoelurusEntity;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.CrassigyrinusEntity;
import mod.reborn.server.entity.dinosaur.DimetrodonEntity;
import mod.reborn.server.entity.dinosaur.DiplocaulusEntity;
import mod.reborn.server.entity.dinosaur.DodoEntity;
import mod.reborn.server.entity.dinosaur.GallimimusEntity;
import mod.reborn.server.entity.dinosaur.GuanlongEntity;
import mod.reborn.server.entity.dinosaur.HyaenodonEntity;
import mod.reborn.server.entity.dinosaur.HypsilophodonEntity;
import mod.reborn.server.entity.dinosaur.LeaellynasauraEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.MegapiranhaEntity;
import mod.reborn.server.entity.dinosaur.MegatheriumEntity;
import mod.reborn.server.entity.dinosaur.MetriacanthosaurusEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.MicroraptorEntity;
import mod.reborn.server.entity.dinosaur.MussaurusEntity;
import mod.reborn.server.entity.dinosaur.OrnithomimusEntity;
import mod.reborn.server.entity.dinosaur.OthnieliaEntity;
import mod.reborn.server.entity.dinosaur.OviraptorEntity;
import mod.reborn.server.entity.dinosaur.PachycephalosaurusEntity;
import mod.reborn.server.entity.dinosaur.PostosuchusEntity;
import mod.reborn.server.entity.dinosaur.ProceratosaurusEntity;
import mod.reborn.server.entity.dinosaur.ProtoceratopsEntity;
import mod.reborn.server.entity.dinosaur.SegisaurusEntity;
import mod.reborn.server.entity.dinosaur.SmilodonEntity;
import mod.reborn.server.entity.dinosaur.SpinoraptorEntity;
import mod.reborn.server.entity.dinosaur.TroodonEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorBlueEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorCharlieEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorDeltaEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorEchoEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DilophosaurusEntity
extends DinosaurEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> WATCHER_HAS_TARGET = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int targetCooldown;

    public DilophosaurusEntity(World world) {
        super(world);
        this.target(GoatEntity.class, SmilodonEntity.class, DimetrodonEntity.class, MegatheriumEntity.class, ArsinoitheriumEntity.class, SpinoraptorEntity.class, EntityPlayer.class, EntityVillager.class, EntityAnimal.class, AchillobatorEntity.class, AlligatorGarEntity.class, AlvarezsaurusEntity.class, BeelzebufoEntity.class, VelociraptorBlueEntity.class, VelociraptorCharlieEntity.class, ChasmosaurusEntity.class, ChilesaurusEntity.class, CoelurusEntity.class, CompsognathusEntity.class, CrassigyrinusEntity.class, VelociraptorDeltaEntity.class, DodoEntity.class, DiplocaulusEntity.class, VelociraptorEchoEntity.class, GallimimusEntity.class, GuanlongEntity.class, HyaenodonEntity.class, HypsilophodonEntity.class, LeaellynasauraEntity.class, LeptictidiumEntity.class, MegapiranhaEntity.class, MetriacanthosaurusEntity.class, MicroceratusEntity.class, MicroraptorEntity.class, MussaurusEntity.class, OrnithomimusEntity.class, OthnieliaEntity.class, OviraptorEntity.class, PostosuchusEntity.class, ProceratosaurusEntity.class, ProtoceratopsEntity.class, SegisaurusEntity.class, TroodonEntity.class, VelociraptorEntity.class, PachycephalosaurusEntity.class);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DilophosaurusMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_184812_l_()) {
            return;
        }
        VenomEntity venom = new VenomEntity(this.field_70170_p, this);
        double deltaX = target.field_70165_t - venom.field_70165_t;
        double deltaY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - venom.field_70163_u;
        double deltaZ = target.field_70161_v - venom.field_70161_v;
        float yOffset = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 0.2f;
        venom.func_70186_c(deltaX, deltaY + (double)yOffset, deltaZ, 1.5f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)venom);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new DilophosaurusSpitEntityAI(this, this.dinosaur.getAttackSpeed(), 40, 10.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_HAS_TARGET, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase target = this.func_70638_az();
            if (target != null && !target.field_70128_L && this.targetCooldown < 50) {
                this.targetCooldown = 50 + this.func_70681_au().nextInt(30);
            } else if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.field_70180_af.func_187227_b(WATCHER_HAS_TARGET, (Object)this.hasTarget());
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 1, false, false));
            }
            return true;
        }
        return false;
    }

    public boolean hasTarget() {
        if (!this.isCarcass() && !this.isSleeping()) {
            if (this.field_70170_p.field_72995_K) {
                return (Boolean)this.field_70180_af.func_187225_a(WATCHER_HAS_TARGET);
            }
            EntityLivingBase target = this.func_70638_az();
            return target != null && !target.field_70128_L || this.targetCooldown > 0;
        }
        return false;
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case CALLING: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.DILOPHOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.DILOPHOSAURUS_HURT;
            }
            case ATTACKING: {
                return SoundHandler.DILOPHOSAURUS_SPIT;
            }
        }
        return null;
    }
}

