/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class DiplodocusEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(DiplodocusEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public DiplodocusEntity(World world) {
        super(world);
        this.setVariant(this.func_70681_au().nextInt(5));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.DIPLODOCUS_LIVING;
            }
            case DYING: {
                return SoundHandler.DIPLODOCUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.DIPLODOCUS_HURT;
            }
            case CALLING: {
                return SoundHandler.DIPLODOCUS_LIVING;
            }
            case BEGGING: {
                return SoundHandler.DIPLODOCUS_HURT;
            }
            case WALKING: {
                return SoundHandler.STOMP;
            }
        }
        return null;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("brown");
            }
            case 1: {
                return this.texture("coastal");
            }
            case 2: {
                return this.texture("mesa");
            }
            case 3: {
                return this.texture("red");
            }
            case 4: 
        }
        return this.texture("vivid");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }
}

