/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IndominusEntity
extends DinosaurEntity {
    private static final DataParameter<Boolean> DATA_WATCHER_IS_CAMOUFLAGING = EntityDataManager.func_187226_a(IndominusEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private float[] newSkinColor = new float[3];
    private float[] skinColor = new float[3];
    private int stepCount = 0;
    private boolean isCamouflaging;

    public IndominusEntity(World world) {
        super(world);
        this.target(EntityLivingBase.class, EntityPlayer.class);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_WATCHER_IS_CAMOUFLAGING, (Object)false);
    }

    @Override
    public void setupDisplay(boolean isMale) {
        super.setupDisplay(isMale);
        this.isCamouflaging = true;
        this.skinColor = new float[]{255.0f, 255.0f, 255.0f};
        this.newSkinColor = new float[]{255.0f, 255.0f, 255.0f};
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_191988_bg > 0.0f && this.stepCount <= 0) {
            this.func_184185_a(SoundHandler.STOMP, (float)this.interpolate(0.1f, 1.0), this.func_70647_i());
            this.stepCount = 65;
        }
        this.stepCount = (int)((double)this.stepCount - (double)this.field_191988_bg * 9.5);
        if (this.field_70170_p.field_72995_K) {
            this.isCamouflaging = (Boolean)this.field_70180_af.func_187225_a(DATA_WATCHER_IS_CAMOUFLAGING);
            this.changeSkinColor();
        } else {
            this.field_70180_af.func_187227_b(DATA_WATCHER_IS_CAMOUFLAGING, (Object)this.isCamouflaging);
        }
    }

    @Override
    public float func_70599_aP() {
        return (float)this.interpolate(0.9f, 1.6f) + (this.field_70146_Z.nextFloat() - 0.5f) * 0.125f;
    }

    public boolean isCamouflaging() {
        return this.isCamouflaging;
    }

    public void changeSkinColor() {
        int color;
        BlockPos pos = new BlockPos((Entity)this).func_177972_a(EnumFacing.DOWN);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (this.isCamouflaging()) {
            color = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)this.field_70170_p, pos, 0);
            if (color == 0xFFFFFF) {
                color = state.func_185909_g((IBlockAccess)this.field_70170_p, (BlockPos)pos).field_76291_p;
            }
        } else {
            color = 0xFFFFFF;
        }
        if (color != 0) {
            this.newSkinColor[0] = color >> 16 & 0xFF;
            this.newSkinColor[1] = color >> 8 & 0xFF;
            this.newSkinColor[2] = color & 0xFF;
            if (this.skinColor[0] == 0.0f && this.skinColor[1] == 0.0f && this.skinColor[2] == 0.0f) {
                this.skinColor[0] = this.newSkinColor[0];
                this.skinColor[1] = this.newSkinColor[1];
                this.skinColor[2] = this.newSkinColor[2];
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.skinColor[i] < this.newSkinColor[i]) {
                int n = i;
                this.skinColor[n] = this.skinColor[n] + 1.0f;
            }
            if (!(this.skinColor[i] > this.newSkinColor[i])) continue;
            int n = i;
            this.skinColor[n] = this.skinColor[n] - 1.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getSkinColor() {
        return new float[]{this.skinColor[0] / 255.0f, this.skinColor[1] / 255.0f, this.skinColor[2] / 255.0f};
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.INDOMINUS_LIVING;
            }
            case DYING: {
                return SoundHandler.INDOMINUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.INDOMINUS_HURT;
            }
            case ROARING: {
                return SoundHandler.INDOMINUS_ROAR;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.INDOMINUS_BREATHING;
    }
}

