/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.LeapingMeleeEntityAI;
import mod.reborn.server.entity.ai.RaptorLeapEntityAI;
import mod.reborn.server.entity.dinosaur.GiganotosaurusEntity;
import mod.reborn.server.entity.dinosaur.SpinosaurusEntity;
import mod.reborn.server.entity.dinosaur.TyrannosaurusEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class IndoraptorEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(IndoraptorEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Class[] targets = new Class[]{EntityLivingBase.class, EntityPlayer.class};

    public IndoraptorEntity(World world) {
        super(world);
        this.setVariant(this.func_70681_au().nextInt(2));
        this.target(EntityLivingBase.class, EntityPlayer.class);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RaptorLeapEntityAI(this));
        this.target(targets);
        for (Class entity : targets) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entity, true, false));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entity, true));
        }
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class, TyrannosaurusEntity.class, GiganotosaurusEntity.class, SpinosaurusEntity.class}));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.INDORAPTOR_LIVING;
            }
            case CALLING: {
                return SoundHandler.INDORAPTOR_CALLING;
            }
            case DYING: {
                return SoundHandler.INDORAPTOR_DEATH;
            }
            case BEGGING: {
                return SoundHandler.INDORAPTOR_THREAT;
            }
            case INJURED: {
                return SoundHandler.INDORAPTOR_HURT;
            }
            case ROARING: {
                return SoundHandler.INDORAPTOR_ROAR;
            }
            case MATING: {
                return SoundHandler.INDORAPTOR_MATING;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.INDORAPTOR_BREATHING;
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new RaptorLeapEntityAI(this);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("black");
            }
            case 1: 
        }
        return this.texture("white");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }
}

