/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import mod.reborn.RebornMod;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.proxy.ClientProxy;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.conf.RebornConfig;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.LeapingMeleeEntityAI;
import mod.reborn.server.entity.ai.RaptorClimbTreeAI;
import mod.reborn.server.entity.ai.RaptorLeapEntityAI;
import mod.reborn.server.entity.ai.animations.BirdPreenAnimationAI;
import mod.reborn.server.entity.ai.animations.TailDisplayAnimationAI;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.HypsilophodonEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.OthnieliaEntity;
import mod.reborn.server.event.KeyBindingHandler;
import mod.reborn.server.message.MicroraptorDismountMessage;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MicroraptorEntity
extends DinosaurEntity {
    private int flyTime;
    private int groundHeight;
    private Vec3d glidingPos;

    public MicroraptorEntity(World world) {
        super(world);
        this.target(EntityChicken.class, EntityRabbit.class, CompsognathusEntity.class, HypsilophodonEntity.class, LeptictidiumEntity.class, MicroceratusEntity.class, OthnieliaEntity.class);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RaptorClimbTreeAI(this, 1.0));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new BirdPreenAnimationAI(this));
        this.animationTasks.func_75776_a(3, (EntityAIBase)new TailDisplayAnimationAI(this));
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        return damageSource != DamageSource.field_188406_j && super.func_70097_a(damageSource, amount);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    @Override
    public void func_70071_h_() {
        boolean climbing;
        super.func_70071_h_();
        Animation curAni = this.getAnimation();
        boolean bl = climbing = curAni == EntityAnimation.CLIMBING.get() || curAni == EntityAnimation.START_CLIMBING.get();
        if (climbing) {
            BlockPos trunk = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (this.field_70170_p.func_175623_d(trunk.func_177972_a(facing)) || !this.field_70170_p.func_175665_u(trunk.func_177972_a(facing))) continue;
                this.field_70177_z = this.field_70126_B = facing.func_185119_l();
                this.field_70758_at = this.field_70126_B;
                this.field_70759_as = this.field_70126_B;
                this.field_70761_aq = this.field_70760_ar = this.field_70177_z;
                this.field_70716_bi = 0;
                break;
            }
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        float prevRot = this.field_70125_A;
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && this.glidingPos != null) {
            this.field_70125_A = (float)(-Math.toDegrees(Math.asin((this.glidingPos.field_72448_b - this.field_70163_u) / this.glidingPos.func_72438_d(this.func_174791_d()))));
        }
        super.func_191986_a(strafe, vertical, forward);
        this.field_70125_A = prevRot;
    }

    @Override
    public void func_70636_d() {
        boolean leaping;
        Animation curAni;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        boolean landing = (curAni = this.getAnimation()) == EntityAnimation.LEAP_LAND.get();
        boolean gliding = curAni == EntityAnimation.GLIDING.get();
        boolean climbing = curAni == EntityAnimation.CLIMBING.get() || curAni == EntityAnimation.START_CLIMBING.get();
        boolean bl = leaping = curAni == EntityAnimation.LEAP.get();
        if (this.field_70122_E || this.inWater() || this.inLava() || this.isSwimming()) {
            this.flyTime = 0;
            if (gliding || landing) {
                this.setAnimation(EntityAnimation.IDLE.get());
                this.func_70052_a(7, false);
            }
        } else {
            ++this.flyTime;
            if (this.flyTime > 4 && !leaping) {
                if (!landing) {
                    if (!gliding) {
                        if (!climbing) {
                            this.setAnimation(EntityAnimation.GLIDING.get());
                        }
                    } else if (!this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
                        this.setAnimation(EntityAnimation.LEAP_LAND.get());
                    }
                }
                if (gliding) {
                    this.func_70052_a(7, true);
                }
            }
        }
        if (this.func_184613_cA()) {
            this.groundHeight = 0;
            BlockPos pos = this.func_180425_c();
            while (this.groundHeight <= 10 && !this.field_70170_p.isSideSolid(pos, EnumFacing.UP, true)) {
                pos = pos.func_177977_b();
                ++this.groundHeight;
            }
        }
        if (this.func_70613_aW()) {
            this.func_70671_ap().func_75649_a();
        }
    }

    @Override
    public EntityLookHelper func_70671_ap() {
        return super.func_70671_ap();
    }

    public Vec3d func_70040_Z() {
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && this.glidingPos != null) {
            double distance = this.glidingPos.func_72438_d(this.func_174791_d());
            return new Vec3d((this.glidingPos.field_72450_a - this.field_70165_t) / distance, (this.glidingPos.field_72448_b - this.field_70163_u) / distance, (this.glidingPos.field_72449_c - this.field_70161_v) / distance);
        }
        return super.func_70040_Z();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && hand == EnumHand.MAIN_HAND && this.isOwner(player) && this.order == DinosaurEntity.Order.SIT && player.func_184188_bt() != null && player.func_184188_bt().size() < 2) {
            return this.func_184205_a((Entity)player, true);
        }
        return super.func_184645_a(player, hand);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && slot == EntityEquipmentSlot.CHEST) {
            return new ItemStack(Items.field_185160_cR);
        }
        return super.func_184582_a(slot);
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new RaptorLeapEntityAI(this);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            super.func_180430_e(distance / 2.0f, damageMultiplier);
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.MICRORAPTOR_LIVING;
            }
            case DYING: {
                return SoundHandler.MICRORAPTOR_DEATH;
            }
            case INJURED: {
                return SoundHandler.MICRORAPTOR_HURT;
            }
            case ATTACKING: {
                return SoundHandler.MICRORAPTOR_ATTACK;
            }
            case CALLING: {
                return SoundHandler.MICRORAPTOR_LIVING;
            }
        }
        return null;
    }

    public int func_82143_as() {
        return 100;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    private void updateRiding(Entity riding) {
        if (riding.func_184196_w((Entity)this) && riding instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)riding;
            int ridingIndex = riding.func_184188_bt().indexOf(this);
            float radius = (ridingIndex == 2 ? 0.0f : 0.35f) + (float)(player.func_184613_cA() ? 2 : 0);
            float renderYawOffset = player.field_70761_aq;
            float angle = (float)Math.toRadians(renderYawOffset + (float)(ridingIndex == 1 ? -90 : (ridingIndex == 0 ? 90 : 0)));
            double offsetX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double offsetZ = radius * MathHelper.func_76134_b((float)angle);
            double offsetY = (riding.func_70093_af() ? 1.2 : 1.38) + (ridingIndex == 2 ? 0.4 : 0.0);
            this.field_70177_z = player.field_70759_as;
            this.field_70759_as = player.field_70759_as;
            this.field_70126_B = player.field_70759_as;
            this.func_70107_b(riding.field_70165_t + offsetX, riding.field_70163_u + offsetY, riding.field_70161_v + offsetZ);
            this.setAnimation(EntityAnimation.IDLE.get());
            if (player.func_184613_cA()) {
                this.func_184210_p();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            ClientProxy.getKeyHandler();
            if (KeyBindingHandler.MICRORAPTOR_DISMOUNT.func_151470_d()) {
                RebornMod.NETWORK_WRAPPER.sendToServer((IMessage)new MicroraptorDismountMessage(this.func_145782_y()));
            }
        }
    }

    @Override
    public boolean canDinoSwim() {
        return RebornConfig.ENTITIES.featheredDinosaurSwimming;
    }

    @Override
    public boolean shouldEscapeWaterFast() {
        int radiusXZ = 4;
        for (BlockPos pos : BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)(this.field_70165_t - (double)radiusXZ)), (int)MathHelper.func_76128_c((double)this.field_70163_u), (int)MathHelper.func_76128_c((double)(this.field_70161_v - (double)radiusXZ)), (int)MathHelper.func_76143_f((double)(this.field_70165_t + (double)radiusXZ)), (int)MathHelper.func_76143_f((double)this.field_70163_u), (int)MathHelper.func_76143_f((double)(this.field_70161_v + (double)radiusXZ)))) {
            if (this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) continue;
            return false;
        }
        return false;
    }

    public void setGlidingTo(Vec3d glidingPos) {
        this.glidingPos = glidingPos;
    }
}

