/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.OthnieliaEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class OviraptorEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(OviraptorEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public OviraptorEntity(World world) {
        super(world);
        this.target(CompsognathusEntity.class, LeptictidiumEntity.class, OthnieliaEntity.class, EntityPlayer.class, EntityAnimal.class, EntityVillager.class, GoatEntity.class);
        this.doesEatEggs(true);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.setVariant(this.func_70681_au().nextInt(4));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.OVIRAPTOR_LIVING;
            }
            case DYING: {
                return SoundHandler.OVIRAPTOR_DEATH;
            }
            case INJURED: {
                return SoundHandler.OVIRAPTOR_HURT;
            }
            case BEGGING: {
                return SoundHandler.OVIRAPTOR_THREAT;
            }
        }
        return null;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("jungle");
            }
            case 1: {
                return this.texture("brown");
            }
            case 2: {
                return this.texture("color");
            }
            case 3: 
        }
        return this.texture("jwd");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }
}

