/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.ai.LeapingMeleeEntityAI;
import mod.reborn.server.entity.ai.RaptorLeapEntityAI;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.entity.dinosaur.AchillobatorEntity;
import mod.reborn.server.entity.dinosaur.AlligatorGarEntity;
import mod.reborn.server.entity.dinosaur.AlvarezsaurusEntity;
import mod.reborn.server.entity.dinosaur.ArsinoitheriumEntity;
import mod.reborn.server.entity.dinosaur.BeelzebufoEntity;
import mod.reborn.server.entity.dinosaur.CearadactylusEntity;
import mod.reborn.server.entity.dinosaur.ChilesaurusEntity;
import mod.reborn.server.entity.dinosaur.CoelurusEntity;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.DilophosaurusEntity;
import mod.reborn.server.entity.dinosaur.DimorphodonEntity;
import mod.reborn.server.entity.dinosaur.DodoEntity;
import mod.reborn.server.entity.dinosaur.ElasmotheriumEntity;
import mod.reborn.server.entity.dinosaur.GallimimusEntity;
import mod.reborn.server.entity.dinosaur.GiganotosaurusEntity;
import mod.reborn.server.entity.dinosaur.GuanlongEntity;
import mod.reborn.server.entity.dinosaur.HypsilophodonEntity;
import mod.reborn.server.entity.dinosaur.LeaellynasauraEntity;
import mod.reborn.server.entity.dinosaur.LeptictidiumEntity;
import mod.reborn.server.entity.dinosaur.MammothEntity;
import mod.reborn.server.entity.dinosaur.MegatheriumEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.MicroraptorEntity;
import mod.reborn.server.entity.dinosaur.MussaurusEntity;
import mod.reborn.server.entity.dinosaur.OrnithomimusEntity;
import mod.reborn.server.entity.dinosaur.OthnieliaEntity;
import mod.reborn.server.entity.dinosaur.OviraptorEntity;
import mod.reborn.server.entity.dinosaur.PostosuchusEntity;
import mod.reborn.server.entity.dinosaur.ProceratosaurusEntity;
import mod.reborn.server.entity.dinosaur.ProtoceratopsEntity;
import mod.reborn.server.entity.dinosaur.SegisaurusEntity;
import mod.reborn.server.entity.dinosaur.SpinosaurusEntity;
import mod.reborn.server.entity.dinosaur.StegosaurusEntity;
import mod.reborn.server.entity.dinosaur.TitanisEntity;
import mod.reborn.server.entity.dinosaur.TroodonEntity;
import mod.reborn.server.entity.dinosaur.TyrannosaurusEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorBlueEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorCharlieEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorDeltaEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorEchoEntity;
import mod.reborn.server.entity.dinosaur.VelociraptorEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class SmilodonEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(SmilodonEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Class[] targets = new Class[]{CompsognathusEntity.class, MammothEntity.class, VelociraptorEntity.class, VelociraptorBlueEntity.class, VelociraptorCharlieEntity.class, VelociraptorDeltaEntity.class, VelociraptorEchoEntity.class, MegatheriumEntity.class, ElasmotheriumEntity.class, ArsinoitheriumEntity.class, EntityPlayer.class, DilophosaurusEntity.class, DimorphodonEntity.class, DodoEntity.class, LeaellynasauraEntity.class, HypsilophodonEntity.class, StegosaurusEntity.class, ProtoceratopsEntity.class, OthnieliaEntity.class, MicroceratusEntity.class};

    public SmilodonEntity(World world) {
        super(world);
        this.setVariant(this.func_70681_au().nextInt(3));
        this.target(GoatEntity.class, EntityPlayer.class, TitanisEntity.class, EntityAnimal.class, EntityVillager.class, AchillobatorEntity.class, AlligatorGarEntity.class, AlvarezsaurusEntity.class, BeelzebufoEntity.class, CearadactylusEntity.class, ChilesaurusEntity.class, CoelurusEntity.class, CompsognathusEntity.class, DilophosaurusEntity.class, DimorphodonEntity.class, GallimimusEntity.class, ProceratosaurusEntity.class, GuanlongEntity.class, DodoEntity.class, HypsilophodonEntity.class, LeaellynasauraEntity.class, LeptictidiumEntity.class, MicroraptorEntity.class, MussaurusEntity.class, MicroceratusEntity.class, OrnithomimusEntity.class, OthnieliaEntity.class, OviraptorEntity.class, PostosuchusEntity.class, ProtoceratopsEntity.class, SegisaurusEntity.class, TroodonEntity.class);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RaptorLeapEntityAI(this));
        this.target(targets);
        for (Class entity : targets) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entity, true, false));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entity, true));
        }
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class, TyrannosaurusEntity.class, GiganotosaurusEntity.class, SpinosaurusEntity.class}));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.SMILODON_LIVING;
            }
            case DYING: {
                return SoundHandler.SMILODON_DEATH;
            }
            case INJURED: {
                return SoundHandler.SMILODON_HURT;
            }
            case CALLING: {
                return SoundHandler.SMILODON_LIVING;
            }
            case ROARING: {
                return SoundHandler.SMILODON_ROAR;
            }
            case BEGGING: {
                return SoundHandler.SMILODON_HURT;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.SMILODON_BREATHING;
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new RaptorLeapEntityAI(this);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("orange");
            }
            case 1: {
                return this.texture("jw");
            }
            case 2: 
        }
        return this.texture("gray");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }
}

