/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.dinosaur;

import java.util.Locale;
import mod.reborn.client.model.animation.EntityAnimation;
import mod.reborn.client.sound.SoundHandler;
import mod.reborn.server.entity.DinosaurEntity;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class StyracosaurusEntity
extends DinosaurEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(StyracosaurusEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static boolean isKingSet = false;
    private boolean isKing = false;
    private StyracosaurusEntity king = null;

    public StyracosaurusEntity(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.setVariant(this.func_70681_au().nextInt(3));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.STYRACOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.STYRACOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.STYRACOSAURUS_HURT;
            }
            case CALLING: {
                return SoundHandler.STYRACOSAURUS_CALL;
            }
            case ROARING: {
                return SoundHandler.STYRACOSAURUS_ROAR;
            }
            case BEGGING: {
                return SoundHandler.STYRACOSAURUS_THREAT;
            }
        }
        return null;
    }

    @Override
    public void func_70636_d() {
        double distance2 = 18.0;
        Entity entityFound2 = null;
        double d4 = -1.0;
        for (Entity currE : this.field_70170_p.field_72996_f) {
            double d5;
            if (!(currE instanceof StyracosaurusEntity) || !((d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v)) < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound2 = currE;
        }
        if (entityFound2 != null && !isKingSet) {
            this.king = (StyracosaurusEntity)entityFound2;
            this.king.isKing = true;
            isKingSet = true;
        }
        if (this.king == null) {
            isKingSet = false;
        }
        if (!this.isKing && isKingSet) {
            this.field_70765_h.func_75642_a(this.king.field_70165_t, this.king.field_70163_u, this.king.field_70161_v, 1.0);
        }
        super.func_70636_d();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setVariant(tagCompound.func_74762_e("Variant"));
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("black");
            }
            case 1: {
                return this.texture("gray");
            }
            case 2: 
        }
        return this.texture("jpog");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("rebornmod", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("rebornmod", texture + "_female_adult_" + variant + ".png");
    }
}

