/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.item;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttractionSignEntity
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> IS_ATTRACTION_SIGN = entity -> entity instanceof AttractionSignEntity;
    public AttractionSignType type;

    public AttractionSignEntity(World world) {
        super(world);
    }

    public AttractionSignEntity(World world, BlockPos pos, EnumFacing side, AttractionSignType type) {
        super(world, pos);
        this.type = type;
        this.func_174859_a(side);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("Type", (byte)this.type.ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.type = AttractionSignType.values()[compound.func_74771_c("Type")];
        super.func_70037_a(compound);
    }

    public int func_82329_d() {
        return this.type.sizeX;
    }

    public int func_82330_g() {
        return this.type.sizeY / 2;
    }

    public void func_110128_b(Entity entity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack((Item)ItemHandler.ATTRACTION_SIGN, 1, this.type.ordinal()), 0.0f);
        }
    }

    public void func_184523_o() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos positionOffset = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos newPosition = this.field_174861_a.func_177971_a((Vec3i)positionOffset);
        this.func_70107_b(newPosition.func_177958_n(), newPosition.func_177956_o(), newPosition.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeLong(this.field_174861_a.func_177986_g());
        buffer.writeByte(this.field_174860_b.func_176736_b());
    }

    public void readSpawnData(ByteBuf buf) {
        this.type = AttractionSignType.values()[buf.readByte()];
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        this.func_174859_a(EnumFacing.func_176731_b((int)buf.readByte()));
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        int width = this.func_82329_d() / 16;
        int height = this.func_82330_g() / 16;
        EnumFacing facing = this.field_174860_b.func_176735_f();
        BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()).func_177967_a(facing, -(width / 2) + 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                BlockPos partPos = pos.func_177967_a(facing, x).func_177979_c(y);
                IBlockState state = this.field_70170_p.func_180495_p(partPos);
                if (state.isSideSolid((IBlockAccess)this.field_70170_p, partPos, this.field_174860_b) && state.func_185904_a().func_76220_a()) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_ATTRACTION_SIGN).isEmpty();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double x = (double)this.field_174861_a.func_177958_n() + 0.5;
            double y = (double)this.field_174861_a.func_177956_o() + 0.5;
            double z = (double)this.field_174861_a.func_177952_p() + 0.5;
            double offsetXZ = this.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
            double offsetY = this.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
            x -= (double)this.field_174860_b.func_82601_c() * 0.46875;
            z -= (double)this.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing facing = this.field_174860_b.func_176735_f();
            this.field_70165_t = x += offsetXZ * (double)facing.func_82601_c();
            this.field_70163_u = y += offsetY;
            this.field_70161_v = z += offsetXZ * (double)facing.func_82599_e();
            double sizeX = this.func_82329_d();
            double sizeY = this.func_82330_g();
            double sizeZ = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                sizeZ = 1.0;
            } else {
                sizeX = 1.0;
            }
            this.func_174826_a(new AxisAlignedBB(x - (sizeX /= 32.0), y, z - (sizeZ /= 32.0), x + sizeX, y - (sizeY /= 16.0), z + sizeZ));
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)ItemHandler.ATTRACTION_SIGN, 1, this.type.ordinal());
    }

    public static enum AttractionSignType {
        AQUARIUM,
        AQUARIUM_CORAL,
        AVIARY,
        AVIARY_PLANTS,
        GALLIMIMUS_VALLEY,
        GALLIMIMUS_VALLEY_PLANTS,
        GENTLE_GIANTS,
        GENTLE_GIANTS_PLANTS,
        RAPTOR_PADDOCK,
        RAPTOR_PADDOCK_PLANTS,
        SAFARI,
        SAFARI_PLANTS,
        TRICERATOPS_TERRITORIUM,
        GARDEN,
        GARDEN_PLANTS,
        TRICERATOPS_TERRITORIUM_PLANTS,
        TYRANNOSAURUS_KINGDOM,
        TYRANNOSAURUS_KINGDOM_PLANTS,
        CENOZOIC_PARK,
        CENOZOIC_PARK_PLANTS,
        SMILODON_COVE,
        SMILODON_COVE_PLANTS,
        CARNIVORE_PADDOCK,
        CARNIVORE_PADDOCK_PLANTS,
        HERBIVORE_PADDOCK,
        HERBIVORE_PADDOCK_PLANTS,
        HYAENODON_LAIR,
        HYAENODON_LAIR_PLANTS,
        HYBRID_PADDOCK,
        HYBRID_PADDOCK_PLANTS,
        HYBRID_HILLS,
        HYBRID_HILLS_PLANTS,
        MAMMOTH_PLAINS,
        MAMMOTH_PLAINS_PLANTS,
        PREHISTORIC_LAKE,
        PREHISTORIC_LAKE_PLANTS,
        MOSA_FEEDING,
        TYLO_FEEDING,
        VISITOR_CENTER,
        VISITOR_CENTER_PLANTS,
        SPINO_SWAMP,
        SPINO_SWAMP_PLANTS,
        SAUROPOD_VALLEY,
        SAUROPOD_VALLEY_PLANTS,
        LOGO,
        LOGO_PLANTS,
        GIFT_SHOP,
        GIFT_SHOP_PLANTS,
        RESTAURANT,
        RESTAURANT_PLANTS,
        LABORATORY,
        LABORATORY_PLANTS,
        COELACANTH_POND_CORAL,
        COELACANTH_POND,
        PREHISTORIC_RIVER_PLANTS,
        PREHISTORIC_RIVER,
        GYROSPHERE_STATION,
        GYROSPHERE_STATION_PLANTS,
        MONORAIL_STATION,
        MONORAIL_STATION_PLANTS,
        MUSEUM,
        MUSEUM_PLANTS,
        SAFARI_TOUR,
        SAFARI_TOUR_PLANTS,
        INDORAPTOR,
        INDORAPTOR_VARIANT,
        INDOMINUS_REX,
        INDOMINUS_REX_VARIANT,
        GARDEN_ALT,
        GARDEN_ALT_PLANTS;

        public final int sizeX;
        public final int sizeY;
        public final ResourceLocation texture;
        public final ResourceLocation texturePopout;

        private AttractionSignType() {
            this(128, 128);
        }

        private AttractionSignType(int xSize, int ySize) {
            this.sizeX = xSize;
            this.sizeY = ySize;
            this.texture = new ResourceLocation("rebornmod", "textures/attraction_sign/" + this.name().toLowerCase(Locale.ENGLISH) + ".png");
            this.texturePopout = new ResourceLocation("rebornmod", "textures/attraction_sign/" + this.name().toLowerCase(Locale.ENGLISH) + "_popout.png");
        }
    }
}

