/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Locale;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlueprintEntity
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> IS_Blueprint = entity -> entity instanceof BlueprintEntity;
    public Type type;

    public BlueprintEntity(World world) {
        super(world);
    }

    public BlueprintEntity(World world, BlockPos pos, EnumFacing side) {
        super(world, pos);
        ArrayList possibleTypes = Lists.newArrayList();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            this.type = type = typeArray[i];
            this.func_174859_a(side);
            if (!this.func_70518_d()) continue;
            possibleTypes.add(type);
        }
        if (!possibleTypes.isEmpty()) {
            this.type = (Type)((Object)possibleTypes.get(this.field_70146_Z.nextInt(possibleTypes.size())));
        }
        this.func_174859_a(side);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("Type", (byte)this.type.ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.type = Type.values()[compound.func_74771_c("Type")];
        super.func_70037_a(compound);
    }

    public int func_82329_d() {
        return this.type.sizeX;
    }

    public int func_82330_g() {
        return this.type.sizeY;
    }

    public void func_110128_b(Entity entity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack((Item)ItemHandler.BLUEPRINT), 0.0f);
        }
    }

    public void func_184523_o() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos positionOffset = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos newPosition = this.field_174861_a.func_177971_a((Vec3i)positionOffset);
        this.func_70107_b(newPosition.func_177958_n(), newPosition.func_177956_o(), newPosition.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeLong(this.field_174861_a.func_177986_g());
        buffer.writeByte(this.field_174860_b.func_176736_b());
    }

    public void readSpawnData(ByteBuf buf) {
        this.type = Type.values()[buf.readByte()];
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        this.func_174859_a(EnumFacing.func_176731_b((int)buf.readByte()));
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        int width = this.func_82329_d() / 16;
        int height = this.func_82330_g() / 16;
        EnumFacing facing = this.field_174860_b.func_176735_f();
        BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()).func_177967_a(facing, -(width / 2) + 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                BlockPos partPos = pos.func_177967_a(facing, x).func_177979_c(y);
                IBlockState state = this.field_70170_p.func_180495_p(partPos);
                if (state.isSideSolid((IBlockAccess)this.field_70170_p, partPos, this.field_174860_b) && state.func_185904_a().func_76220_a()) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_Blueprint).isEmpty();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double x = (double)this.field_174861_a.func_177958_n() + 0.5;
            double y = (double)this.field_174861_a.func_177956_o() + 0.5;
            double z = (double)this.field_174861_a.func_177952_p() + 0.5;
            double offsetXZ = this.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
            double offsetY = this.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
            x -= (double)this.field_174860_b.func_82601_c() * 0.46875;
            z -= (double)this.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing facing = this.field_174860_b.func_176735_f();
            this.field_70165_t = x += offsetXZ * (double)facing.func_82601_c();
            this.field_70163_u = y += offsetY;
            this.field_70161_v = z += offsetXZ * (double)facing.func_82599_e();
            double sizeX = this.func_82329_d();
            double sizeY = this.func_82330_g();
            double sizeZ = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                sizeZ = 1.0;
            } else {
                sizeX = 1.0;
            }
            this.func_174826_a(new AxisAlignedBB(x - (sizeX /= 32.0), y, z - (sizeZ /= 32.0), x + sizeX, y - (sizeY /= 16.0), z + sizeZ));
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)ItemHandler.BLUEPRINT, 1, this.type.ordinal());
    }

    public static enum Type {
        TYRANNOSAURUS(1920, 1200),
        ANKYLODOCUS(1074, 671),
        ANKYLOSAURUS(1074, 671),
        APATOSAURUS(1074, 671),
        ARSINOITHERIUM(1206, 676),
        BARYONYX(1082, 676),
        BRACHIOSAURUS(1082, 676),
        CAMARASAURUS(1074, 671),
        CARCHARODONTOSAURUS(1206, 676),
        CARNOTAURUS(1082, 676),
        CERATOSAURUS(1074, 671),
        CHASMOSAURUS(1074, 671),
        COMPSOGNATHUS(1205, 676),
        DEINOTHERIUM(1206, 676),
        DIMETRODON(1074, 671),
        DIPLODOCUS(1074, 671),
        DREADNOUGHTUS(1074, 671),
        ELASMOTHERIUM(1196, 676),
        HERRERASAURUS(1920, 1200),
        INDORAPTOR(1074, 671),
        LEPTICTIDIUM(1201, 676),
        MAMENCHISAURUS(1080, 607),
        MEGATHERIUM(1074, 671),
        MOSASAURUS(1071, 676),
        OVIRAPTOR(1082, 676),
        PARASAUROLOPHUS(1395, 783),
        QUETZALCOATLUS(1074, 671),
        RAPHUSREX(1074, 671),
        RUGOPS(1074, 671),
        SINOCERATOPS(1074, 671),
        SMILODON(1074, 671),
        SPINORAPTOR(1074, 671),
        SPINOSAURUS(1202, 676),
        STYRACOSAURUS(1074, 671),
        TITANIS(1074, 671),
        PERISPHINCTES(1074, 671),
        MICROCERATUS(1074, 671),
        PROTOCERATOPS(1074, 671),
        TITANITES(1074, 671),
        PARAPUZOSIA(1074, 671),
        ASTEROCERAS(1074, 671),
        VECTIPELTA(1074, 671),
        TRICERATOPS(1074, 671),
        PARACERATHERIUM(1074, 671);

        public final int sizeX;
        public final int sizeY;
        public final ResourceLocation texture = new ResourceLocation("rebornmod", "textures/blueprints/" + this.name().toLowerCase(Locale.ENGLISH) + ".png");

        private Type(int xSize, int ySize) {
            this.sizeX = 96;
            this.sizeY = 64;
        }
    }
}

