/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.item;

import io.netty.buffer.ByteBuf;
import mod.reborn.RebornMod;
import mod.reborn.server.damage.DamageSources;
import mod.reborn.server.item.Bullet;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BulletEntity
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private ItemStack stack;
    private int damage = 5;

    public BulletEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.2f, 0.2f);
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public BulletEntity(World worldIn, EntityLivingBase throwerIn, ItemStack stack) {
        super(worldIn, throwerIn);
        this.stack = stack.func_77946_l();
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        super.func_70071_h_();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.CRIT.func_179348_c(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && (this.stack != null || result.field_72308_g instanceof EntityPlayer && result.field_72308_g != this.field_70192_c)) {
            Item item = this.stack.func_77973_b();
            if (result.field_72308_g instanceof EntityLiving) {
                if (item instanceof Bullet) {
                    result.field_72308_g.func_70097_a(DamageSources.BULLET, (float)this.damage);
                } else {
                    RebornMod.getLogger().error("Expected Bullet Item, got {} ", (Object)item.getRegistryName());
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void func_70030_z() {
        if (this.field_70173_aa > 50) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.stack != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.stack);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (this.stack != null) {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)additionalData);
        }
    }
}

