/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.item;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.ItemHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class DinosaurEggEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private DinosaurEntity entity;
    private UUID parent;
    private Dinosaur dinosaur;
    private int hatchTime;

    public DinosaurEggEntity(World world, DinosaurEntity entity, DinosaurEntity parent) {
        this(world);
        this.entity = entity;
        this.dinosaur = entity.getDinosaur();
        this.parent = parent.func_110124_au();
    }

    public DinosaurEggEntity(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.5f);
        this.hatchTime = this.random(5000, 6000);
    }

    public void func_70071_h_() {
        Optional<Entity> parentEntity;
        super.func_70071_h_();
        if (this.dinosaur == null && (parentEntity = this.field_70170_p.field_72996_f.stream().filter(entity -> entity.func_110124_au().equals(this.parent)).findFirst()).isPresent() && parentEntity.get() instanceof DinosaurEntity) {
            this.dinosaur = ((DinosaurEntity)parentEntity.get()).getDinosaur();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.entity == null) {
                this.func_70106_y();
            }
            --this.hatchTime;
            if (this.hatchTime <= 0) {
                this.hatch();
            }
            if (!this.field_70122_E) {
                this.field_70181_x -= 0.035;
            }
            this.field_70159_w *= 0.85;
            this.field_70181_x *= 0.85;
            this.field_70179_y *= 0.85;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    public void func_70088_a() {
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.entity != null && !this.field_70170_p.field_72995_K) {
            ItemStack eggStack = new ItemStack((Item)ItemHandler.EGG, 1, EntityHandler.getDinosaurId(this.entity.getDinosaur()));
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("DNAQuality", this.entity.getDNAQuality());
            nbt.func_74778_a("Genetics", this.entity.getGenetics());
            eggStack.func_77982_d(nbt);
            this.func_70099_a(eggStack, 0.1f);
            this.func_70106_y();
        }
        return true;
    }

    public void hatch() {
        if (this.dinosaur != null && this.entity != null) {
            try {
                this.entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.entity);
                this.entity.func_70642_aH();
                this.func_70106_y();
                for (Entity loadedEntity : this.field_70170_p.field_72996_f) {
                    if (!(loadedEntity instanceof DinosaurEntity) || !loadedEntity.func_110124_au().equals(this.parent)) continue;
                    DinosaurEntity parent = (DinosaurEntity)loadedEntity;
                    if (parent.family != null && this.dinosaur.shouldDefendOffspring()) {
                        parent.family.addChild(this.entity.func_110124_au());
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int random(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.hatchTime = compound.func_74762_e("HatchTime");
        NBTTagCompound entityTag = compound.func_74775_l("Hatchling");
        this.entity = (DinosaurEntity)EntityList.func_75615_a((NBTTagCompound)entityTag, (World)this.field_70170_p);
        this.parent = compound.func_186857_a("Parent");
        this.dinosaur = EntityHandler.getDinosaurById(compound.func_74762_e("DinosaurID"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("HatchTime", this.hatchTime);
        if (this.entity != null) {
            compound.func_74782_a("Hatchling", (NBTBase)this.entity.serializeNBT());
        }
        compound.func_186854_a("Parent", this.parent);
        compound.func_74768_a("DinosaurID", EntityHandler.getDinosaurId(this.dinosaur));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(EntityHandler.getDinosaurId(this.entity != null ? this.entity.getDinosaur() : EntityHandler.getDinosaurById(0)));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dinosaur = EntityHandler.getDinosaurById(additionalData.readInt());
    }

    @Nullable
    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }
}

