/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import mod.reborn.RebornMod;
import mod.reborn.server.block.TourRailBlock;
import mod.reborn.server.entity.ai.util.InterpValue;
import mod.reborn.server.entity.ai.util.MathUtils;
import mod.reborn.server.entity.vehicle.VehicleEntity;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.message.FordExplorerSnowChangeStateMessage;
import mod.reborn.server.message.FordExplorerSnowUpdatePositionStateMessage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FordExplorerSnowEntity
extends VehicleEntity {
    public static final BlockPos INACTIVE = new BlockPos(-1, -1, -1);
    public boolean prevOnRails;
    public boolean onRails;
    private BlockPos prevRailTracks = INACTIVE;
    public BlockPos prevPos = INACTIVE;
    public BlockPos railTracks = INACTIVE;
    private boolean lastDirBackwards;
    public final MinecartLogic minecart = new MinecartLogic();
    private final InterpValue rotationYawInterp = new InterpValue(this, 4.0);

    public FordExplorerSnowEntity(World world) {
        super(world);
        this.speedModifier = 0.0f;
    }

    @Override
    public void dropItems() {
        this.func_70099_a(new ItemStack((Item)ItemHandler.VEHICLE_ITEM, 1, 3), 0.0f);
    }

    @Override
    protected VehicleEntity.Seat[] createSeats() {
        VehicleEntity.Seat frontLeft = new VehicleEntity.Seat(this, 0.563f, 0.45f, 0.4f, 0.5f, 0.25f);
        VehicleEntity.Seat frontRight = new VehicleEntity.Seat(this, -0.563f, 0.45f, 0.4f, 0.5f, 0.25f);
        VehicleEntity.Seat backLeft = new VehicleEntity.Seat(this, 0.563f, 0.45f, -1.0f, 0.5f, 0.25f);
        VehicleEntity.Seat backRight = new VehicleEntity.Seat(this, -0.563f, 0.45f, -1.0f, 0.5f, 0.25f);
        return new VehicleEntity.Seat[]{frontLeft, frontRight, backLeft, backRight};
    }

    @Override
    protected boolean shouldStopUpdates() {
        return this.onRails;
    }

    @Override
    public void func_70071_h_() {
        BlockPos startPos = this.func_180425_c();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos rail = this.func_180425_c();
            boolean isRails = this.field_70170_p.func_180495_p(rail).func_177230_c() instanceof TourRailBlock;
            if (!isRails) {
                rail = rail.func_177977_b();
                isRails = this.field_70170_p.func_180495_p(rail).func_177230_c() instanceof TourRailBlock;
            }
            if (!isRails && this.field_70170_p.func_180495_p(rail.func_177977_b()).func_177230_c() instanceof TourRailBlock && Arrays.asList(TourRailBlock.EnumRailDirection.ASCENDING_EAST, TourRailBlock.EnumRailDirection.ASCENDING_NORTH, TourRailBlock.EnumRailDirection.ASCENDING_SOUTH, TourRailBlock.EnumRailDirection.ASCENDING_WEST).contains((Object)TourRailBlock.getRailDirection((IBlockAccess)this.field_70170_p, rail.func_177977_b()))) {
                rail = rail.func_177979_c(1);
                isRails = this.field_70170_p.func_180495_p(rail).func_177230_c() instanceof TourRailBlock;
            }
            if (this.onRails != isRails) {
                if (isRails) {
                    this.minecart.isInReverse = this.lastDirBackwards;
                }
                this.onRails = isRails;
                RebornMod.NETWORK_WRAPPER.sendToDimension((IMessage)new FordExplorerSnowChangeStateMessage(this), this.field_70170_p.field_73011_w.getDimension());
            }
            BlockPos blockPos = this.railTracks = isRails ? rail : INACTIVE;
            if (!this.railTracks.equals((Object)this.prevRailTracks)) {
                RebornMod.NETWORK_WRAPPER.sendToDimension((IMessage)new FordExplorerSnowUpdatePositionStateMessage(this, rail), this.field_70170_p.field_73011_w.getDimension());
            }
            this.prevRailTracks = this.railTracks;
        }
        if (this.onRails) {
            this.func_70105_a(0.75f, 0.25f);
        } else {
            this.func_70105_a(3.0f, 2.5f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        super.func_70071_h_();
        if (this.onRails) {
            this.minecart.onUpdate();
            Vector4d vec = this.wheeldata.carVector;
            this.backValue.setTarget(this.calculateWheelHeight(vec.y, false));
            this.frontValue.setTarget(this.calculateWheelHeight(vec.w, false));
            this.leftValue.setTarget(this.field_70163_u);
            this.rightValue.setTarget(this.field_70163_u);
        }
        this.prevOnRails = this.onRails;
        if (!startPos.equals((Object)this.func_180425_c())) {
            this.prevPos = this.func_180425_c();
        }
    }

    protected void func_145775_I() {
        if (!this.onRails) {
            super.func_145775_I();
        }
    }

    @Override
    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        for (int i = 0; i < this.seats.length; ++i) {
            if (!passenger.equals((Object)this.getEntityInSeat(i))) continue;
            passenger.field_70145_X = false;
            break;
        }
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.onRails) {
            if (this.func_184186_bw()) {
                if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                    this.setControlState((byte)0);
                }
                if (this.field_70170_p.field_72995_K) {
                    this.handleControl();
                }
            }
        } else {
            this.rotationYawInterp.reset((double)this.field_70177_z - 180.0);
        }
        if (this.forward()) {
            this.lastDirBackwards = false;
        } else if (this.backward()) {
            this.lastDirBackwards = true;
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("OnRails", this.onRails);
        compound.func_74772_a("BlockPosition", this.railTracks.func_177986_g());
        compound.func_74772_a("PrevBlockPosition", this.prevPos.func_177986_g());
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.onRails = compound.func_74767_n("OnRails");
        this.railTracks = BlockPos.func_177969_a((long)compound.func_74763_f("BlockPosition"));
        this.prevPos = BlockPos.func_177969_a((long)compound.func_74763_f("PrevBlockPosition"));
    }

    @Override
    public float getSoundVolume() {
        return this.onRails ? (this.func_184179_bs() != null ? this.getSpeed().modifier / 2.0f : 0.0f) : super.getSoundVolume();
    }

    @Nonnull
    public EnumFacing func_184172_bi() {
        return this.onRails ? this.minecart.getAdjustedHorizontalFacing() : super.func_184172_bi();
    }

    @Override
    protected VehicleEntity.WheelData createWheels() {
        return new VehicleEntity.WheelData(this, 1.0, 2.0, -1.0, -2.2);
    }

    @Override
    protected boolean shouldTyresRender() {
        return super.shouldTyresRender() && !this.onRails;
    }

    @Override
    public Vector2d getBackWheelRotationPoint() {
        Vector2d point = super.getBackWheelRotationPoint();
        return new Vector2d(point.x, this.onRails ? 0.0 : point.y);
    }

    public float func_70111_Y() {
        return 2.25f;
    }

    static /* synthetic */ int access$700(FordExplorerSnowEntity x0) {
        return x0.field_82153_h;
    }

    public class MinecartLogic {
        private boolean isInReverse;
        private boolean prevKeyDown;
        private double adjustedRotationYaw;

        public EnumFacing getAdjustedHorizontalFacing() {
            return this.isInReverse ? FordExplorerSnowEntity.this.func_174811_aO().func_176734_d().func_176746_e() : FordExplorerSnowEntity.this.func_174811_aO().func_176746_e();
        }

        public void onUpdate() {
            FordExplorerSnowEntity.this.rotationDelta *= 0.8f;
            FordExplorerSnowEntity.this.allWheels.forEach(FordExplorerSnowEntity.this::processWheel);
            for (int i = 0; i < 4; ++i) {
                ArrayList markedRemoved = Lists.newArrayList();
                FordExplorerSnowEntity.this.wheelDataList[i].forEach(wheel -> wheel.onUpdate(markedRemoved));
                markedRemoved.forEach(FordExplorerSnowEntity.this.wheelDataList[i]::remove);
            }
            if (FordExplorerSnowEntity.this.field_70163_u < -64.0) {
                FordExplorerSnowEntity.this.func_70076_C();
            }
            MinecraftServer minecraftserver = FordExplorerSnowEntity.this.field_70170_p.func_73046_m();
            if (!FordExplorerSnowEntity.this.field_70170_p.field_72995_K && FordExplorerSnowEntity.this.field_70170_p instanceof WorldServer && minecraftserver != null) {
                FordExplorerSnowEntity.this.field_70170_p.field_72984_F.func_76320_a("portal");
                int i = FordExplorerSnowEntity.this.func_82145_z();
                if (FordExplorerSnowEntity.this.field_71087_bX) {
                    if (minecraftserver.func_71255_r()) {
                        if (!FordExplorerSnowEntity.this.func_184218_aH() && FordExplorerSnowEntity.this.field_82153_h++ >= i) {
                            FordExplorerSnowEntity.this.field_82153_h = i;
                            FordExplorerSnowEntity.this.field_71088_bW = FordExplorerSnowEntity.this.func_82147_ab();
                            int j = FordExplorerSnowEntity.this.field_70170_p.field_73011_w.func_186058_p().func_186068_a() == -1 ? 0 : -1;
                            FordExplorerSnowEntity.this.func_184204_a(j);
                        }
                        FordExplorerSnowEntity.this.field_71087_bX = false;
                    }
                } else {
                    if (FordExplorerSnowEntity.this.field_82153_h > 0) {
                        FordExplorerSnowEntity.this.field_82153_h = FordExplorerSnowEntity.this.field_82153_h - 4;
                    }
                    if (FordExplorerSnowEntity.this.field_82153_h < 0) {
                        FordExplorerSnowEntity.this.field_82153_h = 0;
                    }
                }
                if (FordExplorerSnowEntity.this.field_71088_bW > 0) {
                    --FordExplorerSnowEntity.this.field_71088_bW;
                }
                FordExplorerSnowEntity.this.field_70170_p.field_72984_F.func_76319_b();
            }
            if (!FordExplorerSnowEntity.this.func_189652_ae()) {
                FordExplorerSnowEntity.this.field_70181_x -= (double)0.04f;
            }
            if (FordExplorerSnowEntity.this.railTracks.equals((Object)INACTIVE)) {
                return;
            }
            if (FordExplorerSnowEntity.this.func_184188_bt().isEmpty()) {
                return;
            }
            this.moveAlongTrack();
            if (!FordExplorerSnowEntity.this.field_70170_p.field_72995_K) {
                FordExplorerSnowEntity.this.func_145775_I();
                FordExplorerSnowEntity.this.field_70125_A = 0.0f;
                FordExplorerSnowEntity.this.func_70072_I();
            }
        }

        protected void moveAlongTrack() {
            double d15;
            double d10;
            double d22;
            double d5;
            FordExplorerSnowEntity.this.field_70143_R = 0.0f;
            Vec3d vec3d = this.getPos();
            FordExplorerSnowEntity.this.field_70163_u = FordExplorerSnowEntity.this.railTracks.func_177956_o();
            double slopeAdjustment = 0.0078125;
            TourRailBlock.EnumRailDirection dir = TourRailBlock.getRailDirection((IBlockAccess)FordExplorerSnowEntity.this.field_70170_p, FordExplorerSnowEntity.this.railTracks);
            EnumFacing facing = this.getFacingDir();
            switch (dir) {
                case ASCENDING_EAST: {
                    FordExplorerSnowEntity.this.field_70159_w -= slopeAdjustment;
                    FordExplorerSnowEntity.this.field_70163_u += 1.0;
                    break;
                }
                case ASCENDING_WEST: {
                    FordExplorerSnowEntity.this.field_70159_w += slopeAdjustment;
                    FordExplorerSnowEntity.this.field_70163_u += 1.0;
                    break;
                }
                case ASCENDING_NORTH: {
                    FordExplorerSnowEntity.this.field_70179_y += slopeAdjustment;
                    FordExplorerSnowEntity.this.field_70163_u += 1.0;
                    break;
                }
                case ASCENDING_SOUTH: {
                    FordExplorerSnowEntity.this.field_70179_y -= slopeAdjustment;
                    FordExplorerSnowEntity.this.field_70163_u += 1.0;
                }
            }
            double d1 = dir.getBackwardsX(facing) - dir.getForwardX(facing);
            double d2 = dir.getBackwardsZ(facing) - dir.getForwardZ(facing);
            double d3 = Math.sqrt(d1 * d1 + d2 * d2);
            double d4 = FordExplorerSnowEntity.this.field_70159_w * d1 + FordExplorerSnowEntity.this.field_70179_y * d2;
            if (d4 < 0.0) {
                d1 = -d1;
                d2 = -d2;
            }
            if ((d5 = Math.sqrt(FordExplorerSnowEntity.this.field_70159_w * FordExplorerSnowEntity.this.field_70159_w + FordExplorerSnowEntity.this.field_70179_y * FordExplorerSnowEntity.this.field_70179_y)) > 2.0) {
                d5 = 2.0;
            }
            double d = 1.0;
            if (FordExplorerSnowEntity.this.forward()) {
                if (!this.prevKeyDown && this.isInReverse) {
                    d = -1.0;
                }
                this.isInReverse = false;
                this.prevKeyDown = true;
            } else if (FordExplorerSnowEntity.this.backward()) {
                if (!this.prevKeyDown && !this.isInReverse) {
                    d = -1.0;
                }
                this.isInReverse = true;
                this.prevKeyDown = true;
            } else {
                this.prevKeyDown = false;
            }
            if (!FordExplorerSnowEntity.this.field_70170_p.field_72995_K) {
                d5 *= d;
            }
            FordExplorerSnowEntity.this.field_70159_w = d5 * d1 / d3;
            FordExplorerSnowEntity.this.field_70179_y = d5 * d2 / d3;
            Vec3d vec = FordExplorerSnowEntity.this.func_174791_d();
            Vec3d dirVec = new Vec3d(-d1, 0.0, d2).func_178787_e(vec);
            double target = MathUtils.cosineFromPoints(vec.func_72441_c(0.0, 0.0, 1.0), dirVec, vec);
            if (dirVec.field_72450_a < vec.field_72450_a) {
                target = -target;
            }
            this.adjustedRotationYaw = target;
            if (this.isInReverse) {
                target += 180.0;
            }
            do {
                d22 = Math.abs(FordExplorerSnowEntity.this.rotationYawInterp.getCurrent() - target);
                double d23 = Math.abs(FordExplorerSnowEntity.this.rotationYawInterp.getCurrent() - (target + 360.0));
                double d24 = Math.abs(FordExplorerSnowEntity.this.rotationYawInterp.getCurrent() - (target - 360.0));
                if (d23 < d22) {
                    target += 360.0;
                    continue;
                }
                if (!(d24 < d22)) continue;
                target -= 360.0;
            } while (d22 > 180.0);
            target = (double)Math.round(target * 100.0) / 100.0;
            FordExplorerSnowEntity.this.rotationYawInterp.setSpeed(this.getSpeedType().modifier * 4.0f);
            if (!FordExplorerSnowEntity.this.prevOnRails) {
                FordExplorerSnowEntity.this.rotationYawInterp.reset(target);
            } else if (d != -1.0) {
                FordExplorerSnowEntity.this.rotationYawInterp.setTarget(target);
            }
            FordExplorerSnowEntity.this.func_70101_b((float)FordExplorerSnowEntity.this.rotationYawInterp.getCurrent(), FordExplorerSnowEntity.this.field_70125_A);
            double d18 = (double)FordExplorerSnowEntity.this.railTracks.func_177958_n() + 0.5 + (double)dir.getForwardX(facing) * 0.5;
            double d19 = (double)FordExplorerSnowEntity.this.railTracks.func_177952_p() + 0.5 + (double)dir.getForwardZ(facing) * 0.5;
            double d20 = (double)FordExplorerSnowEntity.this.railTracks.func_177958_n() + 0.5 + (double)dir.getBackwardsX(facing) * 0.5;
            double d21 = (double)FordExplorerSnowEntity.this.railTracks.func_177952_p() + 0.5 + (double)dir.getBackwardsZ(facing) * 0.5;
            d1 = d20 - d18;
            d2 = d21 - d19;
            if (d1 == 0.0) {
                FordExplorerSnowEntity.this.field_70165_t = (double)FordExplorerSnowEntity.this.railTracks.func_177958_n() + 0.5;
                d10 = FordExplorerSnowEntity.this.field_70161_v - (double)FordExplorerSnowEntity.this.railTracks.func_177952_p();
            } else if (d2 == 0.0) {
                FordExplorerSnowEntity.this.field_70161_v = (double)FordExplorerSnowEntity.this.railTracks.func_177952_p() + 0.5;
                d10 = FordExplorerSnowEntity.this.field_70165_t - (double)FordExplorerSnowEntity.this.railTracks.func_177958_n();
            } else {
                double d11 = FordExplorerSnowEntity.this.field_70165_t - d18;
                double d12 = FordExplorerSnowEntity.this.field_70161_v - d19;
                d10 = (d11 * d1 + d12 * d2) * 2.0;
            }
            FordExplorerSnowEntity.this.field_70165_t = d18 + d1 * d10;
            FordExplorerSnowEntity.this.field_70161_v = d19 + d2 * d10;
            FordExplorerSnowEntity.this.func_70107_b(FordExplorerSnowEntity.this.field_70165_t, FordExplorerSnowEntity.this.field_70163_u, FordExplorerSnowEntity.this.field_70161_v);
            this.moveMinecartOnRail();
            double drag = FordExplorerSnowEntity.this.func_184207_aI() ? 0.9 : 0.75;
            FordExplorerSnowEntity.this.field_70159_w *= drag;
            FordExplorerSnowEntity.this.field_70179_y *= drag;
            Vec3d vec3d1 = this.getPos();
            if (vec3d1 != null && vec3d != null) {
                double d14 = (vec3d.field_72448_b - vec3d1.field_72448_b) * 0.05;
                d5 = Math.sqrt(FordExplorerSnowEntity.this.field_70159_w * FordExplorerSnowEntity.this.field_70159_w + FordExplorerSnowEntity.this.field_70179_y * FordExplorerSnowEntity.this.field_70179_y);
                if (d5 > 0.0) {
                    FordExplorerSnowEntity.this.field_70159_w = FordExplorerSnowEntity.this.field_70159_w / d5 * (d5 + d14);
                    FordExplorerSnowEntity.this.field_70179_y = FordExplorerSnowEntity.this.field_70179_y / d5 * (d5 + d14);
                }
            }
            int j = MathHelper.func_76128_c((double)FordExplorerSnowEntity.this.field_70165_t);
            int i = MathHelper.func_76128_c((double)FordExplorerSnowEntity.this.field_70161_v);
            if (j != FordExplorerSnowEntity.this.railTracks.func_177958_n() || i != FordExplorerSnowEntity.this.railTracks.func_177952_p()) {
                d5 = Math.sqrt(FordExplorerSnowEntity.this.field_70159_w * FordExplorerSnowEntity.this.field_70159_w + FordExplorerSnowEntity.this.field_70179_y * FordExplorerSnowEntity.this.field_70179_y);
                FordExplorerSnowEntity.this.field_70159_w = d5 * (double)(j - FordExplorerSnowEntity.this.railTracks.func_177958_n());
                FordExplorerSnowEntity.this.field_70179_y = d5 * (double)(i - FordExplorerSnowEntity.this.railTracks.func_177952_p());
            }
            if ((d15 = Math.sqrt(FordExplorerSnowEntity.this.field_70159_w * FordExplorerSnowEntity.this.field_70159_w + FordExplorerSnowEntity.this.field_70179_y * FordExplorerSnowEntity.this.field_70179_y)) == 0.0) {
                d15 = 1.0;
            }
            double d16 = 0.06;
            FordExplorerSnowEntity.this.field_70159_w += FordExplorerSnowEntity.this.field_70159_w / d15 * d16;
            FordExplorerSnowEntity.this.field_70179_y += FordExplorerSnowEntity.this.field_70179_y / d15 * d16;
        }

        private Vec3d getPos() {
            double x = FordExplorerSnowEntity.this.field_70165_t;
            double y = FordExplorerSnowEntity.this.field_70163_u;
            double z = FordExplorerSnowEntity.this.field_70161_v;
            IBlockState iblockstate = FordExplorerSnowEntity.this.field_70170_p.func_180495_p(new BlockPos((Vec3i)FordExplorerSnowEntity.this.railTracks));
            if (iblockstate.func_177230_c() instanceof TourRailBlock) {
                double d9;
                TourRailBlock.EnumRailDirection dir = TourRailBlock.getRailDirection((IBlockAccess)FordExplorerSnowEntity.this.field_70170_p, FordExplorerSnowEntity.this.railTracks);
                EnumFacing facing = this.getFacingDir();
                double d0 = x + 0.5 + (double)dir.getForwardX(facing) * 0.5;
                double d1 = y + 0.0625 + (double)dir.getForwardY(facing) * 0.5;
                double d2 = z + 0.5 + (double)dir.getForwardZ(facing) * 0.5;
                double d3 = x + 0.5 + (double)dir.getBackwardsX(facing) * 0.5;
                double d4 = y + 0.0625 + (double)dir.getBackwardsY(facing) * 0.5;
                double d5 = z + 0.5 + (double)dir.getBackwardsZ(facing) * 0.5;
                double d6 = d3 - d0;
                double d7 = (d4 - d1) * 2.0;
                double d8 = d5 - d2;
                if (d6 == 0.0) {
                    d9 = z - z;
                } else if (d8 == 0.0) {
                    d9 = x - x;
                } else {
                    double d10 = x - d0;
                    double d11 = z - d2;
                    d9 = (d10 * d6 + d11 * d8) * 2.0;
                }
                x = d0 + d6 * d9;
                y = d1 + d7 * d9;
                z = d2 + d8 * d9;
                if (d7 < 0.0) {
                    y += 1.0;
                }
                if (d7 > 0.0) {
                    y += 0.5;
                }
                return new Vec3d(x, y, z);
            }
            return null;
        }

        private void moveMinecartOnRail() {
            double mX = FordExplorerSnowEntity.this.field_70159_w;
            double mZ = FordExplorerSnowEntity.this.field_70179_y;
            if (mX == 0.0 && mZ == 0.0 && !FordExplorerSnowEntity.this.func_184188_bt().isEmpty()) {
                mX = FordExplorerSnowEntity.this.func_70676_i((float)1.0f).field_72450_a;
                mZ = FordExplorerSnowEntity.this.func_70676_i((float)1.0f).field_72449_c;
            }
            double max = this.getSpeedType().modifier / 8.0f;
            mX = MathHelper.func_151237_a((double)mX, (double)(-max), (double)max);
            mZ = MathHelper.func_151237_a((double)mZ, (double)(-max), (double)max);
            FordExplorerSnowEntity.this.func_70091_d(MoverType.SELF, mX, 0.0, mZ);
        }

        private VehicleEntity.Speed getSpeedType() {
            return ((TourRailBlock)FordExplorerSnowEntity.this.field_70170_p.func_180495_p(FordExplorerSnowEntity.this.railTracks).func_177230_c()).getSpeedType().getSpeed(FordExplorerSnowEntity.this.getSpeed());
        }

        private EnumFacing getFacingDir() {
            EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)(this.adjustedRotationYaw * 4.0 / 360.0 + 0.5)) & 3));
            if (this.isInReverse) {
                facing = facing.func_176734_d();
            }
            return facing;
        }
    }
}

