/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.vehicle;

import java.util.List;
import javax.annotation.Nonnull;
import mod.reborn.client.particle.HelicopterEngineParticle;
import mod.reborn.client.particle.HelicopterGroundParticle;
import mod.reborn.client.particle.WashingParticle;
import mod.reborn.client.proxy.ClientProxy;
import mod.reborn.client.render.RenderingHandler;
import mod.reborn.server.entity.ai.util.InterpValue;
import mod.reborn.server.entity.vehicle.VehicleEntity;
import mod.reborn.server.event.KeyBindingHandler;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.util.MutableVec3;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class HelicopterEntity
extends VehicleEntity {
    private static final byte UPWARD = 16;
    private static final byte DOWNWARD = 32;
    private int rotationControl = 0;
    public float gearLift;
    public boolean shouldGearLift = true;
    private final InterpValue rotationYawInterp = new InterpValue(this, 4.0);
    public boolean isFlying;
    public final InterpValue interpRotationPitch = new InterpValue(this, 0.25);
    public final InterpValue interpRotationRoll = new InterpValue(this, 0.25);
    protected MutableVec3 direction;
    private final int MAX_MOVEMENT_ROTATION = 15;
    private boolean shouldFallDamage;
    public double rotAmount = 0.0;
    private Vec3d prevInAirPos;
    private float damageAmount;
    private BlockPos.MutableBlockPos mb = new BlockPos.MutableBlockPos();
    protected boolean lockOn;
    protected int blastHeight = 6;
    private float currentEngineSpeed = 0.0f;
    protected float torque;
    protected float yawRoationAcceleration = 0.0f;
    private float shakingDirection = 0.0f;
    protected ResourceLocation warnignSoundResource;
    private int warningDelay = 0;
    protected final int enginePower;
    protected final int engineSpeed;
    protected final int rotorLength;
    protected final int weight;
    private final float physicalWidth;
    protected final float physicalHeight;
    private final float physicalDepth;
    protected final float qualityGrade = 0.75f;
    protected boolean simpleControle;

    public HelicopterEntity(World worldIn, float widthIn, float heightIn, float depthIn, int enginePowerIn, int engineSpeedIn, int weightIn, int rotorLengthIn) {
        super(worldIn);
        this.physicalWidth = widthIn;
        this.physicalHeight = heightIn;
        this.physicalDepth = depthIn;
        this.func_174826_a(new AxisAlignedBB(0.0, 0.0, 0.0, (double)this.physicalWidth, (double)this.physicalHeight, (double)this.physicalDepth));
        this.func_70105_a(this.physicalDepth, this.physicalHeight);
        this.enginePower = (int)((float)enginePowerIn * 735.5f);
        this.engineSpeed = engineSpeedIn;
        this.weight = weightIn;
        this.rotorLength = rotorLengthIn;
        this.torque = this.computeTorque();
        this.speedModifier = 1.5f;
        this.isFlying = false;
        this.direction = new MutableVec3(0.0, 1.0, 0.0);
        this.simpleControle = true;
        this.lockOn = true;
        this.warnignSoundResource = new ResourceLocation("rebornmod", "helicopter_warning");
    }

    public boolean upward() {
        return this.getStateBit((byte)16);
    }

    public boolean downward() {
        return this.getStateBit((byte)32);
    }

    @Override
    public void startSound() {
        ClientProxy.playHelicopterSound(this);
    }

    public void upward(boolean upward) {
        this.setStateBit((byte)16, upward);
    }

    public void downward(boolean downward) {
        this.setStateBit((byte)32, downward);
    }

    @Override
    protected boolean shouldStopUpdates() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_145775_I() {
        super.func_145775_I();
    }

    public boolean isController(EntityPlayer e) {
        return !this.getIfExists(0, false).equals("") && this.getIfExists(0, false).equals(Integer.toString(e.func_145782_y()));
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af() && player.func_184187_bx() != this) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handleControl() {
        if (this.isController((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (this.func_70090_H()) {
                this.upward(false);
                this.downward(false);
            } else {
                this.upward(KeyBindingHandler.HELICOPTER_UP.func_151470_d());
                this.downward(KeyBindingHandler.HELICOPTER_DOWN.func_151470_d());
                this.handleKeyEnableAutoPilot(KeyBindingHandler.HELICOPTER_AUTOPILOT.func_151468_f());
                this.handleKeyLock(KeyBindingHandler.HELICOPTER_LOCK.func_151468_f());
                this.rotateLeft(KeyBindingHandler.HELICOPTER_ROTATE_LEFT.func_151470_d());
                this.rotateRight(KeyBindingHandler.HELICOPTER_ROTATE_RIGHT.func_151470_d());
            }
            super.handleControl();
        }
        if (this.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g)) {
            this.increaseThirdPersonViewDistance(KeyBindingHandler.HELICOPTER_THIRD_PERSON_VIEW_ZOOM_OUT.func_151470_d());
            this.decreaseThirdPersonViewDistance(KeyBindingHandler.HELICOPTER_THIRD_PERSON_VIEW_ZOOM_IN.func_151470_d());
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        float tmp;
        float damage;
        if (!this.field_70170_p.field_72995_K && !this.isFlying && (damage = (float)MathHelper.func_76123_f((float)((distance - 3.0f) * damageMultiplier))) > 0.0f) {
            this.setHealth(this.getHealth() - damage * 1.25f);
            if (this.getHealth() <= 0.0f) {
                this.func_70106_y();
                if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.dropItems();
                }
            }
        }
        if (this.field_70170_p.field_72995_K && !this.isFlying && (damage = (float)MathHelper.func_76123_f((float)((distance - 3.0f) * damageMultiplier))) > 0.0f && (tmp = this.getHealth() - damage * 1.25f) <= 0.0f) {
            this.playHelicopterExplosion();
        }
    }

    @Override
    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        for (int i = 0; i < this.seats.length; ++i) {
            if (!passenger.equals((Object)this.getEntityInSeat(i))) continue;
            passenger.field_70145_X = false;
            break;
        }
        if (this.field_70170_p.field_72995_K) {
            this.resetThirdPersonViewDistance();
        }
    }

    @Override
    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = this.func_189652_ae();
        }
        super.func_70030_z();
        if (!this.func_70090_H()) {
            float dist = this.getDistanceToGround();
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < this.seats.length; ++i) {
                    Entity e = this.getEntityInSeat(i);
                    if (e == null) continue;
                    e.field_70143_R = 0.0f;
                }
            }
            if (this.forward() && this.isFlying) {
                this.pitch += this.computeThrottleUpDown() / 2.0f;
            } else if (this.backward() && this.isFlying) {
                this.pitch -= this.computeThrottleUpDown() / 2.0f;
            } else if (this.simpleControle && this.isFlying && this.lockOn && !this.isLowHealth()) {
                if (Math.abs(this.pitch) > 0.0f && Math.abs(this.pitch) < 1.0f) {
                    this.pitch = 0.0f;
                } else if (this.pitch < 0.0f) {
                    this.pitch += this.computeThrottleUpDown() / 2.0f;
                } else if (this.pitch > 0.0f) {
                    this.pitch -= this.computeThrottleUpDown() / 2.0f;
                }
            }
            if (this.left() && !this.right() && this.isFlying) {
                this.roll += this.computeThrottleUpDown();
            } else if (this.right() && !this.left() && this.isFlying) {
                this.roll -= this.computeThrottleUpDown();
            } else if (this.simpleControle && this.isFlying && this.lockOn && !this.isLowHealth()) {
                if (Math.abs(this.roll) > 0.0f && Math.abs(this.roll) < 1.0f) {
                    this.roll = 0.0f;
                } else if (this.roll < 0.0f) {
                    this.roll += this.computeThrottleUpDown();
                } else if (this.roll > 0.0f) {
                    this.roll -= this.computeThrottleUpDown();
                }
            }
            if (this.rotateLeft() && !this.left() && !this.right() && this.isFlying && dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
                this.yawRoationAcceleration -= 0.1f;
            } else if (this.rotateRight() && !this.left() && !this.right() && this.isFlying && dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
                this.yawRoationAcceleration += 0.1f;
            } else if (this.simpleControle && this.yawRoationAcceleration != 0.0f && dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
                this.yawRoationAcceleration += this.yawRoationAcceleration < 0.0f ? 0.05f : -0.05f;
            }
            if (this.pitch > 180.0f) {
                this.pitch = -180.0f + (this.pitch - 180.0f);
            } else if (this.pitch < -180.0f) {
                this.pitch += 360.0f;
            }
            if (this.pitch > this.computeMaxMovementRotation(dist)) {
                this.pitch -= this.computeThrottleUpDown() / 2.0f;
            } else if (this.pitch < -this.computeMaxMovementRotation(dist)) {
                this.pitch += this.computeThrottleUpDown() / 2.0f;
            }
            if (this.roll >= this.computeMaxMovementRotation(dist)) {
                this.roll = this.computeMaxMovementRotation(dist);
            } else if (this.roll <= -this.computeMaxMovementRotation(dist)) {
                this.roll = -this.computeMaxMovementRotation(dist);
            }
            if (this.yawRoationAcceleration > this.computeThrottleUpDown() * 2.0f && !this.isLowHealth()) {
                this.yawRoationAcceleration = this.computeThrottleUpDown() * 2.0f;
            } else if (this.yawRoationAcceleration < -this.computeThrottleUpDown() * 2.0f && !this.isLowHealth()) {
                this.yawRoationAcceleration = -this.computeThrottleUpDown() * 2.0f;
            } else if ((double)dist <= 0.1 && this.yawRoationAcceleration != 0.0f) {
                this.yawRoationAcceleration = 0.0f;
            }
            this.updateHelicopterCrash(dist);
            this.field_70177_z += this.yawRoationAcceleration;
            float requiredSpeedForHovering = this.computeRequiredEngineSpeedForHover();
            if ((this.shouldAdjustEngineSpeedByHorizontalControls(requiredSpeedForHovering) || this.shouldAdjustEngineSpeedWithoutHorizontalControls(requiredSpeedForHovering)) && this.simpleControle && this.isFlying && this.func_184179_bs() != null && Math.abs(this.getCurrentEngineSpeed() - requiredSpeedForHovering) <= 8.0f && !this.isLowHealth()) {
                if (Math.abs(this.getCurrentEngineSpeed() - requiredSpeedForHovering) <= 2.0f) {
                    this.setCurrentEngineSpeed(requiredSpeedForHovering);
                } else if (this.getCurrentEngineSpeed() > requiredSpeedForHovering) {
                    this.changeCurrentEngineSpeed(this.computeRequiredEngineSpeedForHover() - this.getCurrentEngineSpeed());
                } else if (this.getCurrentEngineSpeed() < requiredSpeedForHovering) {
                    this.changeCurrentEngineSpeed(this.computeRequiredEngineSpeedForHover() - this.getCurrentEngineSpeed());
                }
            }
            this.rotationYawInterp.reset((double)this.field_70177_z - 180.0);
            this.interpRotationPitch.setTarget(this.direction.zCoord * -30.0);
            this.interpRotationRoll.setTarget(this.direction.xCoord * 20.0);
            if (this.func_184179_bs() != null && !this.isLowHealth()) {
                if (this.upward()) {
                    this.changeCurrentEngineSpeed(this.computeThrottleUpDown());
                    this.setFlying();
                } else if (this.downward() && this.isFlying) {
                    this.shouldFallDamage = false;
                    this.changeCurrentEngineSpeed(-this.computeThrottleUpDown());
                } else if (!this.isFlying) {
                    this.func_189654_d(false);
                    for (int i = 0; i < this.seats.length; ++i) {
                        Entity e = this.getEntityInSeat(i);
                        if (e == null) continue;
                        e.func_189654_d(false);
                    }
                    if (this.simpleControle && this.getCurrentEngineSpeed() > 0.0f) {
                        this.changeCurrentEngineSpeed(-1.0f);
                    }
                } else if (this.simpleControle) {
                    if (Math.abs(this.getCurrentEngineSpeed() - requiredSpeedForHovering) <= 2.0f) {
                        this.setCurrentEngineSpeed(requiredSpeedForHovering);
                    } else if (this.getCurrentEngineSpeed() > requiredSpeedForHovering) {
                        this.changeCurrentEngineSpeed(-1.5f);
                    } else if (this.getCurrentEngineSpeed() < requiredSpeedForHovering) {
                        this.changeCurrentEngineSpeed(1.5f);
                    }
                }
                this.updateHelicopterTakeoffShaking(dist);
            } else if (this.getCurrentEngineSpeed() > 0.0f) {
                this.changeCurrentEngineSpeed(-1.0f);
            }
            if (this.field_70122_E) {
                this.isFlying = false;
                if (this.pitch > 30.0f || this.pitch < -30.0f || this.roll > 30.0f || this.roll < -30.0f || (double)this.yawRoationAcceleration > 0.2 || (double)this.yawRoationAcceleration < -0.2) {
                    this.setHealth(-3.0f);
                    this.func_70106_y();
                    if (this.field_70170_p.field_72995_K) {
                        this.playHelicopterExplosion();
                    }
                }
                this.lockOn = true;
                this.pitch = 0.0f;
            }
            if (this.field_70170_p.field_72995_K) {
                this.gearLift = !this.shouldGearLift ? (this.gearLift += 0.02f) : (this.gearLift -= 0.02f);
                this.shouldGearLift = !(dist < 10.0f);
            }
            if (this.func_184179_bs() == null) {
                this.func_189654_d(false);
            }
            if (this.field_70122_E && this.shouldFallDamage) {
                this.damageAmount = (float)this.prevInAirPos.field_72448_b - (float)this.func_174791_d().field_72448_b;
                this.setHealth(this.getHealth() - (float)Math.floor(this.damageAmount / 3.0f));
                this.shouldFallDamage = false;
            }
            if (this.field_70170_p.field_72995_K) {
                if (this.gearLift < -0.5f) {
                    this.gearLift = -0.5f;
                }
                if (this.gearLift > 0.0f) {
                    this.gearLift = 0.0f;
                }
            }
            this.rotAmount += (double)this.getCurrentEngineSpeed() * 0.00666666666 / 2.0;
            if (this.getCurrentEngineSpeed() >= 1.0f && !this.isRotorAreaFree()) {
                this.setHealth(this.getHealth() - this.getCurrentEngineSpeed() / (float)this.engineSpeed * 2.0f);
                if (this.getHealth() < 0.0f && this.field_70170_p.field_72995_K) {
                    this.playHelicopterExplosion();
                }
            }
        } else {
            this.func_189654_d(false);
            this.wheelRotateAmount = 0.0f;
            this.setCurrentEngineSpeed(this.getCurrentEngineSpeed() / 8.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnHoveringParticle();
            this.spawnEngineRunningParticle();
            this.spawnCrashingParticle();
            this.playWarningsound();
        }
        this.blastItems();
    }

    @Override
    protected void applyMovement() {
        float moveAmount = 0.0f;
        float surfaceFront = this.physicalWidth * this.physicalHeight;
        float surfaceTop = this.physicalWidth * this.physicalDepth;
        float horizontalSpeed = (float)Math.abs(Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70179_y, 2.0)) * 20.0);
        float verticalSpeed = (float)Math.abs(this.field_70181_x * 20.0);
        float flowResistanceFront = (float)((double)(2.0f * surfaceFront * 0.5f * 1.2f) * Math.pow(horizontalSpeed, 2.0));
        float flowResistanceTop = (float)((double)(2.0f * surfaceTop * 0.5f * 1.2f) * Math.pow(verticalSpeed, 2.0));
        moveAmount = (this.computeHorizontalForceFrontBack() - flowResistanceFront) / (float)this.weight / 20.0f;
        moveAmount *= Math.abs((this.roll <= 45.0f ? this.roll / 45.0f : 2.0f - this.roll / 45.0f) * 2.0f * (this.pitch <= 90.0f ? this.pitch / 90.0f : 2.0f - this.pitch / 90.0f));
        this.field_70181_x += ((double)((this.computeVerticalForce() - flowResistanceTop) / (float)this.weight) - 9.81) / 20.0;
        if (this.roll > 0.0f && this.roll < 90.0f && this.pitch != 0.0f) {
            this.rotationDelta -= 20.0f * moveAmount;
        } else if (this.roll < 0.0f && this.roll > -90.0f && this.pitch != 0.0f) {
            this.rotationDelta += 20.0f * moveAmount;
        }
        this.rotationDelta = MathHelper.func_76131_a((float)this.rotationDelta, (float)-3.0f, (float)3.0f);
        this.field_70177_z += this.rotationDelta;
        this.field_70179_y += Math.cos(this.field_70177_z * ((float)Math.PI / 180)) * (double)(this.computeHorizontalForceFrontBack() - flowResistanceFront) / (double)this.weight / 20.0;
        this.field_70179_y += Math.cos((this.field_70177_z - 90.0f) * ((float)Math.PI / 180)) * (double)(this.computeHorizontalForceLeftRight() - flowResistanceFront) / (double)this.weight / 20.0;
        this.field_70159_w += Math.sin(-this.field_70177_z * ((float)Math.PI / 180)) * (double)(this.computeHorizontalForceFrontBack() - flowResistanceFront) / (double)this.weight / 20.0;
        this.field_70159_w += Math.sin(-(this.field_70177_z - 90.0f) * ((float)Math.PI / 180)) * (double)(this.computeHorizontalForceLeftRight() - flowResistanceFront) / (double)this.weight / 20.0;
    }

    private void updateHelicopterCrash(float dist) {
        if (this.isLowHealth() && this.isFlying && dist > 1.5f) {
            this.yawRoationAcceleration = (float)((double)this.yawRoationAcceleration + Math.random() * (double)(this.getCurrentEngineSpeed() / (float)this.engineSpeed) * (double)0.9f);
            if (this.yawRoationAcceleration > 7.0f) {
                this.yawRoationAcceleration = 7.0f;
            }
            this.field_70159_w += Math.sin(Math.toRadians(this.field_70177_z)) * (double)0.05f;
            this.field_70179_y += Math.cos(Math.toRadians(this.field_70177_z)) * (double)0.05f;
            this.changeCurrentEngineSpeed(-1.0f);
            if ((double)this.pitch < Math.random() * 10.0 + 20.0 && this.pitch >= 0.0f) {
                this.pitch += 0.2f;
            } else if ((double)this.pitch > -(Math.random() * 10.0 + 20.0) && this.pitch < 0.0f) {
                this.pitch -= 0.2f;
            }
            if ((double)this.roll < Math.random() * 10.0 + 50.0 && this.roll >= 0.0f) {
                this.roll -= 1.0f;
            } else if ((double)this.roll > -(Math.random() * 10.0 + 50.0) && this.roll < 0.0f) {
                this.roll -= 1.0f;
            }
        }
    }

    protected boolean isLowHealth() {
        return this.getHealth() <= 2.0f;
    }

    private void updateHelicopterTakeoffShaking(float dist) {
    }

    protected void updateShakingRotation() {
        this.roll += this.shakingDirection;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public float getSoundVolume() {
        return this.getCurrentEngineSpeed() > 0.0f ? (Math.abs(this.getCurrentEngineSpeed() / 150.0f) + 0.001f) / (this.sound == null || this.sound.func_147667_k() ? 2.0f : 4.0f) : (Math.abs(this.wheelRotateAmount) + 0.001f) / (this.sound == null || this.sound.func_147667_k() ? 2.0f : 4.0f);
    }

    @Nonnull
    public EnumFacing func_184172_bi() {
        return super.func_184172_bi();
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            VehicleEntity.Seat seat = null;
            if (this.getSeatForEntity(passenger) != -1) {
                seat = this.seats[this.getSeatForEntity(passenger)];
            }
            Vec3d pos = seat == null ? new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.physicalHeight, this.field_70161_v) : seat.getPos();
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b + this.interpRotationPitch.getCurrent() / 75.0, pos.field_72449_c);
            passenger.field_70177_z += this.rotationDelta;
            passenger.func_70034_d(passenger.func_70079_am() + this.rotationDelta);
            if (passenger instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)passenger;
                living.field_70761_aq += (living.field_70177_z - living.field_70761_aq) * 0.6f;
            }
        }
    }

    private void playHelicopterExplosion() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1, 0.1, 0.1, new int[0]);
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    private float computeMaxMovementRotation(float dist) {
        return dist <= 3.0f ? dist / 3.0f * (float)(this.lockOn ? 15 : 90) : (this.lockOn ? 15.0f : 180.0f);
    }

    public float getDistanceToGround() {
        boolean found = false;
        float dist = -1.0f;
        this.mb.func_189533_g((Vec3i)this.func_180425_c());
        while (!found && this.field_70163_u >= 0.0 && this.mb.func_177956_o() >= 0) {
            if (this.field_70170_p.func_175623_d((BlockPos)this.mb)) {
                this.mb = this.mb.func_181079_c(this.mb.func_177958_n(), this.mb.func_177956_o() - 1, this.mb.func_177952_p());
                continue;
            }
            found = true;
            dist = (float)(this.field_70163_u - (double)this.mb.func_177956_o() - 1.0);
        }
        return dist;
    }

    protected IBlockState getGroundBlock() {
        boolean found = false;
        IBlockState groundBlock = null;
        this.mb.func_189533_g((Vec3i)this.func_180425_c());
        while (!found && this.field_70163_u >= 0.0 && this.mb.func_177956_o() >= 0) {
            if (this.field_70170_p.func_175623_d((BlockPos)this.mb)) {
                this.mb = this.mb.func_181079_c(this.mb.func_177958_n(), this.mb.func_177956_o() - 1, this.mb.func_177952_p());
                continue;
            }
            found = true;
            groundBlock = this.field_70170_p.func_180495_p((BlockPos)this.mb);
        }
        return groundBlock;
    }

    @Override
    protected void updateHeal() {
    }

    @SideOnly(value=Side.CLIENT)
    private void increaseThirdPersonViewDistance(boolean shouldIncrease) {
        if (shouldIncrease) {
            RenderingHandler.INSTANCE.setThirdPersonViewDistance(RenderingHandler.INSTANCE.getThirdPersonViewDistance() + 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void decreaseThirdPersonViewDistance(boolean shouldDecrease) {
        if (shouldDecrease) {
            RenderingHandler.INSTANCE.setThirdPersonViewDistance(RenderingHandler.INSTANCE.getThirdPersonViewDistance() - 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void resetThirdPersonViewDistance() {
        RenderingHandler.INSTANCE.resetThirdPersonViewDistance();
    }

    @Override
    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.playHelicopterExplosion();
        }
        super.func_70106_y();
    }

    public float func_70111_Y() {
        return 2.25f;
    }

    private boolean isRotorAreaFree() {
        boolean isFree = true;
        for (int x = -this.rotorLength; x < this.rotorLength && isFree; ++x) {
            for (int z = -this.rotorLength; z < this.rotorLength && isFree; ++z) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + (double)x, this.field_70163_u + (double)this.physicalHeight, this.field_70161_v + (double)z)).func_177230_c() instanceof BlockAir) continue;
                isFree = false;
            }
        }
        return isFree;
    }

    protected void setFlying() {
        this.isFlying = true;
        this.shouldFallDamage = true;
        this.prevInAirPos = this.func_174791_d();
        this.func_189654_d(true);
        for (int i = 0; i < this.seats.length; ++i) {
            Entity e = this.getEntityInSeat(i);
            if (e == null) continue;
            e.func_189654_d(false);
        }
    }

    public int getPositionLightFrequency() {
        return 30 - (int)(this.getCurrentEngineSpeed() / (float)this.engineSpeed * 20.0f);
    }

    protected void blastItems() {
        float dist = this.getDistanceToGround();
        if (dist >= 0.0f) {
            List items = this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - (double)(this.rotorLength * 2), this.field_70163_u - (double)dist - 1.0, this.field_70161_v - (double)(this.rotorLength * 2), this.field_70165_t + (double)(this.rotorLength * 2), this.field_70163_u + 1.0, this.field_70161_v + (double)(this.rotorLength * 2)));
            for (Entity item : items) {
                float itemDist = item.func_70032_d((Entity)this);
                if (!(itemDist <= (float)(this.rotorLength * 2)) || !(item.func_174813_aQ().func_72320_b() <= 0.55)) continue;
                float moveAmount = (float)((double)((1.0f - item.func_70032_d((Entity)this) / (float)(this.rotorLength * 2)) * (1.0f - dist / (float)this.blastHeight)) * (1.0 / Math.pow(this.engineSpeed, 3.0) * Math.pow(this.getCurrentEngineSpeed(), 3.0)));
                float x = (float)((item.field_70165_t - this.field_70165_t) / (double)itemDist);
                float z = (float)((item.field_70161_v - this.field_70161_v) / (double)itemDist);
                item.func_70024_g((double)(x * moveAmount), 0.0, (double)(z * moveAmount));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHoveringParticle() {
        float dist = this.getDistanceToGround();
        IBlockState groundBlock = this.getGroundBlock();
        if (dist <= (float)this.blastHeight && dist >= 0.0f) {
            for (int i = 0; i < 360; ++i) {
                double d = Math.random() * 100.0;
                float f = 1.0f - dist / (float)this.blastHeight;
                int n = groundBlock.func_177230_c().equals(Blocks.field_150355_j) ? 80 : 20;
                if (!(d < (double)(f * (float)n) * (1.0 / Math.pow(this.engineSpeed, 3.0) * Math.pow(this.getCurrentEngineSpeed(), 3.0) * 1.0))) continue;
                float x = (float)(Math.cos(Math.toRadians(i)) * (double)((float)this.rotorLength / 1.8f) * (Math.random() * 0.2 + 1.0));
                float y = (float)(this.field_70163_u - (double)dist);
                float z = (float)(Math.sin(Math.toRadians(i)) * (double)((float)this.rotorLength / 1.8f) * (Math.random() * 0.2 + 1.0));
                if (groundBlock.func_177230_c().equals(Blocks.field_150355_j)) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new WashingParticle(this.field_70170_p, this.field_70165_t + (double)x, y + 0.5f, this.field_70161_v + (double)z, x / 5.0f, 0.001f, z / 5.0f, 0));
                    continue;
                }
                if (groundBlock.func_185904_a().equals(Material.field_151587_i)) continue;
                if (this.isBlockDusty(groundBlock.func_177230_c())) {
                    double d2 = Math.random();
                    double d3 = this.field_70170_p.func_72896_J() ? 0.1 : 0.4;
                    if (d2 < d3) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + (double)x, (double)y + 0.1, this.field_70161_v + (double)z, (double)(x / 5.0f), (double)0.001f + Math.random() * (this.field_70170_p.func_72896_J() ? 0.0 : 0.5), (double)(z / 5.0f), new int[]{Block.func_176210_f((IBlockState)groundBlock)});
                    }
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new HelicopterGroundParticle(this.field_70170_p, this.field_70165_t + (double)x, y, this.field_70161_v + (double)z, x / 5.0f, 0.001f, z / 5.0f));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnEngineRunningParticle() {
        float[] offsetBack = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 3.0625f);
        float[] directionBack1 = this.computeEngineExhaustParticleDirection(15.0f);
        float[] directionBack2 = this.computeEngineExhaustParticleDirection(-15.0f);
        for (int i = 0; i < 5; ++i) {
            if (!(Math.random() < (double)(this.getCurrentEngineSpeed() / (float)this.engineSpeed))) continue;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new HelicopterEngineParticle(this.field_70170_p, this.field_70165_t + (double)offsetBack[0] + Math.random() * 0.3, this.field_70163_u + (double)offsetBack[2] + Math.random() * 0.3, this.field_70161_v - (double)offsetBack[4] + Math.random() * 0.3, directionBack1[0] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed), 0.001f, directionBack1[2] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed), 1.0f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new HelicopterEngineParticle(this.field_70170_p, this.field_70165_t + (double)offsetBack[1] + Math.random() * 0.3, this.field_70163_u + (double)offsetBack[3] + Math.random() * 0.3, this.field_70161_v - (double)offsetBack[5] + Math.random() * 0.3, directionBack2[0] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed), 0.001f, directionBack2[2] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed), 1.0f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnCrashingParticle() {
        if (Math.random() < (double)(-(this.getHealth() * 1.6f - 40.0f) / 40.0f)) {
            float[] offsetFront = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 0.9375f);
            float[] offsetBack = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 3.0625f);
            float[] directionFront1 = this.computeEngineFrontSmokeParticleDirection(-20.0f);
            float[] directionFront2 = this.computeEngineFrontSmokeParticleDirection(20.0f);
            float[] directionBack = this.computeEngineExhaustParticleDirection(0.0f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)offsetBack[0], this.field_70163_u + (double)offsetBack[2], this.field_70161_v - (double)offsetBack[4], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2], new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)offsetBack[1], this.field_70163_u + (double)offsetBack[3], this.field_70161_v - (double)offsetBack[5], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2], new int[0]);
            if (this.field_70171_ac && (double)this.field_70170_p.func_175726_f(this.func_180425_c()).func_177433_f(this.func_180425_c()) - this.field_70163_u > 2.0) {
                if (Math.random() < (double)(1.0f - (this.getHealth() * 2.0f - 40.0f) / 40.0f)) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (double)offsetBack[0], this.field_70163_u + (double)offsetBack[2], this.field_70161_v - (double)offsetBack[4], 0.0, 0.0, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (double)offsetBack[1], this.field_70163_u + (double)offsetBack[3], this.field_70161_v - (double)offsetBack[5], 0.0, 0.0, 0.0, new int[0]);
                }
                if (Math.random() < (double)(1.0f - this.getCurrentEngineSpeed() * 1.6f / (float)this.engineSpeed)) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)offsetFront[0], this.field_70163_u + (double)offsetFront[2], this.field_70161_v - (double)offsetFront[4], (double)directionFront1[0] * 0.5, (double)directionFront1[1] * 0.5, (double)directionFront1[2] * 0.5, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)offsetFront[1], this.field_70163_u + (double)offsetFront[3], this.field_70161_v - (double)offsetFront[5], (double)directionFront2[0] * 0.5, (double)directionFront2[1] * 0.5, (double)directionFront2[2] * 0.5, new int[0]);
                }
            } else {
                if (Math.random() < (double)(1.0f - (this.getHealth() * 2.0f - 40.0f) / 40.0f)) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)offsetBack[0], this.field_70163_u + (double)offsetBack[2], this.field_70161_v - (double)offsetBack[4], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2], new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)offsetBack[1], this.field_70163_u + (double)offsetBack[3], this.field_70161_v - (double)offsetBack[5], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2], new int[0]);
                }
                if (Math.random() < (double)(1.0f - this.getCurrentEngineSpeed() * 1.6f / (float)this.engineSpeed)) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)offsetFront[0], this.field_70163_u + (double)offsetFront[2], this.field_70161_v - (double)offsetFront[4], (double)directionFront1[0], (double)directionFront1[1], (double)directionFront1[2], new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)offsetFront[1], this.field_70163_u + (double)offsetFront[3], this.field_70161_v - (double)offsetFront[5], (double)directionFront2[0], (double)directionFront2[1], (double)directionFront2[2], new int[0]);
                }
            }
        }
    }

    protected float[] computeEngineOutletPosition(float xPos1, float xPos2, float yPos, float zPos) {
        float radiantRotationYaw = (float)Math.toRadians(this.field_70177_z);
        float radiantPitch = (float)Math.toRadians(this.pitch);
        float radiantRoll = (float)Math.toRadians(this.roll);
        float[] offsets = new float[6];
        float[] tmpOffsets = new float[6];
        offsets[2] = yPos;
        offsets[3] = yPos;
        offsets[4] = zPos;
        offsets[5] = zPos;
        offsets[0] = xPos1;
        offsets[1] = xPos2;
        offsets[2] = (float)(Math.cos(-radiantPitch) * (double)yPos - Math.sin(-radiantPitch) * (double)zPos);
        offsets[3] = (float)(Math.cos(-radiantPitch) * (double)yPos - Math.sin(-radiantPitch) * (double)zPos);
        offsets[4] = (float)(Math.sin(-radiantPitch) * (double)yPos + Math.cos(-radiantPitch) * (double)zPos);
        offsets[5] = (float)(Math.sin(-radiantPitch) * (double)yPos + Math.cos(-radiantPitch) * (double)zPos);
        tmpOffsets = (float[])offsets.clone();
        offsets[0] = (float)(Math.cos(-radiantRoll) * (double)tmpOffsets[0] - Math.sin(-radiantRoll) * (double)tmpOffsets[2]);
        offsets[1] = (float)(Math.cos(-radiantRoll) * (double)tmpOffsets[1] - Math.sin(-radiantRoll) * (double)tmpOffsets[3]);
        offsets[2] = (float)(Math.sin(-radiantRoll) * (double)tmpOffsets[0] + Math.cos(-radiantRoll) * (double)tmpOffsets[2]);
        offsets[3] = (float)(Math.sin(-radiantRoll) * (double)tmpOffsets[1] + Math.cos(-radiantRoll) * (double)tmpOffsets[3]);
        tmpOffsets = (float[])offsets.clone();
        offsets[0] = (float)(Math.cos(radiantRotationYaw) * (double)tmpOffsets[0] + Math.sin(radiantRotationYaw) * (double)tmpOffsets[4]);
        offsets[1] = (float)(Math.cos(radiantRotationYaw) * (double)tmpOffsets[1] + Math.sin(radiantRotationYaw) * (double)tmpOffsets[5]);
        offsets[4] = (float)(-Math.sin(radiantRotationYaw) * (double)tmpOffsets[0] + Math.cos(radiantRotationYaw) * (double)tmpOffsets[4]);
        offsets[5] = (float)(-Math.sin(radiantRotationYaw) * (double)tmpOffsets[1] + Math.cos(radiantRotationYaw) * (double)tmpOffsets[5]);
        return offsets;
    }

    protected float[] computeEngineExhaustParticleDirection(float rotOffset) {
        float[] directions = new float[3];
        float engineBlast = this.getCurrentEngineSpeed() / (float)this.engineSpeed * 0.2f;
        directions[0] = (float)(Math.sin(-Math.toRadians(this.field_70177_z + rotOffset)) * (double)(-0.05f - engineBlast) + (Math.random() - 0.5) * 0.1);
        directions[1] = 0.01f;
        directions[2] = (float)(Math.cos(Math.toRadians(this.field_70177_z + rotOffset)) * (double)(-0.05f - engineBlast) + (Math.random() - 0.5) * 0.1);
        return directions;
    }

    protected float[] computeEngineFrontSmokeParticleDirection(float rotOffset) {
        float[] directions = new float[3];
        float engineBlast = this.getCurrentEngineSpeed() / (float)this.engineSpeed * 0.2f;
        directions[0] = (float)(Math.sin(-Math.toRadians(this.field_70177_z + rotOffset)) * (double)(0.05f + engineBlast) + (Math.random() - 0.5) * 0.1);
        directions[1] = 0.0f;
        directions[2] = (float)(Math.cos(Math.toRadians(this.field_70177_z + rotOffset)) * (double)(0.05f + engineBlast) + (Math.random() - 0.5) * 0.1);
        return directions;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playWarningsound() {
        if (this.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            if ((double)(this.getHealth() / 40.0f) < 0.3 && this.warningDelay <= 0) {
                this.field_70170_p.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_180425_c(), new SoundEvent(this.warnignSoundResource), SoundCategory.BLOCKS, 0.1f * (1.0f - this.getHealth() / 40.0f), 1.0f);
                this.warningDelay = 17;
            } else if ((double)(this.getHealth() / 40.0f) < 0.3) {
                --this.warningDelay;
            }
        }
    }

    private boolean shouldAdjustEngineSpeedByHorizontalControls(float requiredSpeedForHovering) {
        return !(!this.forward() && !this.backward() && !this.left() && !this.right() || this.getCurrentEngineSpeed() > requiredSpeedForHovering && this.upward() || this.getCurrentEngineSpeed() < requiredSpeedForHovering && this.downward());
    }

    private boolean shouldAdjustEngineSpeedWithoutHorizontalControls(float requiredSpeedForHovering) {
        return !(this.forward() || this.backward() || this.left() || this.right() || this.getCurrentEngineSpeed() > requiredSpeedForHovering && this.upward() || this.getCurrentEngineSpeed() < requiredSpeedForHovering && this.downward());
    }

    protected void handleKeyEnableAutoPilot(boolean shouldChange) {
        if (shouldChange) {
            this.simpleControle = !this.simpleControle;
        }
    }

    protected void handleKeyLock(boolean shouldChange) {
        if (shouldChange) {
            this.lockOn = !this.lockOn;
        }
    }

    private void rotateLeft(boolean keyPressed) {
        if (keyPressed) {
            this.rotationControl = 1;
        } else if (this.rotationControl == 1 && !this.rotateRight()) {
            this.rotationControl = 0;
        }
    }

    private void rotateRight(boolean keyPressed) {
        if (keyPressed) {
            this.rotationControl = !this.rotateLeft() ? 2 : 0;
        } else if (this.rotationControl == 2 && !this.rotateLeft()) {
            this.rotationControl = 0;
        }
    }

    protected boolean rotateLeft() {
        return this.rotationControl == 1;
    }

    protected boolean rotateRight() {
        return this.rotationControl == 2;
    }

    protected boolean isBlockDusty(Block block) {
        return block.equals(Blocks.field_150354_m) || block.equals(Blocks.field_150425_aM) || block.equals(Blocks.field_150351_n);
    }

    @Override
    public void dropItems() {
        this.func_70099_a(new ItemStack((Item)ItemHandler.VEHICLE_ITEM, 1, 2), 0.1f);
    }

    protected void changeCurrentEngineSpeed(float changeSpeed) {
        this.setCurrentEngineSpeed(this.getCurrentEngineSpeed() + changeSpeed);
    }

    protected void setCurrentEngineSpeed(float speed) {
        this.currentEngineSpeed = speed;
        if (this.currentEngineSpeed > (float)this.engineSpeed) {
            this.currentEngineSpeed = this.engineSpeed;
        } else if (this.currentEngineSpeed < 0.0f) {
            this.currentEngineSpeed = 0.0f;
        }
    }

    protected float computeRotorSweptArea() {
        return (float)(Math.PI * Math.pow(this.rotorLength, 2.0));
    }

    protected float computeShaftPower() {
        return (float)((double)(this.torque * this.getCurrentEngineSpeed()) * 0.10471975511965977);
    }

    protected float computeRotorForce() {
        return (float)Math.pow((double)(2.4f * this.computeRotorSweptArea()) * Math.pow(this.qualityGrade * this.computeShaftPower(), 2.0), 0.3333333333333333);
    }

    protected float computeVerticalForce() {
        return (1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * this.computeRotorForce();
    }

    protected float computeHorizontalForceFrontBack() {
        if (this.pitch <= 90.0f && this.pitch >= -90.0f) {
            return this.pitch / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * ((1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
        }
        if (this.pitch < 0.0f) {
            return (1.0f + (this.pitch + 90.0f) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * (Math.abs(this.pitch + 90.0f) / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
        }
        return (1.0f - (this.pitch - 90.0f) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * (Math.abs(this.pitch - 90.0f) / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
    }

    protected float computeHorizontalForceLeftRight() {
        return this.roll / 90.0f * (1.0f - this.pitch / 90.0f) * this.computeRotorForce();
    }

    public float getCurrentEngineSpeed() {
        return this.currentEngineSpeed;
    }

    protected float computeRequiredEngineSpeedForHover() {
        float S = 9.81f * (float)this.weight / ((1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f));
        return (float)((double)(1.0f / this.qualityGrade) * Math.sqrt(Math.pow(S, 3.0) / (double)(2.4f * this.computeRotorSweptArea())) / ((double)this.torque * 0.10471975511965977));
    }

    protected float computeThrottleUpDown() {
        return (float)this.enginePower / 735.5f * 2.9481133E-4f;
    }

    protected float computeTorque() {
        return (float)((double)this.enginePower / ((double)this.engineSpeed * 0.10471975511965977));
    }
}

