/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.vehicle;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import mod.reborn.RebornMod;
import mod.reborn.client.proxy.ClientProxy;
import mod.reborn.client.render.entity.TyretrackRenderer;
import mod.reborn.client.sound.EntitySound;
import mod.reborn.server.conf.RebornConfig;
import mod.reborn.server.damage.DamageSources;
import mod.reborn.server.entity.ai.util.InterpValue;
import mod.reborn.server.entity.vehicle.GyrosphereEntity;
import mod.reborn.server.entity.vehicle.MultiSeatedEntity;
import mod.reborn.server.entity.vehicle.util.CarWheel;
import mod.reborn.server.entity.vehicle.util.WheelParticleData;
import mod.reborn.server.message.CarEntityPlayRecord;
import mod.reborn.server.message.UpdateVehicleControlMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.omg.CORBA.DoubleHolder;

public abstract class VehicleEntity
extends Entity
implements MultiSeatedEntity {
    public static final DataParameter<Byte> WATCHER_STATE = EntityDataManager.func_187226_a(VehicleEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Float> WATCHER_HEALTH = EntityDataManager.func_187226_a(VehicleEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> WATCHER_SPEED = EntityDataManager.func_187226_a(VehicleEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<ItemStack> RECORD_ITEM = EntityDataManager.func_187226_a(VehicleEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<NBTTagCompound> WATCHER_SEATS = EntityDataManager.func_187226_a(VehicleEntity.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final float MAX_HEALTH = 40.0f;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte FORWARD = 4;
    private static final byte BACKWARD = 8;
    protected final Seat[] seats = this.createSeats();
    protected final WheelData wheeldata = this.createWheels();
    public float wheelRotation;
    public float wheelRotateAmount;
    public float prevWheelRotateAmount;
    public float pitch;
    public float roll;
    protected float rotationDelta;
    private boolean noiseInstance;
    public int interpProgress;
    double interpTargetX;
    public double interpTargetY;
    public double interpTargetZ;
    public double interpTargetYaw;
    public float speedModifier = 0.0f;
    private static final double INTERP_AMOUNT = 0.15;
    public boolean wasOnGroundLastTick;
    private Vec3d prevUnairbornPos;
    public final InterpValue backValue = new InterpValue(this, 0.15);
    public final InterpValue frontValue = new InterpValue(this, 0.15);
    public final InterpValue leftValue = new InterpValue(this, 0.15);
    public final InterpValue rightValue = new InterpValue(this, 0.15);
    public final CarWheel backLeftWheel;
    public final CarWheel backRightWheel;
    public final CarWheel frontLeftWheel;
    public final CarWheel frontRightWheel;
    public final List<WheelParticleData>[] wheelDataList;
    public List<CarWheel> allWheels;
    @SideOnly(value=Side.CLIENT)
    public EntitySound<VehicleEntity> sound;
    @SideOnly(value=Side.CLIENT)
    public InterpValue steerAmount;
    private float healAmount;
    private int healCooldown;
    private Vec3d previousPosition;
    private long prevWorldTime;
    public double estimatedSpeed;
    private byte prevState;

    public VehicleEntity(World world) {
        super(world);
        this.backLeftWheel = new CarWheel(0, this.wheeldata.bl);
        this.backRightWheel = new CarWheel(1, this.wheeldata.br);
        this.frontLeftWheel = new CarWheel(2, this.wheeldata.fl);
        this.frontRightWheel = new CarWheel(3, this.wheeldata.fr);
        this.wheelDataList = new List[4];
        this.allWheels = Lists.newArrayList((Object[])new CarWheel[]{this.backLeftWheel, this.frontLeftWheel, this.backRightWheel, this.frontRightWheel});
        this.healCooldown = 40;
        this.previousPosition = null;
        this.prevWorldTime = -1L;
        this.estimatedSpeed = 0.0;
        this.prevState = 0;
        this.func_70105_a(3.0f, 2.5f);
        this.field_70138_W = 1.5f;
        if (world.field_72995_K) {
            this.steerAmount = new InterpValue(this, 0.1);
        }
        for (int i = 0; i < 4; ++i) {
            this.wheelDataList[i] = Lists.newArrayList();
        }
        this.backLeftWheel.setPair(this.backRightWheel);
        this.frontLeftWheel.setPair(this.frontRightWheel);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(WATCHER_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WATCHER_HEALTH, (Object)Float.valueOf(40.0f));
        this.field_70180_af.func_187214_a(WATCHER_SPEED, (Object)1);
        this.field_70180_af.func_187214_a(RECORD_ITEM, (Object)ItemStack.field_190927_a);
        NBTTagCompound s = new NBTTagCompound();
        for (int i = 0; i < this.createSeats().length; ++i) {
            s.func_74778_a(this.str(i), "");
        }
        this.field_70180_af.func_187214_a(WATCHER_SEATS, (Object)s);
    }

    public boolean left() {
        return this.getStateBit((byte)1);
    }

    public boolean right() {
        return this.getStateBit((byte)2);
    }

    public boolean forward() {
        return this.getStateBit((byte)4);
    }

    public boolean backward() {
        return this.getStateBit((byte)8);
    }

    public void left(boolean left) {
        this.setStateBit((byte)1, left);
    }

    public void right(boolean right) {
        this.setStateBit((byte)2, right);
    }

    public void forward(boolean forward) {
        this.setStateBit((byte)4, forward);
    }

    public void backward(boolean backward) {
        this.setStateBit((byte)8, backward);
    }

    protected boolean getStateBit(byte mask) {
        return (this.getControlState() & mask) != 0;
    }

    protected void setStateBit(byte mask, boolean newState) {
        byte state = this.getControlState();
        this.setControlState((byte)(newState ? state | mask : state & ~mask));
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(WATCHER_STATE);
    }

    public byte getPreviousState() {
        return this.prevState;
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(WATCHER_STATE, (Object)state);
    }

    public void setPreviousState(byte state) {
        this.prevState = state;
    }

    public void setSpeed(Speed speed) {
        this.field_70180_af.func_187227_b(WATCHER_SPEED, (Object)speed.ordinal());
    }

    public Speed getSpeed() {
        return Speed.values()[(Integer)this.field_70180_af.func_187225_a(WATCHER_SPEED)];
    }

    public void setHealth(float health) {
        this.field_70180_af.func_187227_b(WATCHER_HEALTH, (Object)Float.valueOf(health));
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(WATCHER_HEALTH)).floatValue();
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(RECORD_ITEM);
    }

    public boolean func_70112_a(double dist) {
        return true;
    }

    protected boolean func_184219_q(@Nonnull Entity passenger) {
        return this.func_184188_bt().size() < this.seats.length;
    }

    public Entity func_184179_bs() {
        String id = this.getIfExists(0, false);
        return id.equals("") ? null : this.field_70170_p.func_73045_a(Integer.parseInt(id));
    }

    @Override
    @Nullable
    public Entity getEntityInSeat(int seatID) {
        String id = this.getIfExists(seatID, false);
        return id.equals("") ? null : this.field_70170_p.func_73045_a(Integer.parseInt(id));
    }

    public String getIfExists(int seatID, boolean reset) {
        String string = ((NBTTagCompound)this.field_70180_af.func_187225_a(WATCHER_SEATS)).func_74779_i(this.str(seatID));
        if (!string.equals("")) {
            if (this.field_70170_p.func_73045_a(Integer.parseInt(string)) == null || this.field_70170_p.func_73045_a(Integer.parseInt(string)).func_184187_bx() != this) {
                if (reset) {
                    this.setSeat(this.str(seatID), "");
                }
                return "";
            }
            return string;
        }
        return "";
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public Vector4d getCarDimensions() {
        return this.wheeldata.carVector;
    }

    public Vector2d getBackWheelRotationPoint() {
        return new Vector2d(-0.5, 1.4);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int duration, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpProgress = duration;
    }

    private void resetFlyTicks(@Nonnull EntityPlayerMP entity) {
        entity.field_70143_R = 0.0f;
        Field field = null;
        Field field2 = null;
        try {
            if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                field = NetHandlerPlayServer.class.getDeclaredField("vehicleFloatingTickCount");
                field2 = NetHandlerPlayServer.class.getDeclaredField("floatingTickCount");
            } else {
                field = NetHandlerPlayServer.class.getDeclaredField("field_184346_E");
                field2 = NetHandlerPlayServer.class.getDeclaredField("field_147365_f");
            }
            field.setAccessible(true);
            field.set(entity.field_71135_a, 0);
            field2.setAccessible(true);
            field2.set(entity.field_71135_a, 0);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float damage;
        if (!this.field_70170_p.field_72995_K && (damage = (float)MathHelper.func_76123_f((float)((distance - 3.0f) * damageMultiplier))) > 0.0f) {
            RebornMod.getLogger().debug("The vehicle at the coordinates " + this.func_180425_c() + " fell down! " + distance + "   " + damage);
            this.setHealth(this.getHealth() - damage * 1.25f);
            if (this.getHealth() < 0.0f) {
                this.func_70106_y();
                if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.dropItems();
                    ItemStack recordItem = (ItemStack)this.field_70180_af.func_187225_a(RECORD_ITEM);
                    if (!recordItem.func_190926_b()) {
                        this.func_70099_a(recordItem, 0.0f);
                    }
                }
            }
        }
    }

    public void func_70030_z() {
        Entity e;
        int i;
        if (!this.field_70170_p.field_72995_K && this.getHealth() < 0.0f && !this.field_70128_L) {
            this.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                this.dropItems();
                ItemStack recordItem = (ItemStack)this.field_70180_af.func_187225_a(RECORD_ITEM);
                if (!recordItem.func_190926_b()) {
                    this.func_70099_a(recordItem, 0.0f);
                }
            }
        }
        for (i = 0; i < this.seats.length; ++i) {
            e = this.getEntityInSeat(i);
            if (e == null || !(e instanceof EntityPlayerMP)) continue;
            this.resetFlyTicks((EntityPlayerMP)e);
        }
        if (this.getSpeed() == Speed.FAST) {
            this.allWheels.forEach(wheel -> this.createWheelParticles((CarWheel)wheel, true));
        }
        this.allWheels.forEach(this::createWheelParticles);
        if (this.shouldStopUpdates()) {
            super.func_70030_z();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.prevWorldTime != -1L) {
            this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g((double)0.1f), this::canRunoverEntity).forEach(this::runOverEntity);
        }
        if (this.func_70090_H()) {
            for (i = 0; i < this.seats.length; ++i) {
                e = this.getEntityInSeat(i);
                if (e == null) continue;
                e.func_70097_a(DamageSource.field_76369_e, 0.5f);
            }
            this.setHealth(this.getHealth() - 0.25f);
        }
        if (this.previousPosition == null) {
            this.previousPosition = this.func_174791_d();
        }
        this.estimatedSpeed = this.func_174791_d().func_72438_d(this.previousPosition) / (double)(this.field_70170_p.func_82737_E() - this.prevWorldTime);
        this.previousPosition = this.func_174791_d();
        this.prevWorldTime = this.field_70170_p.func_82737_E();
        for (i = 0; i < 4; ++i) {
            ArrayList markedRemoved = Lists.newArrayList();
            this.wheelDataList[i].forEach(wheel -> wheel.onUpdate(markedRemoved));
            markedRemoved.forEach(this.wheelDataList[i]::remove);
        }
        super.func_70030_z();
        this.allWheels.forEach(this::processWheel);
        Vector4d vec = this.wheeldata.carVector;
        this.backValue.setTarget(this.calculateWheelHeight(vec.y, false));
        this.frontValue.setTarget(this.calculateWheelHeight(vec.w, false));
        this.leftValue.setTarget(this.calculateWheelHeight(vec.z, true));
        this.rightValue.setTarget(this.calculateWheelHeight(vec.x, true));
        if (!this.field_70170_p.field_72995_K) {
            this.updateHeal();
        }
        this.tickInterp();
        this.updateMotion();
        if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
            this.setControlState((byte)0);
        }
        if (this.field_70170_p.field_72995_K) {
            this.handleControl();
        }
        this.applyMovement();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected void updateHeal() {
        if (this.healCooldown > 0) {
            --this.healCooldown;
        } else if (this.healAmount > 0.0f) {
            this.setHealth(this.getHealth() + 1.0f);
            this.healAmount -= 1.0f;
            if (this.getHealth() > 40.0f) {
                this.setHealth(40.0f);
                this.healAmount = 0.0f;
            }
        }
    }

    protected boolean canRunoverEntity(Entity entity) {
        return EntitySelectors.field_180132_d.apply((Object)entity) && !this.func_184188_bt().contains(entity);
    }

    protected void runOverEntity(Entity entity) {
        if (this.estimatedSpeed > 0.1) {
            entity.func_70097_a(DamageSources.CAR, (float)this.estimatedSpeed);
        }
    }

    protected void createWheelParticles(CarWheel wheel) {
        this.createWheelParticles(wheel, false);
    }

    protected void createWheelParticles(CarWheel wheel, boolean runBetween) {
        Vec3d opposite;
        Vec3d pos;
        if (runBetween) {
            Vec3d vec = wheel.getCurrentWheelPos();
            Vec3d oldVec = wheel.getCurrentWheelPos();
            Vec3d vec1 = wheel.getOppositeWheel().getCurrentWheelPos();
            Vec3d oldVec1 = wheel.getOppositeWheel().getCurrentWheelPos();
            pos = new Vec3d((vec.field_72450_a + oldVec.field_72450_a) / 2.0, (vec.field_72448_b + oldVec.field_72448_b) / 2.0, (vec.field_72449_c + oldVec.field_72449_c) / 2.0);
            opposite = new Vec3d((vec1.field_72450_a + oldVec1.field_72450_a) / 2.0, (vec1.field_72448_b + oldVec1.field_72448_b) / 2.0, (vec1.field_72449_c + oldVec1.field_72449_c) / 2.0);
        } else {
            pos = wheel.getCurrentWheelPos();
            opposite = wheel.getOppositeWheel().getCurrentWheelPos();
        }
        if (this instanceof GyrosphereEntity) {
            return;
        }
        if (wheel.getCurrentWheelPos().func_72438_d(wheel.getPrevCurrentWheelPos()) >= 0.05) {
            this.wheelDataList[wheel.getID()].add(new WheelParticleData(pos, opposite, this.field_70170_p.func_82737_E()).setShouldRender(this.shouldTyresRender()));
        }
    }

    protected void processWheel(CarWheel wheel) {
        float localYaw = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
        Vector2d relPos = wheel.getRelativeWheelPosition();
        double xRot = Math.sin(Math.toRadians(localYaw)) * relPos.y - Math.cos(Math.toRadians(localYaw)) * relPos.x;
        double zRot = -Math.cos(Math.toRadians(localYaw)) * relPos.y - Math.sin(Math.toRadians(localYaw)) * relPos.x;
        Vec3d vec = new Vec3d(this.field_70165_t + xRot, this.field_70163_u, this.field_70161_v + zRot);
        wheel.setCurrentWheelPos(vec);
    }

    protected boolean shouldTyresRender() {
        return this.getSpeed() != Speed.SLOW;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.noiseInstance) {
            this.noiseInstance = true;
            this.startSound();
        }
        if (this.shouldStopUpdates()) {
            return;
        }
        if (RebornConfig.VEHICLES.destroyBlocks) {
            AxisAlignedBB aabb = this.func_174813_aQ();
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos(Math.floor(aabb.field_72340_a), Math.floor(aabb.field_72338_b), Math.floor(aabb.field_72339_c)), (BlockPos)new BlockPos(Math.ceil(aabb.field_72336_d), Math.ceil(aabb.field_72337_e), Math.ceil(aabb.field_72334_f)))) {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_185904_a() == Material.field_151582_l) {
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                    } else {
                        state.func_177230_c().func_176226_b(this.field_70170_p, pos, state, 0);
                    }
                    this.field_70170_p.func_175698_g(pos);
                    continue;
                }
                if (state.func_185904_a() != Material.field_151584_j) continue;
                this.field_70170_p.func_175698_g(pos);
            }
        }
        this.prevWheelRotateAmount = this.wheelRotateAmount;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = Math.min(MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 4.0f, 1.0f);
        this.wheelRotateAmount += (delta - this.wheelRotateAmount) * 0.4f;
        this.wheelRotation += this.wheelRotateAmount;
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        this.func_145775_I();
    }

    private void updateMotion() {
        double resist = 0.8f;
        this.field_70159_w *= (double)0.8f;
        this.field_70181_x *= (double)0.8f;
        this.field_70179_y *= (double)0.8f;
        this.rotationDelta = (float)((double)this.rotationDelta * (double)0.8f);
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.15f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleControl() {
        Entity driver = this.func_184179_bs();
        if (!(driver instanceof EntityPlayer) || !((EntityPlayer)driver).func_175144_cb()) {
            return;
        }
        EntityPlayerSP player = (EntityPlayerSP)driver;
        MovementInput movementInput = player.field_71158_b;
        if (this.func_70090_H()) {
            this.setControlState((byte)0);
        } else {
            this.left(movementInput.field_187257_e);
            this.right(movementInput.field_187258_f);
            this.forward(movementInput.field_187255_c);
            this.backward(movementInput.field_187256_d);
        }
        if (this.getControlState() != this.getPreviousState()) {
            RebornMod.NETWORK_WRAPPER.sendToServer((IMessage)new UpdateVehicleControlMessage(this));
        }
        this.setPreviousState(this.getControlState());
    }

    protected void applyMovement() {
        Speed speed = this.getSpeed();
        float moveAmount = 0.0f;
        if ((this.left() || this.right()) && !this.forward() && !this.backward()) {
            moveAmount += 0.05f;
        }
        if (this.forward()) {
            moveAmount += 0.1f;
        } else if (this.backward()) {
            moveAmount -= 0.05f;
        }
        moveAmount *= speed.modifier + this.speedModifier;
        if (this.func_70090_H() && (moveAmount -= 0.1f) < 0.0f) {
            moveAmount = 0.0f;
        }
        if (this.left()) {
            this.rotationDelta -= 20.0f * moveAmount;
        } else if (this.right()) {
            this.rotationDelta += 20.0f * moveAmount;
        }
        this.rotationDelta = MathHelper.func_76131_a((float)this.rotationDelta, (float)-3.0f, (float)3.0f);
        this.field_70177_z += this.rotationDelta;
        this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * moveAmount);
        this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * moveAmount);
    }

    private void tickInterp() {
        if (this.interpProgress > 0 && !this.func_184186_bw()) {
            double interpolatedX = this.field_70165_t + (this.interpTargetX - this.field_70165_t) / (double)this.interpProgress;
            double interpolatedY = this.field_70163_u + (this.interpTargetY - this.field_70163_u) / (double)this.interpProgress;
            double interpolatedZ = this.field_70161_v + (this.interpTargetZ - this.field_70161_v) / (double)this.interpProgress;
            double deltaYaw = MathHelper.func_76138_g((double)(this.interpTargetYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw / (double)this.interpProgress);
            --this.interpProgress;
            this.func_70107_b(interpolatedX, interpolatedY, interpolatedZ);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    protected final double calculateWheelHeight(double distance, boolean rotate90) {
        float localYaw = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
        double ret = -2.147483648E9;
        Vector4d carVec = this.wheeldata.carVector;
        double sideLength = Math.abs(rotate90 ? carVec.x - carVec.z : carVec.z - carVec.w);
        for (double d = -sideLength; d <= sideLength; d += 0.25) {
            double xRot = Math.sin(Math.toRadians(localYaw)) * (rotate90 ? d : distance) - Math.cos(Math.toRadians(localYaw)) * (rotate90 ? distance : d);
            double zRot = -Math.cos(Math.toRadians(localYaw)) * (rotate90 ? d : distance) - Math.sin(Math.toRadians(localYaw)) * (rotate90 ? distance : d);
            Vec3d vec = new Vec3d(this.field_70165_t + xRot, this.field_70163_u, this.field_70161_v + zRot);
            BlockPos pos = new BlockPos(vec);
            boolean found = false;
            ArrayList aabbList = Lists.newArrayList();
            while (!found && pos.func_177956_o() >= 0) {
                aabbList.clear();
                this.field_70170_p.func_180495_p(pos).func_185908_a(this.field_70170_p, pos, new AxisAlignedBB(pos), (List)aabbList, (Entity)this, false);
                if (this.field_70170_p.func_175623_d(pos) || aabbList.isEmpty()) {
                    pos = pos.func_177977_b();
                    continue;
                }
                found = true;
            }
            if (!found) {
                ret = this.field_70163_u;
            }
            if (found && !this.field_70170_p.func_175623_d(pos.func_177984_a()) && !this.field_70170_p.func_175623_d(pos.func_177981_b(2))) {
                ArrayList list = Lists.newArrayList();
                this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185908_a(this.field_70170_p, pos.func_177984_a(), new AxisAlignedBB(pos.func_177984_a()), (List)list, (Entity)this, false);
                this.field_70170_p.func_180495_p(pos.func_177981_b(2)).func_185908_a(this.field_70170_p, pos.func_177981_b(2), new AxisAlignedBB(pos.func_177981_b(2)), (List)list, (Entity)this, false);
                if (!list.isEmpty()) {
                    ret = this.field_70163_u;
                }
            }
            if (aabbList.isEmpty()) {
                ret = pos.func_177956_o() + 1;
            }
            DoubleHolder holder = new DoubleHolder(-2.147483648E9);
            aabbList.forEach(aabb -> {
                holder.value = Math.max(aabb.field_72337_e, holder.value);
            });
            if (!(holder.value > ret)) continue;
            ret = holder.value;
        }
        return ret;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_184187_bx() == this) {
                ItemStack currentStack = (ItemStack)this.field_70180_af.func_187225_a(RECORD_ITEM);
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() instanceof ItemRecord || stack.func_190926_b()) {
                    this.field_70180_af.func_187227_b(RECORD_ITEM, (Object)stack);
                    player.func_184611_a(hand, currentStack);
                    if (!stack.func_190926_b()) {
                        RebornMod.NETWORK_WRAPPER.sendToAllTracking((IMessage)new CarEntityPlayRecord(this, stack), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0));
                    }
                }
            } else if (!player.func_70093_af()) {
                player.func_184220_m((Entity)this);
            }
        }
        return true;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (passenger instanceof EntityPlayerMP) {
            this.resetFlyTicks((EntityPlayerMP)passenger);
        }
        if (!passenger.field_70170_p.field_72995_K) {
            this.usherPassenger(passenger, 0);
        }
    }

    private void usherPassenger(Entity passenger, int start) {
        for (int i = start; i < this.seats.length; ++i) {
            if (!this.tryPutInSeat(passenger, i, false)) continue;
            return;
        }
    }

    private void setSeat(String seatID, String uuid) {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_179237_a((NBTTagCompound)this.field_70180_af.func_187225_a(WATCHER_SEATS));
        comp.func_74778_a(seatID, uuid);
        this.field_70180_af.func_187227_b(WATCHER_SEATS, (Object)comp);
        if (seatID.equals("0") && this.func_184179_bs() == null && this.getControlState() != 0) {
            this.setControlState((byte)0);
            if (this.field_70170_p.field_72995_K) {
                RebornMod.NETWORK_WRAPPER.sendToServer((IMessage)new UpdateVehicleControlMessage(this));
            }
        }
    }

    @Override
    public boolean tryPutInSeat(Entity passenger, int seatID, boolean isPacket) {
        int seatNumber;
        if (seatID < this.seats.length && seatID >= 0 && ((seatNumber = this.getSeatForEntity(passenger)) == 0 && seatID == 0 && !isPacket || this.getIfExists(seatID, false).equals(""))) {
            if (seatNumber != -1 && !passenger.field_70170_p.field_72995_K) {
                this.setSeat(this.str(seatNumber), "");
            }
            if (!passenger.field_70170_p.field_72995_K) {
                this.setSeat(this.str(seatID), this.str(passenger.func_145782_y()));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private String str(int input) {
        return Integer.toString(input);
    }

    @Override
    @Nullable
    public int getSeatForEntity(Entity entity) {
        for (int i = 0; i < this.seats.length; ++i) {
            if (!this.getIfExists(i, true).equals(this.str(entity.func_145782_y()))) continue;
            return i;
        }
        return -1;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (source.func_76346_g() instanceof EntityPlayer) {
                this.healAmount += (amount *= 10.0f);
                this.healCooldown = 40;
            }
            this.setHealth(this.getHealth() - amount);
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Seat seat = null;
            if (this.getSeatForEntity(passenger) != -1) {
                seat = this.seats[this.getSeatForEntity(passenger)];
            }
            Vec3d pos = seat == null ? new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v) : seat.getPos();
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            passenger.field_70177_z += this.rotationDelta;
            passenger.func_70034_d(passenger.func_70079_am() + this.rotationDelta);
            if (passenger instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)passenger;
                living.field_70761_aq += (living.field_70177_z - living.field_70761_aq) * 0.6f;
            }
        }
    }

    public Seat getSeat(int id) {
        if (id < this.seats.length) {
            return this.seats[id];
        }
        return null;
    }

    protected boolean shouldStopUpdates() {
        return false;
    }

    public void func_70106_y() {
        RebornMod.getLogger().debug("The vehicle at the coordinates " + this.func_180425_c() + " has been destroyed! " + this.getHealth() + " " + this.field_70159_w + " " + this.field_70181_x + " " + this.field_70179_y);
        super.func_70106_y();
        TyretrackRenderer.uploadList(this);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setHealth(compound.func_74760_g("Health"));
        this.healAmount = compound.func_74760_g("HealAmount");
        this.setSpeed(Speed.values()[compound.func_74762_e("Speed")]);
        NBTTagCompound tag = compound.func_74775_l("InterpValues");
        this.backValue.deserializeNBT(tag.func_74775_l("Back"));
        this.frontValue.deserializeNBT(tag.func_74775_l("Front"));
        this.leftValue.deserializeNBT(tag.func_74775_l("Left"));
        this.rightValue.deserializeNBT(tag.func_74775_l("Right"));
        this.field_70180_af.func_187227_b(RECORD_ITEM, (Object)new ItemStack(compound.func_74775_l("RecordItem")));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Health", this.getHealth());
        compound.func_74776_a("HealAmount", this.healAmount);
        compound.func_74768_a("Speed", this.getSpeed().ordinal());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Back", (NBTBase)this.backValue.serializeNBT());
        tag.func_74782_a("Front", (NBTBase)this.frontValue.serializeNBT());
        tag.func_74782_a("Left", (NBTBase)this.leftValue.serializeNBT());
        tag.func_74782_a("Right", (NBTBase)this.rightValue.serializeNBT());
        compound.func_74782_a("InterpValues", (NBTBase)tag);
        compound.func_74782_a("RecordItem", (NBTBase)((ItemStack)this.field_70180_af.func_187225_a(RECORD_ITEM)).serializeNBT());
    }

    public void startSound() {
        ClientProxy.playCarSound(this);
    }

    protected abstract Seat[] createSeats();

    protected abstract WheelData createWheels();

    public abstract void dropItems();

    public float getSoundVolume() {
        return (Math.abs(this.wheelRotateAmount) + 0.001f) / (this.sound == null || this.sound.func_147667_k() ? 2.0f : 4.0f);
    }

    public void doPlayerRotations(EntityPlayer player, float partialTicks) {
    }

    public static enum Speed {
        SLOW(0.5f),
        MEDIUM(1.0f),
        FAST(2.0f);

        public final float modifier;

        private Speed(float modifier) {
            this.modifier = modifier;
        }
    }

    protected final class WheelData {
        public final Vector2d bl;
        public final Vector2d br;
        public final Vector2d fl;
        public final Vector2d fr;
        public final Vector4d carVector;

        public WheelData(double backLeftX, double backLeftZ, double frontRightX, double frontRightZ) {
            this.bl = new Vector2d(backLeftX, backLeftZ);
            this.br = new Vector2d(frontRightX, backLeftZ);
            this.fl = new Vector2d(backLeftX, frontRightZ);
            this.fr = new Vector2d(frontRightX, frontRightZ);
            this.carVector = new Vector4d(backLeftX, backLeftZ, frontRightX, frontRightZ);
        }
    }

    public final class Seat {
        private final InterpValue interpValue;
        private float offsetX;
        private float offsetY;
        private float offsetZ;
        private final float radius;
        private final float height;

        public Seat(float offsetX, float offsetY, float offsetZ, float radius, float height) {
            this.interpValue = new InterpValue(VehicleEntity.this, 0.1);
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.radius = radius;
            this.height = height;
        }

        protected void so(float x, float y, float z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }

        public Vec3d getPos() {
            double theta = Math.toRadians(VehicleEntity.this.field_70177_z);
            double sideX = Math.cos(theta);
            double sideZ = Math.sin(theta);
            double forwardTheta = theta + 1.5707963267948966;
            double forwardX = Math.cos(forwardTheta);
            double forwardZ = Math.sin(forwardTheta);
            double x = VehicleEntity.this.field_70165_t + sideX * (double)this.offsetX + forwardX * (double)this.offsetZ;
            double y = VehicleEntity.this.field_70163_u + (double)this.offsetY;
            double z = VehicleEntity.this.field_70161_v + sideZ * (double)this.offsetX + forwardZ * (double)this.offsetZ;
            return new Vec3d(x, y, z);
        }

        public float getOffsetY() {
            return this.offsetY;
        }

        public float getOffsetZ() {
            return this.offsetZ;
        }

        public AxisAlignedBB getBounds() {
            Vec3d pos = this.getPos();
            double x = pos.field_72450_a;
            double y = pos.field_72448_b;
            double z = pos.field_72449_c;
            return new AxisAlignedBB(x - (double)this.radius, y, z - (double)this.radius, x + (double)this.radius, y + (double)this.offsetY + (double)this.height, z + (double)this.radius);
        }

        public InterpValue getInterpValue() {
            return this.interpValue;
        }
    }
}

