/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.entity.vehicle.util;

import java.util.List;
import net.minecraft.util.math.Vec3d;

public class WheelParticleData {
    private int age;
    private final Vec3d position;
    private final Vec3d oppositePosition;
    private final int maxAge = 200;
    private final long worldTime;
    private boolean shouldRender = true;

    public WheelParticleData(Vec3d position, Vec3d oppositePosition, long worldTime) {
        this.position = position;
        this.oppositePosition = oppositePosition;
        this.worldTime = worldTime;
    }

    public WheelParticleData setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
        return this;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public Vec3d getOppositePosition() {
        return this.oppositePosition;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public void onUpdate(List<WheelParticleData> markedRemoved) {
        if (this.age++ >= this.maxAge) {
            markedRemoved.add(this);
        }
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public float getAlpha(float partialTicks) {
        if (this.age > 199) {
            return 0.0f;
        }
        float f = (float)Math.pow(((double)this.age + (double)partialTicks) / (double)this.maxAge, 2.0);
        float f1 = 2.0f - f * 2.0f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        return f1 *= 0.3f;
    }
}

