/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.event;

import java.util.ArrayList;
import java.util.Random;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.FossilizedTrackwayBlock;
import mod.reborn.server.block.plant.DoublePlantBlock;
import mod.reborn.server.conf.RebornConfig;
import mod.reborn.server.datafixers.PlayerData;
import mod.reborn.server.entity.animal.EntityShark;
import mod.reborn.server.entity.vehicle.HelicopterEntity;
import mod.reborn.server.item.BugItem;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.util.GameRuleHandler;
import mod.reborn.server.world.WorldGenCoal;
import mod.reborn.server.world.loot.Loot;
import net.ilexiconn.llibrary.server.capability.EntityDataHandler;
import net.ilexiconn.llibrary.server.capability.IEntityData;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ServerEventHandler {
    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityDataHandler.INSTANCE.registerExtendedEntityData((Entity)((EntityPlayer)event.getEntity()), (IEntityData)new PlayerData());
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        GameRuleHandler.register(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void decorate(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        if (!this.dimCheck(world.field_73011_w.getDimension(), RebornConfig.DIM_BLACKLIST.dimBlacklist)) {
            IBlockState state;
            BlockPos topBlock;
            BlockPos pos = event.getPos();
            Random rand = event.getRand();
            Biome biome = world.func_180494_b(pos);
            BiomeDecorator decorator = biome.field_76760_I;
            if (RebornConfig.MINERAL_GENERATION.plantFossilGeneration && decorator != null && decorator.field_180293_d != null && !(decorator.field_76821_k instanceof WorldGenCoal)) {
                decorator.field_76821_k = new WorldGenCoal(Blocks.field_150365_q.func_176223_P(), decorator.field_180293_d.field_177844_ac);
            }
            if (RebornConfig.PLANT_GENERATION.mossGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0 && world.func_180495_p((topBlock = world.func_175672_r(pos)).func_177977_b()).func_185914_p() && !world.func_180495_p(topBlock).func_185904_a().func_76224_d()) {
                world.func_180501_a(topBlock, BlockHandler.MOSS.func_176223_P(), 18);
            }
            if (RebornConfig.PLANT_GENERATION.flowerGeneration) {
                if ((BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0 && world.func_180495_p((topBlock = world.func_175672_r(pos)).func_177977_b()).func_185914_p() && !world.func_180495_p(topBlock).func_185904_a().func_76224_d()) {
                    world.func_180501_a(topBlock.func_177984_a(), BlockHandler.WEST_INDIAN_LILAC.func_176223_P(), 18);
                    world.func_180501_a(topBlock, BlockHandler.WEST_INDIAN_LILAC.func_176223_P().func_177226_a(DoublePlantBlock.HALF, (Comparable)((Object)DoublePlantBlock.BlockHalf.LOWER)), 18);
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && rand.nextInt(8) == 0 && world.func_180495_p((topBlock = world.func_175672_r(pos)).func_177977_b()).func_185914_p() && !world.func_180495_p(topBlock).func_185904_a().func_76224_d()) {
                    world.func_180501_a(topBlock.func_177984_a(), BlockHandler.HELICONIA.func_176223_P(), 18);
                    world.func_180501_a(topBlock, BlockHandler.HELICONIA.func_176223_P().func_177226_a(DoublePlantBlock.HALF, (Comparable)((Object)DoublePlantBlock.BlockHalf.LOWER)), 18);
                }
            }
            if (RebornConfig.PLANT_GENERATION.gracilariaGeneration && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && rand.nextInt(8) == 0 && (topBlock = world.func_175672_r(pos)).func_177956_o() < 62 && (state = world.func_180495_p(topBlock.func_177977_b())).func_185914_p()) {
                world.func_180501_a(topBlock, BlockHandler.GRACILARIA.func_176223_P(), 18);
            }
            if (RebornConfig.PLANT_GENERATION.peatGeneration && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && rand.nextInt(2) == 0) {
                new WorldGenMinable(BlockHandler.PEAT.func_176223_P(), 5, input -> input == Blocks.field_150346_d.func_176223_P() || input == Blocks.field_150349_c.func_176223_P()).func_180709_b(world, rand, world.func_175672_r(pos));
            }
            if (RebornConfig.MINERAL_GENERATION.trackwayGeneration) {
                int footprintChance = 20;
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                    footprintChance = 10;
                }
                if (rand.nextInt(footprintChance) == 0) {
                    int y = rand.nextInt(20) + 30;
                    FossilizedTrackwayBlock.TrackwayType type = FossilizedTrackwayBlock.TrackwayType.values()[rand.nextInt(FossilizedTrackwayBlock.TrackwayType.values().length)];
                    for (int i = 0; i < rand.nextInt(2) + 1; ++i) {
                        BlockPos basePos = new BlockPos(pos.func_177958_n() + rand.nextInt(10) + 3, y, pos.func_177952_p() + rand.nextInt(10) + 3);
                        float angle = (float)(rand.nextDouble() * 360.0);
                        IBlockState trackway = BlockHandler.FOSSILIZED_TRACKWAY.func_176223_P().func_177226_a((IProperty)FossilizedTrackwayBlock.FACING, (Comparable)EnumFacing.func_176733_a((double)angle)).func_177226_a(FossilizedTrackwayBlock.VARIANT, (Comparable)((Object)type));
                        float xOffset = -MathHelper.func_76126_a((float)((float)Math.toRadians(angle)));
                        float zOffset = MathHelper.func_76134_b((float)((float)Math.toRadians(angle)));
                        for (int l = 0; l < rand.nextInt(2) + 3; ++l) {
                            BlockPos trackwayPos = basePos.func_177963_a((double)(xOffset * (float)l), 0.0, (double)(zOffset * (float)l));
                            if (world.func_180495_p(trackwayPos).func_177230_c() != Blocks.field_150348_b) continue;
                            world.func_180501_a(trackwayPos, trackway, 18);
                        }
                    }
                }
            }
        }
    }

    public boolean dimCheck(int id, int[] dims) {
        for (int i = 0; i < dims.length; ++i) {
            int dim = dims[i];
            if (dim != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootTable table = event.getTable();
        Loot.handleTable(table, name);
    }

    @SubscribeEvent
    public void fall(LivingFallEvent e) {
        e.setCanceled(e.getEntity().func_184187_bx() instanceof HelicopterEntity);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        Random rand = event.getWorld().field_73012_v;
        if (rand.nextInt(2) == 0) {
            ArrayList<BugItem> bugs = new ArrayList<BugItem>();
            if (state.func_177230_c() == Blocks.field_150407_cf) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            } else if (state.func_177230_c() == Blocks.field_150349_c) {
                if (rand.nextInt(6) == 0) {
                    bugs.add(ItemHandler.CRICKETS);
                }
            } else if (state.func_177230_c() == Blocks.field_150329_H) {
                if (rand.nextInt(5) == 0) {
                    bugs.add(ItemHandler.CRICKETS);
                }
            } else if (state.func_177230_c() == Blocks.field_150423_aK || state.func_177230_c() == Blocks.field_150440_ba) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            } else if (state.func_177230_c() == Blocks.field_150375_by) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            }
            if (bugs.size() > 0) {
                event.getDrops().add(new ItemStack((Item)bugs.get(rand.nextInt(bugs.size()))));
            }
        }
    }

    @SubscribeEvent
    public void preventSharkOverspawning(EntityJoinWorldEvent e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        if (!(e.getEntity() instanceof EntityShark)) {
            return;
        }
        EntityShark shark = (EntityShark)e.getEntity();
        if (shark.isSpawnedByEgg) {
            return;
        }
        AxisAlignedBB boundingBox = new AxisAlignedBB(shark.field_70165_t - 64.0, shark.field_70163_u - 64.0, shark.field_70161_v - 64.0, shark.field_70165_t + 64.0, shark.field_70163_u + 64.0, shark.field_70161_v + 64.0);
        int sharkCount = e.getWorld().func_72872_a(EntityShark.class, boundingBox).size();
        if (sharkCount >= 2) {
            shark.func_70106_y();
            System.out.println("Shark prevented from overspawning. Current count: " + sharkCount);
        }
    }
}

