/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.food;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.reborn.RebornMod;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.tree.TreeType;
import mod.reborn.server.entity.Diet;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.food.FoodType;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.plant.Plant;
import mod.reborn.server.plant.PlantHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import org.apache.logging.log4j.Level;

public class FoodHelper {
    private static final Map<FoodType, List<FoodKey>> FOOD_TYPES = new EnumMap<FoodType, List<FoodKey>>(FoodType.class);
    private static final List<FoodKey> FOODS = new LinkedList<FoodKey>();
    private static final Map<FoodKey, Integer> HEAL_AMOUNTS = new HashMap<FoodKey, Integer>();
    private static final Map<FoodKey, FoodEffect[]> FOOD_EFFECTS = new HashMap<FoodKey, FoodEffect[]>();

    public static void init() {
        FoodHelper.registerFood((Block)Blocks.field_150362_t, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150361_u, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150329_H, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150464_aj, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150440_ba, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150436_aH, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150345_g, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150423_aK, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150459_bM, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150469_bN, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150407_cf, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150392_bi, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150327_N, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150328_O, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150398_cm, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150338_P, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150337_Q, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood(ItemHandler.COCKROACHES, FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood(ItemHandler.CRICKETS, FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood(ItemHandler.MEALWORM_BEETLES, FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood(ItemHandler.KRILL, FoodType.FILTER, 250, new FoodEffect[0]);
        FoodHelper.registerFood(ItemHandler.PLANKTON, FoodType.FILTER, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_CYCADEOIDEA, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_CYCAD, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_FERN, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_LEAVES, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_OTHER, FoodType.PLANT, 5000, new FoodEffect[0]);
        for (Plant plant : PlantHandler.getPlants()) {
            FoodHelper.registerFood(plant.getBlock(), FoodType.PLANT, plant.getHealAmount(), plant.getEffects());
        }
        for (TreeType type : TreeType.values()) {
            FoodHelper.registerFood((Block)BlockHandler.ANCIENT_LEAVES.get((Object)type), FoodType.PLANT, 2000, new FoodEffect[0]);
            FoodHelper.registerFood((Block)BlockHandler.ANCIENT_SAPLINGS.get((Object)type), FoodType.PLANT, 1000, new FoodEffect[0]);
        }
        FoodHelper.registerFood(Items.field_151015_O, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151014_N, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151081_bc, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151080_bb, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((ItemFood)Items.field_151115_aP, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((ItemFood)Items.field_179566_aV, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.DINOSAUR_MEAT, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.DINOSAUR_STEAK, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.GOAT_RAW, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.GOAT_COOKED, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.SHARK_MEAT_RAW, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.SHARK_MEAT_COOKED, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.CRAB_MEAT_COOKED, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.CRAB_MEAT_RAW, FoodType.FISH, new FoodEffect[0]);
        for (Item item : Item.field_150901_e) {
            ItemFood food;
            if (!(item instanceof ItemFood)) continue;
            FoodHelper.registerFoodAuto(food, (food = (ItemFood)item).func_77845_h() ? FoodType.MEAT : FoodType.PLANT, new FoodEffect[0]);
        }
    }

    public static void registerFoodAuto(ItemFood food, FoodType foodType, FoodEffect ... effects) {
        FoodHelper.registerFood(new FoodKey((Item)food), foodType, food.func_150905_g(new ItemStack((Item)food)) * 650, effects);
    }

    public static void registerFood(Item food, FoodType foodType, int healAmount, FoodEffect ... effects) {
        FoodHelper.registerFood(new FoodKey(food), foodType, healAmount, effects);
    }

    private static void registerFood(FoodKey food, FoodType foodType, int healAmount, FoodEffect ... effects) {
        if (!FOODS.contains(food)) {
            if (food == null || food.hashCode() == 0) {
                RebornMod.getLogger().log(Level.ERROR, "Something tried to register an invalid food!");
                return;
            }
            List<FoodKey> foodsForType = FOOD_TYPES.get((Object)foodType);
            if (foodsForType == null) {
                foodsForType = new ArrayList<FoodKey>();
            }
            foodsForType.add(food);
            FOODS.add(food);
            FOOD_TYPES.put(foodType, foodsForType);
            HEAL_AMOUNTS.put(food, healAmount);
            FOOD_EFFECTS.put(food, effects);
        }
    }

    public static void registerFood(Block food, FoodType foodType, int foodAmount, FoodEffect ... effects) {
        FoodHelper.registerFood(new FoodKey(food), foodType, foodAmount, effects);
    }

    public static List<FoodKey> getFoodType(FoodType type) {
        return FOOD_TYPES.get((Object)type);
    }

    public static List<Item> getFoodItems(FoodType type) {
        return FoodHelper.getValidItemList(FOOD_TYPES.get((Object)type));
    }

    private static List<Item> getValidItemList(List<FoodKey> keys) {
        return keys.stream().map(key -> {
            Item itm;
            if (key.item != null) {
                return key.item;
            }
            if (key.block != null && (itm = Item.func_150898_a((Block)key.block)) != Items.field_190931_a) {
                return itm;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static FoodType getFoodType(FoodKey key) {
        for (FoodType foodType : FoodType.values()) {
            if (!FoodHelper.getFoodType(foodType).contains(key)) continue;
            return foodType;
        }
        return null;
    }

    public static FoodType getFoodType(Item item) {
        return FoodHelper.getFoodType(new FoodKey(item));
    }

    public static FoodType getFoodType(Block block) {
        return FoodHelper.getFoodType(new FoodKey(block));
    }

    public static boolean isFoodType(Item item, FoodType foodType) {
        return FoodHelper.getFoodType(foodType).contains(new FoodKey(item));
    }

    public static boolean isEdible(DinosaurEntity entity, Diet diet, Item item) {
        return item != null && FoodHelper.getEdibleFoods(entity, diet).contains(new FoodKey(item));
    }

    public static boolean isEdible(DinosaurEntity entity, Diet diet, Block block) {
        return block != null && FoodHelper.getEdibleFoods(entity, diet).contains(new FoodKey(block));
    }

    public static HashSet<Item> getEdibleFoodItems(DinosaurEntity entity, Diet diet) {
        return Sets.newHashSet(FoodHelper.getValidItemList(FoodHelper.getEdibleFoods(entity, diet)));
    }

    public static List<FoodKey> getEdibleFoods(DinosaurEntity entity, Diet diet) {
        ArrayList<FoodKey> possibleItems = new ArrayList<FoodKey>();
        for (Diet.DietModule module : diet.getModules()) {
            if (!module.applies(entity)) continue;
            possibleItems.addAll(FoodHelper.getFoodType(module.getFoodType()));
        }
        return possibleItems;
    }

    public static int getHealAmount(Item item) {
        return HEAL_AMOUNTS.getOrDefault(new FoodKey(item), 0);
    }

    public static void applyEatEffects(DinosaurEntity entity, Item item) {
        FoodEffect[] effects = FOOD_EFFECTS.get(new FoodKey(item));
        if (effects != null) {
            for (FoodEffect effect : effects) {
                if (entity.func_70681_au().nextInt(100) > effect.chance) continue;
                entity.func_70690_d(effect.effect);
            }
        }
    }

    public static boolean isFood(Item item) {
        return FOODS.contains(new FoodKey(item));
    }

    static class FoodKey {
        final Item item;
        final Block block;

        FoodKey(Item item) {
            this.item = item;
            this.block = null;
        }

        FoodKey(Block block) {
            Item blkItm = Item.func_150898_a((Block)block);
            this.item = blkItm != Items.field_190931_a ? blkItm : null;
            this.block = blkItm == Items.field_190931_a ? block : null;
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }

        public int hashCode() {
            return this.item != null && this.item != Items.field_190931_a ? this.item.hashCode() : (this.block != null && this.block != Blocks.field_150350_a ? this.block.hashCode() : 0);
        }
    }

    public static class FoodEffect {
        public PotionEffect effect;
        public int chance;

        public FoodEffect(PotionEffect effect, int chance) {
            this.effect = effect;
            this.chance = chance;
        }
    }
}

