/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.genetics;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mod.reborn.server.genetics.DinosaurDNAStorageType;
import mod.reborn.server.genetics.PlantDNAStorageType;
import mod.reborn.server.genetics.StorageType;

public class StorageTypeRegistry {
    private static final Map<String, Supplier<? extends StorageType>> STORAGE_TYPES = new HashMap<String, Supplier<? extends StorageType>>();

    public static void init() {
        StorageTypeRegistry.register("DinoDNA", (Supplier<? extends StorageType>)((Supplier)DinosaurDNAStorageType::new));
        StorageTypeRegistry.register("PlantDNA", (Supplier<? extends StorageType>)((Supplier)PlantDNAStorageType::new));
    }

    private static void register(String id, Supplier<? extends StorageType> storageType) {
        STORAGE_TYPES.put(id, Objects.requireNonNull(storageType));
    }

    public static StorageType getStorageType(String id) {
        if (id == null || id.isEmpty()) {
            id = "DinoDNA";
        }
        return (StorageType)STORAGE_TYPES.get(id).get();
    }
}

