/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.tab.TabHandler;
import mod.reborn.server.util.LangUtils;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DinosaurSpawnEggItem
extends Item {
    public DinosaurSpawnEggItem() {
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.EGGS);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return true;
    }

    public DinosaurEntity spawnDinosaur(World world, EntityPlayer player, ItemStack stack, double x, double y, double z) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        if (dinosaur != null) {
            Class<? extends DinosaurEntity> entityClass = dinosaur.getDinosaurClass();
            try {
                DinosaurEntity entity = entityClass.getConstructor(World.class).newInstance(player.field_70170_p);
                entity.setDNAQuality(100);
                int mode = this.getMode(stack);
                if (mode > 0) {
                    entity.setMale(mode == 1);
                }
                if (player.func_70093_af()) {
                    entity.setAge(0);
                }
                entity.func_70107_b(x, y, z);
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entity.field_70759_as = entity.field_70177_z;
                entity.field_70761_aq = entity.field_70177_z;
                return entity;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            int mode = this.changeMode(stack);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LangUtils.translate(LangUtils.GENDER_CHANGE.get("spawnegg"), new Object[0]).replace("{mode}", LangUtils.getGenderMode(mode))));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{dino}", LangUtils.getDinoName(this.getDinosaur(stack)));
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = EntityHandler.getDinosaurById(stack.func_77952_i());
        if (dinosaur == null) {
            dinosaur = EntityHandler.VELOCIRAPTOR;
        }
        return dinosaur;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        DinosaurEntity dinosaur;
        TileEntity tile;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150474_ac && (tile = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic spawnerLogic = ((TileEntityMobSpawner)tile).func_145881_a();
            spawnerLogic.func_190894_a(EntityList.func_191306_a(this.getDinosaur(stack).getDinosaurClass()));
            tile.func_70296_d();
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.func_177972_a(side);
        double yOffset = 0.0;
        if (side == EnumFacing.UP && state.func_177230_c() instanceof BlockFence) {
            yOffset = 0.5;
        }
        if ((dinosaur = this.spawnDinosaur(world, player, stack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + 0.5)) != null) {
            if (stack.func_82837_s()) {
                dinosaur.func_96094_a(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            world.func_72838_d((Entity)dinosaur);
            dinosaur.func_70642_aH();
        }
        return EnumActionResult.SUCCESS;
    }

    public int getMode(ItemStack stack) {
        return this.getNBT(stack).func_74762_e("GenderMode");
    }

    public int changeMode(ItemStack stack) {
        NBTTagCompound nbt = this.getNBT(stack);
        int mode = this.getMode(stack) + 1;
        nbt.func_74768_a("GenderMode", mode %= 3);
        stack.func_77982_d(nbt);
        return mode;
    }

    public NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        stack.func_77982_d(nbt);
        return nbt;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> lore, ITooltipFlag tooltipFlag) {
        lore.add(TextFormatting.BLUE + I18n.func_135052_a((String)"lore.baby_dino.name", (Object[])new Object[0]));
        lore.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"lore.change_gender.name", (Object[])new Object[0]));
    }
}

