/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import mod.reborn.client.render.RenderingHandler;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.DisplayBlock;
import mod.reborn.server.block.entity.DisplayBlockEntity;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.tab.TabHandler;
import mod.reborn.server.util.LangUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisplayBlockItem
extends Item {
    public DisplayBlockItem() {
        this.func_77637_a(TabHandler.DECORATIONS);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels(Collection<Dinosaur> dinos, RenderingHandler renderer) {
        for (Dinosaur dino : dinos) {
            int dex = EntityHandler.getDinosaurId(dino);
            String dinoName = dino.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
            RenderingHandler.registerItemRenderer(this, DisplayBlockItem.getMetadata(dex, 0, false), "action_figure/action_figure_" + dinoName);
            RenderingHandler.registerItemRenderer(this, DisplayBlockItem.getMetadata(dex, 1, false), "action_figure/action_figure_" + dinoName);
            RenderingHandler.registerItemRenderer(this, DisplayBlockItem.getMetadata(dex, 2, false), "action_figure/action_figure_" + dinoName);
            if (!dino.isHybrid) {
                RenderingHandler.registerItemRenderer(this, DisplayBlockItem.getMetadata(dex, 1, true), "skeleton/fossil/skeleton_fossil_" + dinoName);
            }
            RenderingHandler.registerItemRenderer(this, DisplayBlockItem.getMetadata(dex, 2, true), "skeleton/fresh/skeleton_fresh_" + dinoName);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        DisplayBlock block;
        pos = pos.func_177972_a(side);
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && (block = BlockHandler.DISPLAY_BLOCK).func_176196_c(world, pos)) {
            IBlockState state = block.func_176223_P();
            world.func_175656_a(pos, block.func_180642_a(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player));
            block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            int mode = this.getVariant(stack);
            DisplayBlockEntity tile = (DisplayBlockEntity)world.func_175625_s(pos);
            if (tile != null) {
                tile.setDinosaur(this.getDinosaurID(stack), mode > 0 ? mode == 1 : world.field_73012_v.nextBoolean(), this.isSkeleton(stack));
                tile.setRot(180 - (int)player.func_70079_am());
                world.func_184138_a(pos, state, state, 0);
                tile.func_70296_d();
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public String func_77653_i(ItemStack stack) {
        String dinoName = LangUtils.getDinoName(this.getDinosaur(stack));
        if (!this.isSkeleton(stack)) {
            return LangUtils.translate("item.action_figure.name", new Object[0]).replace("{dino}", dinoName);
        }
        return LangUtils.translate("item.skeleton." + (this.getVariant(stack) == 1 ? "fossil" : "fresh") + ".name", new Object[0]).replace("{dino}", dinoName);
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(this.getDinosaurID(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaur.shouldRegister()) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), 0, false)));
                if (!dinosaur.isHybrid) {
                    subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), 1, true)));
                }
                subtypes.add((Object)new ItemStack((Item)this, 1, DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), 2, true)));
            }
        }
    }

    public static int getMetadata(int dinosaur, int variant, boolean isSkeleton) {
        return dinosaur << 4 | variant << 1 | (isSkeleton ? 1 : 0);
    }

    public int getDinosaurID(ItemStack stack) {
        return stack.func_77960_j() >> 4 & 0xFFFF;
    }

    public int getVariant(ItemStack stack) {
        return stack.func_77960_j() >> 1 & 7;
    }

    public boolean isSkeleton(ItemStack stack) {
        return (stack.func_77960_j() & 1) == 1;
    }

    public int changeMode(ItemStack stack) {
        int dinosaur = this.getDinosaurID(stack);
        boolean skeleton = this.isSkeleton(stack);
        int mode = this.getVariant(stack) + 1;
        stack.func_77964_b(DisplayBlockItem.getMetadata(dinosaur, mode %= 3, skeleton));
        return mode;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lore, ITooltipFlag tooltipFlag) {
        if (!this.isSkeleton(stack)) {
            lore.add(TextFormatting.BLUE + I18n.func_135052_a((String)"lore.change_gender.name", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isSkeleton(stack)) {
            int mode = this.changeMode(stack);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LangUtils.translate(LangUtils.GENDER_CHANGE.get("actionfigure"), new Object[0]).replace("{mode}", LangUtils.getGenderMode(mode))));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

