/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2d;
import mod.reborn.server.api.GrindableItem;
import mod.reborn.server.api.Hybrid;
import mod.reborn.server.block.BlockHandler;
import mod.reborn.server.block.SkullDisplay;
import mod.reborn.server.block.entity.SkullDisplayEntity;
import mod.reborn.server.dinosaur.AchillobatorDinosaur;
import mod.reborn.server.dinosaur.AllosaurusDinosaur;
import mod.reborn.server.dinosaur.AnkylodocusDinosaur;
import mod.reborn.server.dinosaur.AnkylosaurusDinosaur;
import mod.reborn.server.dinosaur.ApatosaurusDinosaur;
import mod.reborn.server.dinosaur.ArsinoitheriumDinosaur;
import mod.reborn.server.dinosaur.BaryonyxDinosaur;
import mod.reborn.server.dinosaur.BrachiosaurusDinosaur;
import mod.reborn.server.dinosaur.CamarasaurusDinosaur;
import mod.reborn.server.dinosaur.CarcharodontosaurusDinosaur;
import mod.reborn.server.dinosaur.CarnotaurusDinosaur;
import mod.reborn.server.dinosaur.CearadactylusDinosaur;
import mod.reborn.server.dinosaur.CeratosaurusDinosaur;
import mod.reborn.server.dinosaur.ChasmosaurusDinosaur;
import mod.reborn.server.dinosaur.CorythosaurusDinosaur;
import mod.reborn.server.dinosaur.DeinotheriumDinosaur;
import mod.reborn.server.dinosaur.DilophosaurusDinosaur;
import mod.reborn.server.dinosaur.DimetrodonDinosaur;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.dinosaur.DiplodocusDinosaur;
import mod.reborn.server.dinosaur.DreadnoughtusDinosaur;
import mod.reborn.server.dinosaur.DunkleosteusDinosaur;
import mod.reborn.server.dinosaur.EdmontosaurusDinosaur;
import mod.reborn.server.dinosaur.ElasmotheriumDinosaur;
import mod.reborn.server.dinosaur.GiganotosaurusDinosaur;
import mod.reborn.server.dinosaur.HerrerasaurusDinosaur;
import mod.reborn.server.dinosaur.HyaenodonDinosaur;
import mod.reborn.server.dinosaur.IndominusDinosaur;
import mod.reborn.server.dinosaur.IndoraptorDinosaur;
import mod.reborn.server.dinosaur.LambeosaurusDinosaur;
import mod.reborn.server.dinosaur.LudodactylusDinosaur;
import mod.reborn.server.dinosaur.MajungasaurusDinosaur;
import mod.reborn.server.dinosaur.MamenchisaurusDinosaur;
import mod.reborn.server.dinosaur.MammothDinosaur;
import mod.reborn.server.dinosaur.MawsoniaDinosaur;
import mod.reborn.server.dinosaur.MegatheriumDinosaur;
import mod.reborn.server.dinosaur.MetriacanthosaurusDinosaur;
import mod.reborn.server.dinosaur.MosasaurusDinosaur;
import mod.reborn.server.dinosaur.PachycephalosaurusDinosaur;
import mod.reborn.server.dinosaur.ParaceratheriumDinosaur;
import mod.reborn.server.dinosaur.ParasaurolophusDinosaur;
import mod.reborn.server.dinosaur.PostosuchusDinosaur;
import mod.reborn.server.dinosaur.ProtoceratopsDinosaur;
import mod.reborn.server.dinosaur.PteranodonDinosaur;
import mod.reborn.server.dinosaur.QuetzalDinosaur;
import mod.reborn.server.dinosaur.RaphusrexDinosaur;
import mod.reborn.server.dinosaur.RugopsDinosaur;
import mod.reborn.server.dinosaur.SinoceratopsDinosaur;
import mod.reborn.server.dinosaur.SmilodonDinosaur;
import mod.reborn.server.dinosaur.SpinoraptorDinosaur;
import mod.reborn.server.dinosaur.SpinosaurusDinosaur;
import mod.reborn.server.dinosaur.StegosaurusDinosaur;
import mod.reborn.server.dinosaur.StyracosaurusDinosaur;
import mod.reborn.server.dinosaur.SuchomimusDinosaur;
import mod.reborn.server.dinosaur.TherizinosaurusDinosaur;
import mod.reborn.server.dinosaur.TitanisDinosaur;
import mod.reborn.server.dinosaur.TriceratopsDinosaur;
import mod.reborn.server.dinosaur.TropeognathusDinosaur;
import mod.reborn.server.dinosaur.TylosaurusDinosaur;
import mod.reborn.server.dinosaur.TyrannosaurusDinosaur;
import mod.reborn.server.dinosaur.VelociraptorDinosaur;
import mod.reborn.server.dinosaur.VelociraptorSquad;
import mod.reborn.server.entity.EntityHandler;
import mod.reborn.server.item.ItemHandler;
import mod.reborn.server.tab.TabHandler;
import mod.reborn.server.util.LangUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class FossilItem
extends Item
implements GrindableItem {
    public static Map<String, List<Dinosaur>> fossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    public static Map<String, List<Dinosaur>> freshFossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    private String type;
    private boolean fresh;

    public FossilItem(String type, boolean fresh) {
        this.type = type.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        this.fresh = fresh;
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.FOSSILS);
    }

    public static void init() {
        for (boolean fresh : new boolean[]{true, false}) {
            for (Dinosaur dinosaur : EntityHandler.getDinosaurs().values()) {
                String[] boneTypes;
                if (!fresh && dinosaur instanceof Hybrid) continue;
                Map<String, List<Dinosaur>> map = fresh ? freshFossilDinosaurs : fossilDinosaurs;
                for (String boneType : boneTypes = dinosaur.getBones()) {
                    List<Dinosaur> dinosaursWithType = map.get(boneType);
                    if (dinosaursWithType == null) {
                        dinosaursWithType = new ArrayList<Dinosaur>();
                    }
                    if (!dinosaur.getName().equals("")) {
                        dinosaursWithType.add(dinosaur);
                    }
                    map.put(boneType, dinosaursWithType);
                }
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        if (dinosaur != null) {
            return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{dino}", LangUtils.getDinoName(dinosaur));
        }
        return super.func_77653_i(stack);
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(EntityHandler.getRegisteredDinosaurs());
        Collections.sort(dinosaurs);
        List<Dinosaur> dinosaursForType = this.getMap().get(this.type);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaursForType.contains(dinosaur) || !this.fresh && dinosaur instanceof Hybrid) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> lore, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Genetics") && nbt.func_74764_b("DNAQuality")) {
            int quality = nbt.func_74762_e("DNAQuality");
            TextFormatting colour = quality > 75 ? TextFormatting.GREEN : (quality > 50 ? TextFormatting.YELLOW : (quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
            lore.add(colour + LangUtils.translate(LangUtils.LORE.get("dna_quality"), new Object[0]).replace("{quality}", LangUtils.getFormattedQuality(quality)));
            lore.add(TextFormatting.BLUE + LangUtils.translate(LangUtils.LORE.get("genetic_code"), new Object[0]).replace("{code}", LangUtils.getFormattedGenetics(nbt.func_74779_i("Genetics"))));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AchillobatorDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorEchoDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorBlueDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorDeltaDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorCharlieDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AllosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BaryonyxDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylodocusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ArsinoitheriumDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ApatosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BrachiosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CamarasaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarcharodontosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CeratosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ChasmosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarnotaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CorythosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CearadactylusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DreadnoughtusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DiplodocusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DeinotheriumDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DunkleosteusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == EdmontosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ElasmotheriumDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HerrerasaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == GiganotosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndominusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HyaenodonDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndoraptorDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DimetrodonDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LudodactylusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MajungasaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LambeosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MawsoniaDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MamenchisaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MammothDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PachycephalosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DilophosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MetriacanthosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MegatheriumDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MosasaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ProtoceratopsDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParasaurolophusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PostosuchusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PteranodonDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SuchomimusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StegosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SmilodonDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StyracosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinoraptorDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SinoceratopsDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RaphusrexDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RugopsDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == QuetzalDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TherizinosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TylosaurusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TropeognathusDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TriceratopsDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TitanisDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParaceratheriumDinosaur.class) {
            lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
            lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
        }
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public String getBoneType() {
        return this.type;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing.Axis axis;
        SkullDisplayEntity tile;
        IBlockState state;
        IBlockState blockstatePlacement;
        IBlockState blockstate = world.func_180495_p(pos);
        Block worldBlock = blockstate.func_177230_c();
        if (worldBlock.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
            pos = pos.func_177977_b();
        }
        if (!(worldBlock = world.func_180495_p(pos).func_177230_c()).func_176200_f((IBlockAccess)world, pos)) {
            if (!world.func_180495_p(pos).func_185904_a().func_76220_a() || !world.isSideSolid(pos, side, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.func_177972_a(side);
        }
        ItemStack stack = player.func_184586_b(hand);
        SkullDisplay block = BlockHandler.SKULL_DISPLAY;
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorEchoDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MajungasaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LambeosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LudodactylusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorBlueDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorCharlieDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorDeltaDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ArsinoitheriumDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TylosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TropeognathusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TriceratopsDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TitanisDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParaceratheriumDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TherizinosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BaryonyxDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AllosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AchillobatorDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylodocusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndoraptorDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ApatosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BrachiosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CamarasaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarcharodontosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarnotaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CeratosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CearadactylusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CorythosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ChasmosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DreadnoughtusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MammothDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MawsoniaDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MamenchisaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DiplodocusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DeinotheriumDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DunkleosteusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == EdmontosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ElasmotheriumDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParasaurolophusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ProtoceratopsDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PostosuchusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PteranodonDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HerrerasaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == GiganotosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndominusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SuchomimusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StyracosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StegosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SmilodonDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinoraptorDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SinoceratopsDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RaphusrexDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RugopsDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == QuetzalDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DimetrodonDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MegatheriumDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DilophosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PachycephalosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MosasaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MetriacanthosaurusDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HyaenodonDinosaur.class) {
            if (side == EnumFacing.DOWN) {
                return EnumActionResult.FAIL;
            }
            if (block.func_176196_c(world, pos)) {
                blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(pos);
                if (state.func_177230_c() == block) {
                    ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                }
                world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                tile = (SkullDisplayEntity)world.func_175625_s(pos);
                if (tile != null) {
                    tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                    axis = side.func_176740_k();
                    if (axis == EnumFacing.Axis.Y) {
                        tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                    } else if (axis == EnumFacing.Axis.X) {
                        tile.setAngle((short)side.func_185119_l());
                    } else if (axis == EnumFacing.Axis.Z) {
                        tile.setAngle((short)(180.0f + side.func_185119_l()));
                    }
                    world.func_184138_a(pos, state, state, 0);
                    tile.func_70296_d();
                    stack.func_190918_g(1);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private static short angleToPlayer(BlockPos block, Vector2d player) {
        return (short)(90.0 - Math.toDegrees(Math.atan2((double)block.func_177952_p() + 0.5 - player.y, (double)block.func_177958_n() + 0.5 - player.x)));
    }

    public static boolean getHasStand(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Type")) {
            return stack.func_77978_p().func_74767_n("Type");
        }
        return true;
    }

    public static void setHasStand(ItemStack stack, boolean hasStand) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74757_a("Type", hasStand);
    }

    public static boolean changeStandType(ItemStack stack) {
        boolean newType = !FossilItem.getHasStand(stack);
        FossilItem.setHasStand(stack, newType);
        return newType;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        TextComponentString change;
        boolean type;
        boolean oldType;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AchillobatorDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndominusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorDeltaDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorBlueDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorCharlieDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == VelociraptorSquad.VelociraptorEchoDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BaryonyxDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ArsinoitheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AllosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylodocusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == AnkylosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ApatosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == BrachiosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CamarasaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarcharodontosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CeratosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CarnotaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CorythosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == CearadactylusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ChasmosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DeinotheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DreadnoughtusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DiplodocusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DeinotheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HerrerasaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == EdmontosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ElasmotheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == GiganotosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == HyaenodonDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DimetrodonDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == IndoraptorDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LudodactylusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == LambeosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MajungasaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MawsoniaDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MamenchisaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MetriacanthosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == DilophosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PachycephalosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MosasaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MegatheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == MammothDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParasaurolophusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PostosuchusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ProtoceratopsDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RugopsDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == RaphusrexDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SinoceratopsDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SpinoraptorDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == QuetzalDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SmilodonDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StegosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == StyracosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == SuchomimusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == PteranodonDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TropeognathusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TherizinosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TylosaurusDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TitanisDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == ParaceratheriumDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull") && ((FossilItem)stack.func_77973_b()).getDinosaur(stack).getClass() == TriceratopsDinosaur.class) {
            oldType = FossilItem.getHasStand(stack);
            type = FossilItem.changeStandType(stack);
            if (type != oldType && world.field_72995_K) {
                change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(6);
        if (outputType == 5 || this.fresh) {
            ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, stack.func_77952_i());
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 3) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        ArrayList list = Lists.newArrayList();
        this.getMap().get(this.type).forEach(dino -> list.add(new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dino))));
        return list;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        float single = 16.666666f;
        NBTTagCompound tag = inputItem.func_77978_p();
        ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, inputItem.func_77952_i());
        output.func_77982_d(tag);
        if (this.fresh) {
            return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(100.0f), (Object)output)});
        }
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(single), (Object)output), Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 15)), Pair.of((Object)Float.valueOf(single * 2.0f), (Object)new ItemStack(Items.field_151145_ak))});
    }

    public Map<String, List<Dinosaur>> getMap() {
        return this.fresh ? freshFossilDinosaurs : fossilDinosaurs;
    }
}

